/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util;

import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultPackageSettings
implements PackageSettings<PackageInfo> {
    private static final String PIP_EDITABLE = "--editable";
    private static final String PIP_IGNORE_INSTALLED = "--ignore-installed";
    private final File projectDir;

    public DefaultPackageSettings(File projectDir) {
        this.projectDir = projectDir;
    }

    @Override
    public Map<String, String> getEnvironment(PackageInfo packageInfo) {
        return Collections.emptyMap();
    }

    @Override
    public List<String> getGlobalOptions(PackageInfo packageInfo) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getInstallOptions(PackageInfo packageInfo) {
        String version = packageInfo.getVersion();
        ArrayList<String> options = new ArrayList<String>();
        if (version != null && version.contains("-") || this.requiresSourceBuild(packageInfo)) {
            options.add(PIP_IGNORE_INSTALLED);
        }
        if (this.isProjectDirectory(packageInfo)) {
            options.add(PIP_EDITABLE);
        }
        return options;
    }

    @Override
    public List<String> getBuildOptions(PackageInfo packageInfo) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getConfigureOptions(PackageInfo packageInfo) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getSupportedLanguageVersions(PackageInfo packageInfo) {
        return Collections.emptyList();
    }

    @Override
    public boolean requiresSourceBuild(PackageInfo packageInfo) {
        String version = packageInfo.getVersion();
        if (this.isProjectDirectory(packageInfo)) {
            return true;
        }
        return version != null && version.contains("-");
    }

    @Override
    public boolean isCustomized(PackageInfo packageInfo) {
        return false;
    }

    private boolean isProjectDirectory(PackageInfo packageInfo) {
        File packageDir = packageInfo.getPackageFile();
        String version = packageInfo.getVersion();
        return version == null && Files.isDirectory(packageDir.toPath(), new LinkOption[0]) && this.projectDir.equals(packageDir);
    }
}

