/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action.pip;

import com.linkedin.gradle.python.exception.PipExecutionException;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.plugin.PythonHelpers;
import com.linkedin.gradle.python.tasks.action.pip.AbstractPipAction;
import com.linkedin.gradle.python.tasks.action.pip.WheelBuilder;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import com.linkedin.gradle.python.util.EnvironmentMerger;
import com.linkedin.gradle.python.util.OperatingSystem;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import com.linkedin.gradle.python.wheel.WheelCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecResult;

public class PipInstallAction
extends AbstractPipAction {
    private static Logger logger = Logging.getLogger(PipInstallAction.class);
    private final Path sitePackagesPath;
    private final WheelBuilder wheelBuilder;

    public PipInstallAction(PackageSettings<PackageInfo> packageSettings, Project project, ExternalExec externalExec, Map<String, String> baseEnvironment, PythonDetails pythonDetails, WheelCache wheelCache, EnvironmentMerger environmentMerger, Spec<PackageInfo> packageExcludeFilter) {
        super(packageSettings, project, externalExec, baseEnvironment, pythonDetails, wheelCache, environmentMerger, packageExcludeFilter);
        this.sitePackagesPath = PipInstallAction.findSitePackages(pythonDetails);
        this.wheelBuilder = new WheelBuilder(packageSettings, project, externalExec, baseEnvironment, pythonDetails, wheelCache, environmentMerger, packageExcludeFilter);
    }

    public Path getSitePackagesPath() {
        return this.sitePackagesPath;
    }

    private static Path findSitePackages(PythonDetails pythonDetails) {
        String pyVersion = pythonDetails.getPythonVersion().getPythonMajorMinor();
        if (OperatingSystem.current().isUnix()) {
            return pythonDetails.getVirtualEnv().toPath().resolve(Paths.get("lib", "python" + pyVersion, "site-packages"));
        }
        return pythonDetails.getVirtualEnv().toPath().resolve(Paths.get("Lib", "site-packages"));
    }

    @Override
    Logger getLogger() {
        return logger;
    }

    @Override
    void doPipOperation(PackageInfo packageInfo, List<String> extraArgs) {
        this.throwIfPythonVersionIsNotSupported(packageInfo);
        String pyVersion = this.pythonDetails.getPythonVersion().getPythonMajorMinor();
        String sanitizedName = packageInfo.getName().replace('-', '_');
        File egg = this.sitePackagesPath.resolve(sanitizedName + "-" + packageInfo.getVersion() + "-py" + pyVersion + ".egg-info").toFile();
        File dist = this.sitePackagesPath.resolve(sanitizedName + "-" + packageInfo.getVersion() + ".dist-info").toFile();
        if (!this.packageSettings.requiresSourceBuild(packageInfo) && (this.project.file((Object)egg).exists() || this.project.file((Object)dist).exists())) {
            if (PythonHelpers.isPlainOrVerbose(this.project)) {
                logger.lifecycle("Skipping {} - Installed", new Object[]{packageInfo.toShortHand()});
            }
            this.wheelBuilder.updateWheelReadiness(packageInfo);
            return;
        }
        Map<String, String> mergedEnv = this.environmentMerger.mergeEnvironments(Arrays.asList(this.baseEnvironment, this.packageSettings.getEnvironment(packageInfo)));
        List<String> commandLine = this.makeCommandLine(packageInfo, extraArgs);
        if (PythonHelpers.isPlainOrVerbose(this.project)) {
            logger.lifecycle("Installing {}", new Object[]{packageInfo.toShortHand()});
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ExecResult installResult = this.execCommand(mergedEnv, commandLine, stream);
        String message = ((Object)stream).toString().trim();
        if (installResult.getExitValue() != 0) {
            logger.error("Error installing package using `{}`", commandLine);
            logger.error(message);
            throw PipExecutionException.failedInstall(packageInfo, message);
        }
        logger.info(message);
    }

    private List<String> makeCommandLine(PackageInfo packageInfo, List<String> extraArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(this.baseInstallArguments());
        commandLine.addAll(extraArgs);
        commandLine.addAll(this.getGlobalOptions(packageInfo));
        commandLine.addAll(this.getInstallOptions(packageInfo));
        commandLine.add(this.wheelBuilder.getPackage(packageInfo, extraArgs).toString());
        return commandLine;
    }

    private List<String> baseInstallArguments() {
        return Arrays.asList(this.pythonDetails.getVirtualEnvInterpreter().toString(), this.pythonDetails.getVirtualEnvironment().getPip().toString(), "install", "--disable-pip-version-check", "--no-deps");
    }
}

