/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action.pip;

import com.linkedin.gradle.python.exception.PipExecutionException;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.extension.PythonVersion;
import com.linkedin.gradle.python.plugin.PythonHelpers;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import com.linkedin.gradle.python.util.EnvironmentMerger;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import com.linkedin.gradle.python.wheel.WheelCache;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

abstract class AbstractPipAction {
    final PackageSettings<PackageInfo> packageSettings;
    final Project project;
    final ExternalExec externalExec;
    final Map<String, String> baseEnvironment;
    final PythonDetails pythonDetails;
    final WheelCache wheelCache;
    final EnvironmentMerger environmentMerger;
    final PythonVersion pythonVersion;
    final Spec<PackageInfo> packageExcludeFilter;

    AbstractPipAction(PackageSettings<PackageInfo> packageSettings, Project project, ExternalExec externalExec, Map<String, String> baseEnvironment, PythonDetails pythonDetails, WheelCache wheelCache, EnvironmentMerger environmentMerger, Spec<PackageInfo> packageExcludeFilter) {
        this.packageSettings = packageSettings;
        this.project = project;
        this.externalExec = externalExec;
        this.baseEnvironment = baseEnvironment;
        this.pythonDetails = pythonDetails;
        this.wheelCache = wheelCache;
        this.environmentMerger = environmentMerger;
        this.pythonVersion = pythonDetails.getPythonVersion();
        this.packageExcludeFilter = packageExcludeFilter;
    }

    public void execute(PackageInfo packageInfo, List<String> extraArgs) {
        if (this.packageExcludeFilter != null && this.packageExcludeFilter.isSatisfiedBy((Object)packageInfo)) {
            if (PythonHelpers.isPlainOrVerbose(this.project)) {
                this.getLogger().lifecycle("Skipping {} - Excluded", new Object[]{packageInfo.toShortHand()});
            }
            return;
        }
        this.doPipOperation(packageInfo, extraArgs);
    }

    void throwIfPythonVersionIsNotSupported(PackageInfo packageInfo) {
        List<String> supportedVersions = this.packageSettings.getSupportedLanguageVersions(packageInfo);
        if (supportedVersions != null && !supportedVersions.isEmpty() && !supportedVersions.contains(this.pythonVersion.getPythonMajorMinor())) {
            throw PipExecutionException.unsupportedPythonVersion(packageInfo, supportedVersions);
        }
    }

    ExecResult execCommand(Map<String, String> mergedEnv, List<String> commandLine, OutputStream stream) {
        return this.externalExec.exec((Action<? super ExecSpec>)((Action)execSpec -> {
            execSpec.environment(mergedEnv);
            execSpec.commandLine((Iterable)commandLine);
            execSpec.setStandardOutput(stream);
            execSpec.setErrorOutput(stream);
            execSpec.setIgnoreExitValue(true);
        }));
    }

    List<String> getGlobalOptions(PackageInfo packageInfo) {
        List<String> globalOptions = this.packageSettings.getGlobalOptions(packageInfo);
        if (globalOptions == null) {
            return Collections.emptyList();
        }
        return globalOptions;
    }

    List<String> getInstallOptions(PackageInfo packageInfo) {
        List<String> installOptions = this.packageSettings.getInstallOptions(packageInfo);
        if (installOptions == null) {
            return Collections.emptyList();
        }
        return installOptions;
    }

    List<String> getBuildOptions(PackageInfo packageInfo) {
        List<String> buildOptions = this.packageSettings.getBuildOptions(packageInfo);
        if (buildOptions == null) {
            return Collections.emptyList();
        }
        return buildOptions;
    }

    abstract void doPipOperation(PackageInfo var1, List<String> var2);

    abstract Logger getLogger();
}

