/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action;

import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class VirtualEnvCustomizer
implements Consumer<File> {
    private static final int NO_CHANGE = 0;
    private static final int CHANGED = 1;
    private static final Logger log = Logging.getLogger(VirtualEnvCustomizer.class);
    private final String distutilsCfg;
    private final ExternalExec exec;
    private final PythonDetails pythonDetails;

    public VirtualEnvCustomizer(String distutilsCfg, ExternalExec exec, PythonDetails pythonDetails) {
        this.distutilsCfg = distutilsCfg;
        this.exec = exec;
        this.pythonDetails = pythonDetails;
    }

    @Override
    public void accept(File file) {
        if (this.distutilsCfg != null) {
            Path path = file.toPath();
            try {
                Files.write(path.resolve(Paths.get("virtualenv_embedded", "distutils.cfg")), this.distutilsCfg.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Path rebuildScriptPath = path.resolve(Paths.get("bin", "rebuild-script.py"));
            if (!Files.exists(rebuildScriptPath, new LinkOption[0])) {
                rebuildScriptPath = path.resolve(Paths.get("tasks", "update_embedded.py"));
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            File rebuildScript = rebuildScriptPath.toFile();
            ExecResult execResult = this.exec.exec((Action<? super ExecSpec>)((Action)execSpec -> {
                execSpec.commandLine(new Object[]{this.pythonDetails.getSystemPythonInterpreter(), rebuildScript});
                execSpec.setStandardOutput((OutputStream)stream);
                execSpec.setErrorOutput((OutputStream)stream);
                execSpec.setIgnoreExitValue(true);
            }));
            if (execResult.getExitValue() != 0 && execResult.getExitValue() != 1) {
                log.lifecycle(stream.toString());
                execResult.assertNormalExitValue();
            }
            log.info("Customized distutils.cfg");
        }
    }
}

