/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.wheel.AbiDetails;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ProbeVenvInfoAction {
    private static final String PROBE_DIR_NAME = "probe-venv";
    private static final Logger logger = Logging.getLogger(ProbeVenvInfoAction.class);

    private ProbeVenvInfoAction() {
    }

    static void probeVenv(Project project, PythonDetails pythonDetails, EditablePythonAbiContainer editablePythonAbiContainer) {
        try {
            ProbeVenvInfoAction.doProbe(project, pythonDetails, editablePythonAbiContainer);
        }
        catch (IOException ioe) {
            logger.info("Unable to probe venv for supported wheel details. Ignoring Venv.");
        }
    }

    public static void getProbedTags(Project project, PythonDetails pythonDetails, EditablePythonAbiContainer editablePythonAbiContainer) {
        File probeDir = new File(project.getBuildDir(), PROBE_DIR_NAME);
        File supportedAbiFormatsFile = ProbeVenvInfoAction.getSupportedAbiFormatsFile(probeDir, pythonDetails);
        try {
            ProbeVenvInfoAction.getSavedTags(pythonDetails, editablePythonAbiContainer, supportedAbiFormatsFile);
        }
        catch (IOException e) {
            logger.info("Unable to probe venv for supported wheel tags. Ignoring the error. May slow the build.");
        }
    }

    private static void doProbe(Project project, PythonDetails pythonDetails, EditablePythonAbiContainer editablePythonAbiContainer) throws IOException {
        InputStream wheelApiResource = ProbeVenvInfoAction.class.getClassLoader().getResourceAsStream("templates/wheel-api.py");
        byte[] buffer = new byte[wheelApiResource.available()];
        wheelApiResource.read(buffer);
        File probeDir = new File(project.getBuildDir(), PROBE_DIR_NAME);
        probeDir.mkdirs();
        FileOutputStream outStream = new FileOutputStream(ProbeVenvInfoAction.getPythonFileForSupportedWheels(probeDir));
        ((OutputStream)outStream).write(buffer);
        File supportedAbiFormatsFile = ProbeVenvInfoAction.getSupportedAbiFormatsFile(probeDir, pythonDetails);
        project.exec(execSpec -> {
            execSpec.commandLine(new Object[]{pythonDetails.getVirtualEnvInterpreter()});
            execSpec.args(new Object[]{ProbeVenvInfoAction.getPythonFileForSupportedWheels(probeDir)});
            execSpec.args(new Object[]{supportedAbiFormatsFile.getAbsolutePath()});
        });
        ProbeVenvInfoAction.getSavedTags(pythonDetails, editablePythonAbiContainer, supportedAbiFormatsFile);
    }

    private static void getSavedTags(PythonDetails pythonDetails, EditablePythonAbiContainer editablePythonAbiContainer, File supportedAbiFormatsFile) throws IOException {
        JsonArray array = Json.parse((Reader)new FileReader(supportedAbiFormatsFile)).asArray();
        for (JsonValue jsonValue : array) {
            JsonObject entry = jsonValue.asObject();
            String pythonTag = entry.get("pythonTag").asString();
            String abiTag = entry.get("abiTag").asString();
            String platformTag = entry.get("platformTag").asString();
            AbiDetails triple = new AbiDetails(pythonDetails.getVirtualEnvInterpreter(), pythonTag, abiTag, platformTag);
            editablePythonAbiContainer.addSupportedAbi(triple);
        }
    }

    private static File getPythonFileForSupportedWheels(File tempDir) {
        return new File(tempDir, "wheel-api.py");
    }

    private static File getSupportedAbiFormatsFile(File buildDir, PythonDetails pythonDetails) {
        return new File(buildDir, "wheel-abi-result" + pythonDetails.getPythonVersion().getPythonMajorMinor() + ".json");
    }
}

