/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action;

import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.tasks.action.ProbeVenvInfoAction;
import com.linkedin.gradle.python.tasks.execution.TeeOutputContainer;
import com.linkedin.gradle.python.util.pip.PipConfFile;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class CreateVirtualEnvAction {
    private static Logger log = Logging.getLogger(CreateVirtualEnvAction.class);
    private final Project project;
    private final PythonDetails pythonDetails;
    private final EditablePythonAbiContainer editablePythonAbiContainer;
    private final TeeOutputContainer container = new TeeOutputContainer();

    public CreateVirtualEnvAction(Project project, PythonDetails pythonDetails, EditablePythonAbiContainer editablePythonAbiContainer) {
        this.project = project;
        this.pythonDetails = pythonDetails;
        this.editablePythonAbiContainer = editablePythonAbiContainer;
    }

    public void buildVenv(@Nullable Consumer<File> customize) {
        Path installScriptPath;
        PipConfFile pipConfFile = new PipConfFile(this.project, this.pythonDetails);
        File packageDir = this.makeTempDir().toFile();
        this.getPyGradleBootstrap(this.project).getFiles().forEach(file -> this.project.copy(copySpec -> {
            copySpec.from(new Object[]{this.project.tarTree((Object)file.getPath())});
            copySpec.into((Object)packageDir);
            copySpec.eachFile(it -> {
                Path pathInsideTar = Paths.get(it.getPath(), new String[0]);
                if (pathInsideTar.getNameCount() > 1) {
                    it.setPath(pathInsideTar.subpath(1, pathInsideTar.getNameCount()).toString());
                }
            });
        }));
        if (null != customize) {
            customize.accept(packageDir);
        }
        if (!Files.exists(installScriptPath = Paths.get(packageDir.toString(), "virtualenv.py"), new LinkOption[0])) {
            installScriptPath = Paths.get(packageDir.toString(), "src", "virtualenv.py");
        }
        File installScript = installScriptPath.toFile();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecResult execResult = this.project.exec(execSpec -> {
            this.container.setOutputs((ExecSpec)execSpec);
            execSpec.commandLine(new Object[]{this.pythonDetails.getSystemPythonInterpreter(), installScript, "--never-download", "--python", this.pythonDetails.getSystemPythonInterpreter(), "--prompt", this.pythonDetails.getVirtualEnvPrompt(), this.pythonDetails.getVirtualEnv()});
            execSpec.setErrorOutput(outputStream);
            execSpec.setStandardOutput(outputStream);
            execSpec.setIgnoreExitValue(true);
        });
        if (log.isInfoEnabled()) {
            log.info(((Object)outputStream).toString());
        } else if (execResult.getExitValue() != 0) {
            log.lifecycle(((Object)outputStream).toString());
        }
        execResult.assertNormalExitValue();
        ProbeVenvInfoAction.probeVenv(this.project, this.pythonDetails, this.editablePythonAbiContainer);
        this.project.delete(new Object[]{packageDir});
        try {
            pipConfFile.buildPipConfFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Configuration getPyGradleBootstrap(Project project) {
        return project.getConfigurations().getByName("pygradleBootstrap");
    }

    private Path makeTempDir() {
        try {
            return Files.createTempDirectory("virtualenv-dir", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

