/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.exception.PipExecutionException;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.plugin.PythonHelpers;
import com.linkedin.gradle.python.tasks.action.pip.PipInstallAction;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import com.linkedin.gradle.python.tasks.exec.ProjectExternalExec;
import com.linkedin.gradle.python.tasks.execution.FailureReasonProvider;
import com.linkedin.gradle.python.tasks.supports.SupportsPackageFiltering;
import com.linkedin.gradle.python.tasks.supports.SupportsPackageInfoSettings;
import com.linkedin.gradle.python.tasks.supports.SupportsWheelCache;
import com.linkedin.gradle.python.util.DefaultEnvironmentMerger;
import com.linkedin.gradle.python.util.DependencyOrder;
import com.linkedin.gradle.python.util.EnvironmentMerger;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import com.linkedin.gradle.python.util.internal.TaskTimer;
import com.linkedin.gradle.python.wheel.EmptyWheelCache;
import com.linkedin.gradle.python.wheel.WheelCache;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class PipInstallTask
extends DefaultTask
implements FailureReasonProvider,
SupportsWheelCache,
SupportsPackageInfoSettings,
SupportsPackageFiltering,
GroovyObject {
    @Input
    private WheelCache wheelCache;
    @Input
    private PythonDetails pythonDetails;
    @InputFiles
    private FileCollection installFileCollection;
    @Input
    private List<String> args;
    @Input
    @Optional
    private Map<String, String> environment;
    @Input
    @Optional
    private boolean sorted;
    private PackageSettings<PackageInfo> packageSettings;
    private EnvironmentMerger environmentMerger;
    private ExternalExec externalExec;
    private Spec<PackageInfo> packageExcludeFilter;
    private String lastInstallMessage;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PipInstallTask() {
        MetaClass metaClass;
        boolean bl;
        List list;
        EmptyWheelCache emptyWheelCache = new EmptyWheelCache();
        this.wheelCache = emptyWheelCache;
        this.args = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.sorted = bl = true;
        DefaultEnvironmentMerger defaultEnvironmentMerger = new DefaultEnvironmentMerger();
        this.environmentMerger = defaultEnvironmentMerger;
        ProjectExternalExec projectExternalExec = new ProjectExternalExec(this.getProject());
        this.externalExec = projectExternalExec;
        Object var6_6 = null;
        this.packageExcludeFilter = (Spec)ScriptBytecodeAdapter.castToType(var6_6, Spec.class);
        Object var7_7 = null;
        this.lastInstallMessage = ShortTypeHandling.castToString(var7_7);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private boolean isReadyForInstall(File installable) {
        if (ScriptBytecodeAdapter.compareEqual((Object)installable.getAbsolutePath(), (Object)((ProjectInternal)this.getProject()).getProjectDir().getAbsolutePath())) {
            File setupPyFile = new File(installable.getAbsolutePath(), "setup.py");
            if (!setupPyFile.exists()) {
                this.getLogger().lifecycle(PythonHelpers.createPrettyLine(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((ProjectInternal)this.getProject()).getName()}, new String[]{"Install ", ""})), "[ABORTED]"));
                ((ProjectInternal)this.getProject()).getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((ProjectInternal)this.getProject()).getName()}, new String[]{"setup.py missing, skipping venv install for product ", ".  Run 'gradle generateSetupPy' to generate a generic file"})));
                return false;
            }
        }
        return true;
    }

    @TaskAction
    public void pipInstall() {
        PythonExtension extension = ExtensionUtils.getPythonExtension(this.getProject());
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)this.getServices().get(ProgressLoggerFactory.class);
        ProgressLogger progressLogger = progressLoggerFactory.newOperation(PipInstallTask.class);
        progressLogger.setDescription("Installing Libraries");
        progressLogger.started();
        TaskTimer taskTimer = new TaskTimer();
        Map<String, String> baseEnvironment = this.environmentMerger.mergeEnvironments(ScriptBytecodeAdapter.createList((Object[])new Object[]{extension.pythonEnvironment, this.environment}));
        PipInstallAction pipInstallAction = new PipInstallAction(this.packageSettings, this.getProject(), this.externalExec, baseEnvironment, this.pythonDetails, this.wheelCache, this.environmentMerger, this.packageExcludeFilter);
        int counter = 0;
        Collection<File> installableFiles = DependencyOrder.getConfigurationFiles(this.installFileCollection, this.sorted);
        File installable = null;
        Iterator<File> iterator = installableFiles.iterator();
        while (iterator.hasNext()) {
            installable = (File)ScriptBytecodeAdapter.castToType((Object)iterator.next(), File.class);
            if (!this.isReadyForInstall(installable)) continue;
            PackageInfo packageInfo = PackageInfo.fromPath(installable);
            String shortHand = packageInfo.toShortHand();
            TaskTimer.TickingClock timer = taskTimer.start(shortHand);
            progressLogger.progress(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{shortHand, ++counter, installableFiles.size()}, new String[]{"Installing ", " (", " of ", ")"})));
            try {
                pipInstallAction.execute(packageInfo, (List)this.args);
            }
            catch (PipExecutionException e) {
                String string;
                this.lastInstallMessage = string = e.getPipText();
                throw (Throwable)((Object)e);
            }
            timer.stop();
        }
        progressLogger.completed();
        String string = taskTimer.buildReport();
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)new File(((ProjectInternal)this.getProject()).getBuildDir(), StringGroovyMethods.plus((String)this.getName(), (CharSequence)"-task-runtime-report.txt")), (String)"text");
    }

    @Override
    public String getReason() {
        return this.lastInstallMessage;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PipInstallTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Override
    @Generated
    public WheelCache getWheelCache() {
        return this.wheelCache;
    }

    @Override
    @Generated
    public void setWheelCache(WheelCache wheelCache) {
        this.wheelCache = wheelCache;
    }

    @Override
    @Generated
    public PythonDetails getPythonDetails() {
        return this.pythonDetails;
    }

    @Generated
    public void setPythonDetails(PythonDetails pythonDetails) {
        this.pythonDetails = pythonDetails;
    }

    @Generated
    public FileCollection getInstallFileCollection() {
        return this.installFileCollection;
    }

    @Generated
    public void setInstallFileCollection(FileCollection fileCollection) {
        this.installFileCollection = fileCollection;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public void setArgs(List<String> list) {
        this.args = list;
    }

    @Generated
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Generated
    public void setEnvironment(Map<String, String> map) {
        this.environment = map;
    }

    @Generated
    public boolean getSorted() {
        return this.sorted;
    }

    @Generated
    public boolean isSorted() {
        return this.sorted;
    }

    @Generated
    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    @Override
    @Generated
    public PackageSettings<PackageInfo> getPackageSettings() {
        return this.packageSettings;
    }

    @Override
    @Generated
    public void setPackageSettings(PackageSettings<PackageInfo> packageSettings) {
        this.packageSettings = packageSettings;
    }

    @Generated
    public EnvironmentMerger getEnvironmentMerger() {
        return this.environmentMerger;
    }

    @Generated
    public void setEnvironmentMerger(EnvironmentMerger environmentMerger) {
        this.environmentMerger = environmentMerger;
    }

    @Generated
    public ExternalExec getExternalExec() {
        return this.externalExec;
    }

    @Generated
    public void setExternalExec(ExternalExec externalExec) {
        this.externalExec = externalExec;
    }

    @Override
    @Generated
    public Spec<PackageInfo> getPackageExcludeFilter() {
        return this.packageExcludeFilter;
    }

    @Override
    @Generated
    public void setPackageExcludeFilter(Spec<PackageInfo> spec) {
        this.packageExcludeFilter = spec;
    }
}

