/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class PinRequirementsTask
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(PinRequirementsTask.class);

    @TaskAction
    public void writeOutPinnedFile() throws IOException {
        File pinnedFile = this.getPinnedFile();
        if (pinnedFile.exists()) {
            pinnedFile.delete();
        }
        pinnedFile.createNewFile();
        StringBuilder contents = new StringBuilder();
        for (ResolvedDependency r : this.getPythonConfiguration().getResolvedConfiguration().getFirstLevelModuleDependencies()) {
            logger.info("Pinning {}=={}", (Object)r.getModuleName(), (Object)r.getModuleVersion());
            contents.append(r.getModuleName()).append("==").append(r.getModuleVersion()).append(System.getProperty("line.separator"));
        }
        FileUtils.write((File)pinnedFile, (CharSequence)contents);
    }

    @InputFiles
    public Configuration getPythonConfiguration() {
        return this.getProject().getConfigurations().getByName(StandardTextValues.CONFIGURATION_PYTHON.getValue());
    }

    @OutputFile
    public File getPinnedFile() {
        PythonExtension pythonExtension = ExtensionUtils.getPythonExtension(this.getProject());
        return pythonExtension.getPinnedFile();
    }
}

