/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.tasks.action.CreateVirtualEnvAction;
import com.linkedin.gradle.python.tasks.action.VirtualEnvCustomizer;
import com.linkedin.gradle.python.tasks.exec.ProjectExternalExec;
import com.linkedin.gradle.python.tasks.execution.FailureReasonProvider;
import com.linkedin.gradle.python.tasks.execution.TeeOutputContainer;
import com.linkedin.gradle.python.tasks.provides.ProvidesVenv;
import com.linkedin.gradle.python.tasks.supports.SupportsDistutilsCfg;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class InstallVirtualEnvironmentTask
extends DefaultTask
implements FailureReasonProvider,
SupportsDistutilsCfg,
ProvidesVenv {
    private PythonDetails pythonDetails;
    private String distutilsCfg;
    private final TeeOutputContainer container = new TeeOutputContainer();
    private EditablePythonAbiContainer editablePythonAbiContainer;

    @InputFiles
    public Configuration getPyGradleBootstrap() {
        return this.getProject().getConfigurations().getByName("pygradleBootstrap");
    }

    @OutputFile
    public File getVirtualEnvInterpreter() {
        return this.pythonDetails.getVirtualEnvInterpreter();
    }

    @TaskAction
    public void installVEnv() {
        CreateVirtualEnvAction action = new CreateVirtualEnvAction(this.getProject(), this.pythonDetails, this.editablePythonAbiContainer);
        action.buildVenv(new VirtualEnvCustomizer(this.distutilsCfg, new ProjectExternalExec(this.getProject()), this.pythonDetails));
    }

    @Override
    public String getReason() {
        return this.container.getCommandOutput();
    }

    public void setPythonDetails(PythonDetails pythonDetails) {
        this.pythonDetails = pythonDetails;
    }

    public PythonDetails getPythonDetails() {
        return this.pythonDetails;
    }

    @Override
    @Input
    @Optional
    public String getDistutilsCfg() {
        return this.distutilsCfg;
    }

    @Override
    public void setDistutilsCfg(String distutilsCfg) {
        this.distutilsCfg = distutilsCfg;
    }

    @Override
    public void setEditablePythonAbiContainer(EditablePythonAbiContainer editablePythonAbiContainer) {
        this.editablePythonAbiContainer = editablePythonAbiContainer;
    }
}

