/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class GenerateSetupPyTask
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(GenerateSetupPyTask.class);

    public GenerateSetupPyTask() {
        this.setDescription("Writes the suggested setup.py out to disk. This will overwrite any existing setup.py");
        this.setGroup("documentation");
    }

    @TaskAction
    public void createSetupPy() throws IOException {
        File file = this.getProject().file((Object)"setup.py");
        if (file.exists()) {
            logger.lifecycle("Contents of setup.py are going to be overwritten!!");
            file.delete();
        }
        file.createNewFile();
        String setupPy = IOUtils.toString((InputStream)GenerateSetupPyTask.class.getResourceAsStream("/templates/setup.py.template"));
        FileUtils.write((File)file, (CharSequence)setupPy);
    }
}

