/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.checkstyle.CheckStyleXmlReporter;
import com.linkedin.gradle.python.checkstyle.model.FileStyleViolationsContainer;
import com.linkedin.gradle.python.tasks.Flake8Task;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.io.FileUtils;
import org.gradle.api.tasks.OutputFile;
import org.gradle.process.ExecResult;

public class CheckStyleGeneratorTask
extends Flake8Task {
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private File checkstyleReport = new File(this.getProject().getBuildDir(), "/checkstyle.xml");

    public CheckStyleGeneratorTask() {
        this.stdOut = this.outputStream;
        this.errOut = this.outputStream;
        this.ignoreExitValue = true;
    }

    @Override
    public void processResults(ExecResult execResult) {
        String[] lines;
        FileStyleViolationsContainer container = new FileStyleViolationsContainer();
        for (String line : lines = this.outputStream.toString().split("\\r?\\n")) {
            container.parseLine(line);
        }
        CheckStyleXmlReporter reporter = new CheckStyleXmlReporter(container);
        try {
            FileUtils.write((File)this.checkstyleReport, (CharSequence)reporter.generateXml());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @OutputFile
    public File getCheckstyleReport() {
        return this.checkstyleReport;
    }

    public void setCheckstyleReport(File checkstyleReport) {
        this.checkstyleReport = checkstyleReport;
    }
}

