/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.extension.PexExtension;
import com.linkedin.gradle.python.extension.ZipappContainerExtension;
import com.linkedin.gradle.python.tasks.PythonContainerTask;
import com.linkedin.gradle.python.tasks.execution.FailureReasonProvider;
import com.linkedin.gradle.python.tasks.execution.TeeOutputContainer;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.internal.pex.FatPexGenerator;
import com.linkedin.gradle.python.util.internal.pex.ThinPexGenerator;
import com.linkedin.gradle.python.util.zipapp.DefaultPexEntryPointTemplateProvider;
import com.linkedin.gradle.python.util.zipapp.EntryPointTemplateProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class BuildPexTask
extends DefaultTask
implements FailureReasonProvider,
PythonContainerTask {
    private Map<String, String> additionalProperties;
    private EntryPointTemplateProvider templateProvider = new DefaultPexEntryPointTemplateProvider();
    private TeeOutputContainer container = new TeeOutputContainer(System.out, System.err);
    private List<String> pexOptions = new ArrayList<String>();

    @Input
    @Optional
    public List<String> getPexOptions() {
        return this.pexOptions;
    }

    public void setPexOptions(List<String> pexOptions) {
        this.pexOptions = pexOptions;
    }

    @TaskAction
    public void buildPex() throws Exception {
        Project project = this.getProject();
        DeployableExtension deployableExtension = ExtensionUtils.getPythonComponentExtension(project, DeployableExtension.class);
        PexExtension pexExtension = ExtensionUtils.getPythonComponentExtension(project, PexExtension.class);
        ZipappContainerExtension zipappExtension = ExtensionUtils.getPythonComponentExtension(project, ZipappContainerExtension.class);
        if (pexExtension.getPexCache().exists()) {
            FileUtils.deleteQuietly((File)pexExtension.getPexCache());
            pexExtension.getPexCache().mkdirs();
        }
        deployableExtension.getDeployableBuildDir().mkdirs();
        if (zipappExtension.isFat()) {
            new FatPexGenerator(project, this.pexOptions).buildEntryPoints();
        } else {
            new ThinPexGenerator(project, this.pexOptions, this.templateProvider, this.additionalProperties).buildEntryPoints();
        }
    }

    @Input
    @Optional
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Input
    @Optional
    public EntryPointTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public void setTemplateProvider(EntryPointTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }

    @Override
    @Internal
    public String getReason() {
        return this.container.getCommandOutput();
    }
}

