/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin.internal;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.tasks.PipInstallTask;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public class InstallDependenciesPlugin
implements Plugin<Project> {
    private static final String PIP_UPGRADE = "--upgrade";

    public void apply(Project project) {
        PythonExtension settings = ExtensionUtils.getPythonExtension(project);
        project.getTasks().create(StandardTextValues.TASK_INSTALL_SETUP_REQS.getValue(), PipInstallTask.class, it -> {
            it.setPythonDetails(settings.getDetails());
            it.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_SETUP_LINKS.getValue())});
            it.setArgs(Collections.singletonList(PIP_UPGRADE));
            it.setInstallFileCollection((FileCollection)project.getConfigurations().getByName(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue()));
            it.setSorted(false);
        });
        project.getTasks().create(StandardTextValues.TASK_INSTALL_BUILD_REQS.getValue(), PipInstallTask.class, it -> {
            it.setPythonDetails(settings.getDetails());
            it.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_SETUP_REQS.getValue())});
            it.setArgs(Collections.singletonList(PIP_UPGRADE));
            it.setInstallFileCollection((FileCollection)project.getConfigurations().getByName(StandardTextValues.CONFIGURATION_BUILD_REQS.getValue()));
        });
        project.getTasks().create(StandardTextValues.TASK_INSTALL_TEST_REQS.getValue(), PipInstallTask.class, it -> {
            it.setPythonDetails(settings.getDetails());
            it.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_BUILD_REQS.getValue())});
            it.setInstallFileCollection((FileCollection)project.getConfigurations().getByName(StandardTextValues.CONFIGURATION_TEST.getValue()));
        });
        project.getTasks().create(StandardTextValues.TASK_INSTALL_PYTHON_REQS.getValue(), PipInstallTask.class, it -> {
            it.setPythonDetails(settings.getDetails());
            it.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_TEST_REQS.getValue())});
            it.setInstallFileCollection((FileCollection)project.getConfigurations().getByName(StandardTextValues.CONFIGURATION_PYTHON.getValue()));
        });
        project.getTasks().create(StandardTextValues.TASK_INSTALL_PROJECT.getValue(), PipInstallTask.class, it -> {
            it.setPythonDetails(settings.getDetails());
            it.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_PYTHON_REQS.getValue())});
            it.setInstallFileCollection((FileCollection)project.files(new Object[]{project.file((Object)project.getProjectDir())}));
            it.setEnvironment(settings.pythonEnvironmentDistgradle);
        });
    }
}

