/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin.internal;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.tasks.SphinxDocumentationTask;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;

public class DocumentationPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PythonExtension settings = ExtensionUtils.getPythonExtension(project);
        SphinxDocumentationTask sphinxHtml = (SphinxDocumentationTask)project.getTasks().create(StandardTextValues.TASK_BUILD_DOCS.getValue() + "Html", SphinxDocumentationTask.class, task -> {
            task.type = SphinxDocumentationTask.DocType.HTML;
            task.dependsOn(new Object[]{StandardTextValues.TASK_INSTALL_PROJECT.getValue()});
            task.onlyIf(it -> project.file((Object)settings.docsDir).exists());
        });
        SphinxDocumentationTask sphinxJson = (SphinxDocumentationTask)project.getTasks().create(StandardTextValues.TASK_BUILD_DOCS.getValue() + "Json", SphinxDocumentationTask.class, task -> {
            task.type = SphinxDocumentationTask.DocType.JSON;
            task.dependsOn(new Object[]{StandardTextValues.TASK_INSTALL_PROJECT.getValue()});
            task.onlyIf(it -> project.file((Object)settings.docsDir).exists());
        });
        project.getTasks().withType(SphinxDocumentationTask.class, task -> {
            task.setGroup(StandardTextValues.DOCUMENTATION_GROUP.getValue());
            task.setDescription("Generate Sphinx documentation in " + task.type.getBuilderName() + " format");
        });
        project.getTasks().create(StandardTextValues.TASK_BUILD_DOCS.getValue(), it -> it.dependsOn(new Object[]{sphinxHtml, sphinxJson}));
        Tar packageDocsTask = (Tar)project.getTasks().create(StandardTextValues.TASK_PACKAGE_DOCS.getValue(), Tar.class, (Action)new PackageDocumentationAction(sphinxHtml));
        packageDocsTask.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_BUILD_DOCS.getValue())});
        Tar packageJsonDocsTask = (Tar)project.getTasks().create(StandardTextValues.TASK_PACKAGE_JSON_DOCS.getValue(), Tar.class, (Action)new PackageDocumentationAction(sphinxJson));
        packageJsonDocsTask.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_BUILD_DOCS.getValue())});
        if (project.file((Object)settings.docsDir).exists()) {
            project.getArtifacts().add(StandardTextValues.CONFIGURATION_PYDOCS.getValue(), (Object)packageDocsTask);
            project.getArtifacts().add(StandardTextValues.CONFIGURATION_PYDOCS.getValue(), (Object)packageJsonDocsTask);
        }
    }

    private static class PackageDocumentationAction
    implements Action<Tar> {
        private final SphinxDocumentationTask documentationTask;

        PackageDocumentationAction(SphinxDocumentationTask documentationTask) {
            this.documentationTask = documentationTask;
        }

        public void execute(Tar tar) {
            tar.setCompression(Compression.GZIP);
            tar.setBaseName(tar.getProject().getName());
            tar.setClassifier("docs-" + this.documentationTask.type.getBuilderName());
            tar.setExtension("tar.gz");
            tar.from(new Object[]{this.documentationTask});
            tar.into((Object)(tar.getBaseName() + "-" + tar.getVersion() + "-" + tar.getClassifier()));
        }
    }
}

