/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.plugin.PythonPlugin;
import com.linkedin.gradle.python.tasks.ParallelWheelGenerationTask;
import com.linkedin.gradle.python.tasks.provides.ProvidesVenv;
import com.linkedin.gradle.python.tasks.supports.SupportsWheelCache;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import com.linkedin.gradle.python.wheel.FileBackedWheelCache;
import java.io.File;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class WheelFirstPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        File cacheDir = new File(project.getGradle().getGradleUserHomeDir(), "pygradle-wheel-cache");
        project.getPlugins().withType(PythonPlugin.class, plugin -> {
            EditablePythonAbiContainer supportedWheelFormats = ExtensionUtils.getEditablePythonAbiContainer(project);
            FileBackedWheelCache wheelCache = new FileBackedWheelCache(cacheDir, supportedWheelFormats.copy());
            tasks.withType(ProvidesVenv.class, it -> it.setEditablePythonAbiContainer(supportedWheelFormats));
            ParallelWheelGenerationTask parallelWheelTask = (ParallelWheelGenerationTask)tasks.create("parallelWheels", ParallelWheelGenerationTask.class, it -> {
                ConfigurationContainer configurations = project.getConfigurations();
                FileCollection dependencies = configurations.getByName(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue()).plus((FileCollection)configurations.getByName(StandardTextValues.CONFIGURATION_BUILD_REQS.getValue())).plus((FileCollection)configurations.getByName(StandardTextValues.CONFIGURATION_PYTHON.getValue())).plus((FileCollection)configurations.getByName(StandardTextValues.CONFIGURATION_WHEEL.getValue())).plus((FileCollection)configurations.getByName(StandardTextValues.CONFIGURATION_PYDOCS.getValue())).plus((FileCollection)configurations.getByName(StandardTextValues.CONFIGURATION_VENV.getValue())).plus((FileCollection)configurations.getByName(StandardTextValues.CONFIGURATION_TEST.getValue()));
                it.setFilesToConvert(dependencies);
                it.setWheelCache(wheelCache);
                it.setCacheDir(cacheDir);
                it.dependsOn(new Object[]{tasks.getByName(StandardTextValues.TASK_VENV_CREATE.getValue())});
                it.dependsOn(new Object[]{tasks.getByName(StandardTextValues.TASK_INSTALL_SETUP_REQS.getValue())});
            });
            tasks.matching(it -> it instanceof SupportsWheelCache && !(it instanceof ProvidesVenv) && !Objects.equals(it.getName(), StandardTextValues.TASK_INSTALL_SETUP_REQS.getValue())).all(it -> it.dependsOn(new Object[]{parallelWheelTask}));
            tasks.withType(SupportsWheelCache.class, it -> it.setWheelCache(wheelCache));
        });
    }
}

