/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.plugin.PythonBasePlugin;
import com.linkedin.gradle.python.util.StandardTextValues;
import java.io.File;
import java.util.LinkedHashMap;
import org.gradle.api.Project;

public class PythonWheelDistributionPlugin
extends PythonBasePlugin {
    public static final String TASK_PACKAGE_WHEEL = "packageWheel";

    @Override
    public void applyTo(Project project) {
        String version = project.getVersion().toString().replace("-", "_");
        String name = project.getName().replace("-", "_");
        File wheelArtifact = new File(project.getProjectDir(), "/dist/" + name + "-" + version + "-py2-none-any.whl");
        project.getTasks().create(TASK_PACKAGE_WHEEL, task -> {
            task.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_PROJECT.getValue())});
            task.getOutputs().file((Object)wheelArtifact);
            task.doLast(it -> project.exec(execSpec -> {
                execSpec.environment(this.settings.pythonEnvironmentDistgradle);
                execSpec.commandLine(new Object[]{this.settings.getDetails().getVirtualEnvInterpreter(), "setup.py", "bdist_wheel"});
            }));
        });
        LinkedHashMap<String, Object> wheelArtifactInfo = new LinkedHashMap<String, Object>(5);
        wheelArtifactInfo.put("name", name);
        wheelArtifactInfo.put("classifier", "py2-none-any");
        wheelArtifactInfo.put("type", "whl");
        wheelArtifactInfo.put("file", wheelArtifact);
        wheelArtifactInfo.put("builtBy", project.getTasks().getByName(TASK_PACKAGE_WHEEL));
        if (!version.contains("SNAPSHOT")) {
            project.getArtifacts().add(StandardTextValues.CONFIGURATION_WHEEL.getValue(), wheelArtifactInfo);
        }
    }
}

