/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import org.gradle.api.Project;
import org.gradle.api.logging.configuration.ConsoleOutput;

public class PythonHelpers {
    public static final int LINE_WIDTH = 80;

    private PythonHelpers() {
    }

    public static boolean isPlainOrVerbose(Project project) {
        return project.getLogger().isInfoEnabled() || System.getenv("TERM") == null || project.getGradle().getStartParameter().getConsoleOutput() == ConsoleOutput.Plain;
    }

    public static String createPrettyLine(String prefix, String postfix) {
        StringBuilder successFlair = new StringBuilder();
        successFlair.append(prefix).append(" ");
        for (int i = 0; i < 77 - prefix.length() - postfix.length(); ++i) {
            successFlair.append(".");
        }
        successFlair.append(".");
        successFlair.append(" ").append(postfix);
        return successFlair.toString();
    }
}

