/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.extension.WheelExtension;
import com.linkedin.gradle.python.tasks.LayeredWheelCacheTask;
import com.linkedin.gradle.python.tasks.provides.ProvidesVenv;
import com.linkedin.gradle.python.tasks.supports.SupportsWheelCache;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import com.linkedin.gradle.python.wheel.LayeredWheelCache;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;

public class LayeredWheelCachePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        WheelExtension wheelExtension = ExtensionUtils.maybeCreateWheelExtension(project);
        EditablePythonAbiContainer supportedWheelFormats = ExtensionUtils.getEditablePythonAbiContainer(project);
        LayeredWheelCache wheelCache = new LayeredWheelCache(wheelExtension.getLayeredCacheMap(), supportedWheelFormats);
        TaskContainer tasks = project.getTasks();
        tasks.withType(ProvidesVenv.class, task -> task.setEditablePythonAbiContainer(supportedWheelFormats));
        tasks.withType(SupportsWheelCache.class, task -> task.setWheelCache(wheelCache));
        tasks.create("layeredWheelCacheTask", LayeredWheelCacheTask.class, task -> {
            tasks.getByName(StandardTextValues.TASK_VENV_CREATE.getValue()).dependsOn(new Object[]{task});
            tasks.getByName(StandardTextValues.TASK_FLAKE.getValue()).dependsOn(new Object[]{task});
        });
    }
}

