/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.extension.internal;

import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.extension.PythonDetailsFactory;
import com.linkedin.gradle.python.extension.VirtualEnvironment;
import com.linkedin.gradle.python.util.OperatingSystem;
import java.io.File;
import java.nio.file.Path;

public class DefaultVirtualEnvironment
implements VirtualEnvironment {
    private final PythonDetails details;

    DefaultVirtualEnvironment(PythonDetails details) {
        this.details = details;
    }

    @Override
    public File getPip() {
        return this.getExecutable("pip");
    }

    @Override
    public File getPex() {
        return this.getExecutable("pex");
    }

    private File validateFileExists(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            throw new RuntimeException("Could not find " + path.toString() + " to execute");
        }
        return file;
    }

    @Override
    public File getExecutable(String name) {
        return this.validateFileExists(this.findExecutable(name).toPath());
    }

    @Override
    public File getScript(String name) {
        return this.validateFileExists(this.prefixBuilder().resolve(OperatingSystem.current().getScriptName(name)));
    }

    @Override
    public File findExecutable(String name) {
        return DefaultVirtualEnvironment.findExecutable(this.prefixBuilder(), name);
    }

    public static File findExecutable(Path path, String name) {
        return path.resolve(OperatingSystem.current().getExecutableName(name)).toFile();
    }

    private Path prefixBuilder() {
        return this.details.getVirtualEnv().toPath().resolve(PythonDetailsFactory.getPythonApplicationDirectory());
    }
}

