/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.extension;

import com.linkedin.gradle.python.extension.PythonVersion;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;

public class PythonVersionParser {
    private PythonVersionParser() {
    }

    public static PythonVersion parsePythonVersion(Project project, File pythonInterpreter) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecResult execResult = project.exec(execSpec -> {
            execSpec.setExecutable(pythonInterpreter.getAbsolutePath());
            execSpec.setArgs(Collections.singletonList("--version"));
            execSpec.setStandardOutput((OutputStream)outputStream);
            execSpec.setErrorOutput((OutputStream)outputStream);
            execSpec.setIgnoreExitValue(true);
        });
        String output = outputStream.toString();
        if (execResult.getExitValue() != 0) {
            throw new GradleException(output);
        }
        String versionString = output.trim().split(" ")[1];
        return new PythonVersion(versionString);
    }
}

