/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.exception;

import com.linkedin.gradle.python.util.PackageInfo;
import java.util.List;
import org.gradle.api.GradleException;

public class PipExecutionException
extends GradleException {
    private final String pipText;

    private PipExecutionException(String message, String pipText) {
        super(message);
        this.pipText = pipText;
    }

    public String getPipText() {
        return this.pipText;
    }

    public static PipExecutionException failedInstall(PackageInfo packageInfo, String pipText) {
        String body = String.format("Failed to install %s. Please see above output for reason, or re-run your build using ``gradle -i build`` for additional logging.", packageInfo.toShortHand());
        return new PipExecutionException(body, pipText);
    }

    public static PipExecutionException failedWheel(PackageInfo packageInfo, String pipText) {
        String body = String.format("Failed to build wheel for %s. Please see above output for reason, or re-run your build using ``gradle -i build`` for additional logging.", packageInfo.toShortHand());
        return new PipExecutionException(body, pipText);
    }

    public static PipExecutionException unsupportedPythonVersion(PackageInfo packageInfo, List<String> supportedVersions) {
        String message = String.format("Package %s works only with Python versions: %s", packageInfo.getName(), supportedVersions);
        return new PipExecutionException(message, message);
    }
}

