/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.checkstyle.model;

import java.util.HashMap;
import java.util.Map;

public class StyleViolation {
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final String errorNumber;
    private final String message;
    private final ViolationType violationType;

    public StyleViolation(Integer lineNumber, Integer columnNumber, String errorCode, String message) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.errorNumber = errorCode;
        this.message = message;
        int errorTypeChar = errorCode != null ? (int)errorCode.toUpperCase().charAt(0) : 88;
        switch (errorTypeChar) {
            case 69: {
                this.violationType = ViolationType.ERROR;
                break;
            }
            case 87: {
                this.violationType = ViolationType.WARNING;
                break;
            }
            case 70: {
                this.violationType = ViolationType.PY_FLAKES;
                break;
            }
            case 67: {
                this.violationType = ViolationType.COMPLEXITY;
                break;
            }
            case 78: {
                this.violationType = ViolationType.NAMING;
                break;
            }
            default: {
                this.violationType = ViolationType.OTHER;
            }
        }
    }

    public Map<String, Object> createCheckstyleMap() {
        HashMap<String, Object> checkstyleMap = new HashMap<String, Object>();
        checkstyleMap.put("line", this.getLineNumber());
        checkstyleMap.put("column", this.getColumnNumber());
        checkstyleMap.put("message", this.getErrorNumber() + " " + this.getMessage());
        checkstyleMap.put("severity", this.getViolationType().toString());
        return checkstyleMap;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public String getErrorNumber() {
        return this.errorNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public ViolationType getViolationType() {
        return this.violationType;
    }

    public static enum ViolationType {
        ERROR,
        WARNING,
        PY_FLAKES,
        COMPLEXITY,
        NAMING,
        OTHER;

    }
}

