/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.checkstyle.model;

import com.linkedin.gradle.python.checkstyle.model.FileStyleViolations;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class FileStyleViolationsContainer {
    private static final Logger log = Logging.getLogger(FileStyleViolationsContainer.class);
    Pattern flake8Pattern = Pattern.compile("(.*?):(\\d+):(\\d+): ([A-Z]\\d{3}) (.*)");
    Map<String, FileStyleViolations> violationMap = new HashMap<String, FileStyleViolations>();

    public void parseLine(String line) {
        Matcher matcher = this.flake8Pattern.matcher(line);
        if (matcher.find()) {
            String fileName = matcher.group(1);
            Integer lineNumber = Integer.valueOf(matcher.group(2));
            Integer columnNumber = Integer.valueOf(matcher.group(3));
            String errorCode = matcher.group(4);
            String message = matcher.group(5);
            if (!this.violationMap.containsKey(fileName)) {
                this.violationMap.put(fileName, new FileStyleViolations(fileName));
            }
            this.violationMap.get(fileName).addViolation(lineNumber, columnNumber, errorCode, message);
        } else {
            log.info("Unable to parse `{}`", (Object)line);
        }
    }

    public Collection<FileStyleViolations> getViolations() {
        return this.violationMap.values();
    }
}

