/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito;

import com.android.dx.stock.ProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MockHandler;

final class InvocationHandlerAdapter
implements InvocationHandler {
    private MockHandler handler;

    public InvocationHandlerAdapter(MockHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] objectArray = args = args != null ? args : new Object[]{};
        if (InvocationHandlerAdapter.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (InvocationHandlerAdapter.isHashCodeMethod(method)) {
            return System.identityHashCode(proxy);
        }
        ProxiedMethod proxiedMethod = new ProxiedMethod(method);
        return this.handler.handle((Invocation)new InvocationImpl(proxy, (MockitoMethod)proxiedMethod, args, SequenceNumber.next(), (RealMethod)proxiedMethod, (Location)new LocationImpl()));
    }

    public MockHandler getHandler() {
        return this.handler;
    }

    public void setHandler(MockHandler handler) {
        this.handler = handler;
    }

    private static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    private static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    private static class ProxiedMethod
    implements MockitoMethod,
    RealMethod {
        private final Method method;

        ProxiedMethod(Method method) {
            this.method = method;
        }

        public String getName() {
            return this.method.getName();
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        public Class<?>[] getExceptionTypes() {
            return this.method.getExceptionTypes();
        }

        public boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        public Method getJavaMethod() {
            return this.method;
        }

        public Object invoke(Object target, Object[] arguments) throws Throwable {
            return ProxyBuilder.callSuper((Object)target, (Method)this.method, (Object[])arguments);
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.method.getModifiers());
        }
    }
}

