/*
 * Decompiled with CFR 0.152.
 */
package haxe.jvm;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import haxe.Exception;
import haxe.Int64;
import haxe.ds.Option;
import haxe.iterators.StringIterator;
import haxe.iterators.StringKeyValueIterator;
import haxe.jvm.Closure;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Enum;
import haxe.jvm.Function;
import haxe.jvm.Object;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Reflect;
import haxe.root.Std;
import haxe.root.Type;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;

@ClassReflectionInformation(hasSuperClass=false)
public class Jvm
extends Object {
    public static int stringCompare(String v1, String v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        return v1.compareTo(v2);
    }

    public static <T> int compare(T v1, T v2) {
        return Reflect.compare(v1, v2);
    }

    public static boolean enumEq(java.lang.Object v1, java.lang.Object v2) {
        if (!(v1 instanceof Enum)) {
            return false;
        }
        if (!(v2 instanceof Enum)) {
            return false;
        }
        return Type.enumEq(v1, v2);
    }

    public static boolean maybeEnumEq(java.lang.Object v1, java.lang.Object v2) {
        if (!(v1 instanceof Enum)) {
            return Jvm.compare(v1, v2) == 0;
        }
        if (!(v2 instanceof Enum)) {
            return Jvm.compare(v1, v2) == 0;
        }
        return Type.enumEq(v1, v2);
    }

    public static Class[] getArgumentTypes(java.lang.Object[] args) {
        Class[] argTypes = new Class[args.length];
        int _g = 0;
        int _g1 = args.length;
        while (_g < _g1) {
            int i;
            java.lang.Object arg;
            argTypes[i] = (arg = args[i = _g++]) == null ? java.lang.Object.class : arg.getClass();
        }
        return argTypes;
    }

    public static Option unifyCallArguments(java.lang.Object[] args, Class[] params, Boolean allowPadding) throws java.lang.Object {
        boolean allowPadding2 = allowPadding == null ? false : Jvm.toBoolean(allowPadding);
        java.lang.Object[] callArgs = null;
        if (args.length < params.length) {
            java.lang.Object[] callArgs1 = new java.lang.Object[params.length];
            System.arraycopy(args, 0, callArgs1, 0, args.length);
            callArgs = callArgs1;
        } else {
            java.lang.Object[] r = new java.lang.Object[args.length];
            System.arraycopy(args, 0, r, 0, args.length);
            callArgs = r;
        }
        if (params.length < args.length) {
            return Option.None;
        }
        int _g = 0;
        int _g1 = params.length;
        while (_g < _g1) {
            int i = _g++;
            Class paramType = params[i];
            if (i >= args.length) {
                if (paramType == Boolean.TYPE) {
                    callArgs[i] = false;
                    continue;
                }
                if (paramType == Double.TYPE) {
                    callArgs[i] = 0.0;
                    continue;
                }
                if (paramType == Integer.TYPE) {
                    callArgs[i] = 0;
                    continue;
                }
                if (!allowPadding2) {
                    return Option.None;
                }
                callArgs[i] = null;
                continue;
            }
            java.lang.Object argValue = args[i];
            if (argValue == null) {
                if (paramType.isPrimitive()) {
                    if (paramType == Boolean.TYPE) {
                        callArgs[i] = false;
                        continue;
                    }
                    if (paramType == Double.TYPE) {
                        callArgs[i] = 0.0;
                        continue;
                    }
                    if (paramType == Integer.TYPE) {
                        callArgs[i] = 0;
                        continue;
                    }
                    throw (RuntimeException)Exception.thrown("Unexpected basic type: " + Std.string(paramType));
                }
                callArgs[i] = null;
                continue;
            }
            Class<?> argType = argValue.getClass();
            Class arg = Jvm.getWrapperClass(paramType);
            if (arg.isAssignableFrom(argType)) {
                callArgs[i] = args[i];
                continue;
            }
            if (arg == Double.class && argType == Integer.class) {
                callArgs[i] = Jvm.numberToDouble((Number)args[i]);
                continue;
            }
            return Option.None;
        }
        return Option.Some(callArgs);
    }

    public static java.lang.Object call(Function func, java.lang.Object[] args) {
        return func.invokeDynamic(args);
    }

    public static <T> Byte dynamicToByte(T d) {
        if (d instanceof Number) {
            return Jvm.numberToByte((Number)d);
        }
        return null;
    }

    public static <T> Short dynamicToShort(T d) {
        if (d instanceof Number) {
            return Jvm.numberToShort((Number)d);
        }
        return null;
    }

    public static <T> Integer dynamicToInteger(T d) {
        if (d instanceof Number) {
            return Jvm.numberToInteger((Number)d);
        }
        return null;
    }

    public static <T> Long dynamicToLong(T d) {
        if (d instanceof Number) {
            return Jvm.numberToLong((Number)d);
        }
        return null;
    }

    public static <T> Float dynamicToFloat(T d) {
        if (d instanceof Number) {
            return Jvm.numberToFloat((Number)d);
        }
        return null;
    }

    public static <T> Double dynamicToDouble(T d) {
        if (d instanceof Number) {
            return Jvm.numberToDouble((Number)d);
        }
        return null;
    }

    public static Byte numberToByte(Number n) {
        if (n == null) {
            return null;
        }
        return n.byteValue();
    }

    public static Short numberToShort(Number n) {
        if (n == null) {
            return null;
        }
        return n.shortValue();
    }

    public static Integer numberToInteger(Number n) {
        if (n == null) {
            return null;
        }
        return n.intValue();
    }

    public static Long numberToLong(Number n) {
        if (n == null) {
            return null;
        }
        return n.longValue();
    }

    public static Float numberToFloat(Number n) {
        if (n == null) {
            return null;
        }
        return Float.valueOf(n.floatValue());
    }

    public static Double numberToDouble(Number n) {
        if (n == null) {
            return null;
        }
        return n.doubleValue();
    }

    public static byte toByte(java.lang.Object d) {
        if (d == null) {
            return (byte)0;
        }
        return ((Number)d).byteValue();
    }

    public static char toChar(java.lang.Object d) {
        if (d == null) {
            return (char)0;
        }
        return ((Character)d).charValue();
    }

    public static double toDouble(java.lang.Object d) {
        if (d == null) {
            return 0.0;
        }
        return ((Number)d).doubleValue();
    }

    public static float toFloat(java.lang.Object d) {
        if (d == null) {
            return (float)0.0;
        }
        return ((Number)d).floatValue();
    }

    public static int toInt(java.lang.Object d) {
        if (d == null) {
            return 0;
        }
        return ((Number)d).intValue();
    }

    public static long toLong(java.lang.Object d) {
        if (d == null) {
            return 0;
        }
        return ((Number)d).longValue();
    }

    public static short toShort(java.lang.Object d) {
        if (d == null) {
            return (short)0;
        }
        return ((Number)d).shortValue();
    }

    public static boolean toBoolean(java.lang.Object d) {
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    public static <S, T> Class<S> getWrapperClass(Class<S> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        return c;
    }

    public static java.lang.Object arrayRead(java.lang.Object obj, int index) throws java.lang.Object {
        if (obj instanceof Array) {
            return ((Array)obj).__get(index);
        }
        throw (RuntimeException)Exception.thrown("Cannot array-read on " + Std.string(obj));
    }

    public static void arrayWrite(java.lang.Object obj, int index, java.lang.Object value) throws java.lang.Object {
        if (obj instanceof Array) {
            ((Array)obj).__set(index, value);
            return;
        }
        throw (RuntimeException)Exception.thrown("Cannot array-write on " + Std.string(obj));
    }

    public static java.lang.Object readFieldClosure(java.lang.Object obj, String name, Class[] parameterTypes) {
        Class<?> cl = obj.getClass();
        Method method = cl.getMethod(name, parameterTypes);
        if (method.isBridge()) {
            Method[] _g1 = cl.getMethods();
            for (int _g = 0; _g < _g1.length; ++_g) {
                Method meth = _g1[_g];
                if (Jvm.stringCompare(meth.getName(), name) != 0 || meth.isBridge() || method.getParameterTypes().length != parameterTypes.length) continue;
                method = meth;
                break;
            }
        }
        return new Closure(obj, method);
    }

    public static <T> java.lang.Object readStaticField(Class<T> cl, String name) {
        Method[] methods = cl.getMethods();
        for (int _g = 0; _g < methods.length; ++_g) {
            Method m = methods[_g];
            if (Jvm.stringCompare(m.getName(), name) != 0 || m.isSynthetic()) continue;
            return new Closure(null, m);
        }
        try {
            Field field = cl.getField(name);
            ((AccessibleObject)field).setAccessible(true);
            return field.get(null);
        }
        catch (NoSuchFieldException _) {
            return null;
        }
    }

    public static java.lang.Object readFieldNoObject(java.lang.Object obj, String name) {
        Class<?> cl;
        try {
            Field field = cl.getField(name);
            ((AccessibleObject)field).setAccessible(true);
            return field.get(obj);
        }
        catch (NoSuchFieldException _) {
            for (cl = obj.getClass(); cl != null; cl = cl.getSuperclass()) {
                Method[] methods = cl.getMethods();
                for (int _g = 0; _g < methods.length; ++_g) {
                    Method m = methods[_g];
                    if (Jvm.stringCompare(m.getName(), name) != 0 || m.isSynthetic()) continue;
                    return new Closure(obj, m);
                }
            }
            return null;
        }
    }

    public static java.lang.Object readField(java.lang.Object obj, String name) {
        String _hx_tmp;
        if (obj == null) {
            throw new NullPointerException(name);
        }
        if (name == null) {
            return null;
        }
        if (obj instanceof Object) {
            return ((Object)obj)._hx_getField(name);
        }
        if (obj instanceof Class) {
            return Jvm.readStaticField((Class)obj, name);
        }
        if (obj instanceof String && (_hx_tmp = name) != null) {
            switch (_hx_tmp.hashCode()) {
                case -399551817: {
                    if (!_hx_tmp.equals("toUpperCase")) break;
                    String me = (String)obj;
                    return new Closure_readField_0(me);
                }
                case -1137582698: {
                    if (!_hx_tmp.equals("toLowerCase")) break;
                    String me = (String)obj;
                    return new Closure_readField_1(me);
                }
                case 530542161: {
                    if (!_hx_tmp.equals("substring")) break;
                    String me = (String)obj;
                    return new Closure_readField_2(me);
                }
                case -891529231: {
                    if (!_hx_tmp.equals("substr")) break;
                    String me = (String)obj;
                    return new Closure_readField_3(me);
                }
                case 109648666: {
                    if (!_hx_tmp.equals("split")) break;
                    String me = (String)obj;
                    return new Closure_readField_4(me);
                }
                case -1106363674: {
                    if (!_hx_tmp.equals("length")) break;
                    return ((String)obj).length();
                }
                case -467511597: {
                    if (!_hx_tmp.equals("lastIndexOf")) break;
                    String me = (String)obj;
                    return new Closure_readField_5(me);
                }
                case -955047712: {
                    if (!_hx_tmp.equals("keyValueIterator")) break;
                    return new Closure_readField_6(obj);
                }
                case 1182533742: {
                    if (!_hx_tmp.equals("iterator")) break;
                    return new Closure_readField_7(obj);
                }
                case 1943291465: {
                    if (!_hx_tmp.equals("indexOf")) break;
                    String me = (String)obj;
                    return new Closure_readField_8(me);
                }
                case 397153782: {
                    if (!_hx_tmp.equals("charCodeAt")) break;
                    String me = (String)obj;
                    return new Closure_readField_9(me);
                }
                case -1361633751: {
                    if (!_hx_tmp.equals("charAt")) break;
                    String me = (String)obj;
                    return new Closure_readField_10(me);
                }
            }
        }
        return Jvm.readFieldNoObject(obj, name);
    }

    public static <T> void writeFieldNoObject(java.lang.Object obj, String name, T value) {
        try {
            Class<?> cl = obj.getClass();
            Field field = cl.getField(name);
            ((AccessibleObject)field).setAccessible(true);
            try {
                field.set(obj, value);
                return;
            }
            catch (IllegalArgumentException _) {
                if (value == null) {
                    field.setByte(obj, (byte)0);
                    return;
                }
                if (field.getType() == Integer.TYPE && value instanceof Number) {
                    field.setInt(obj, ((Number)value).intValue());
                }
                return;
            }
        }
        catch (NoSuchFieldException _) {
            return;
        }
    }

    public static <T> void writeField(java.lang.Object obj, String name, T value) {
        if (obj == null || name == null) {
            return;
        }
        if (obj instanceof Object) {
            ((Object)obj)._hx_setField(name, value);
            return;
        }
        Jvm.writeFieldNoObject(obj, name, value);
    }

    public static <T> String toString(java.lang.Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Double) {
            Number n = (Number)obj;
            if (n.doubleValue() == (double)n.intValue()) {
                return Integer.valueOf(n.intValue()).toString();
            }
            return obj.toString();
        }
        return obj.toString();
    }

    public static <A, B> String stringConcat(java.lang.Object a, java.lang.Object b) {
        return Jvm.toString(a).concat(Jvm.toString(b));
    }

    public static <T1, T2> java.lang.Object opAdd(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof String || b instanceof String) {
            return Jvm.stringConcat(a, b);
        }
        if (a instanceof Double || b instanceof Double) {
            return Jvm.toDouble(a) + Jvm.toDouble(b);
        }
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) + Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) + Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opSub(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Double || b instanceof Double) {
            return Jvm.toDouble(a) - Jvm.toDouble(b);
        }
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) - Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) - Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opMul(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Double || b instanceof Double) {
            return Jvm.toDouble(a) * Jvm.toDouble(b);
        }
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) * Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) * Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opDiv(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Double || b instanceof Double) {
            return Jvm.toDouble(a) / Jvm.toDouble(b);
        }
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) / Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return (double)Jvm.toInt(a) / (double)Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opMod(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Double || b instanceof Double) {
            return Jvm.toDouble(a) % Jvm.toDouble(b);
        }
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) % Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) % Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opAnd(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) & Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) & Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opOr(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) | Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) | Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opXor(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) ^ Jvm.toLong(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) ^ Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opShl(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) << Jvm.toInt(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) << Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opShr(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) >> Jvm.toInt(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) >> Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1, T2> java.lang.Object opUshr(java.lang.Object a, java.lang.Object b) throws java.lang.Object {
        if (a instanceof Long || b instanceof Long) {
            return Jvm.toLong(a) >>> Jvm.toInt(b);
        }
        if (a instanceof Integer || b instanceof Integer) {
            return Jvm.toInt(a) >>> Jvm.toInt(b);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1> java.lang.Object opIncrement(java.lang.Object a) throws java.lang.Object {
        if (a instanceof Double) {
            return Jvm.toDouble(a) + 1.0;
        }
        if (a instanceof Long) {
            return Jvm.toLong(a) + (long)1.0;
        }
        if (a instanceof Integer) {
            return Jvm.toInt(a) + 1;
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1> java.lang.Object opDecrement(java.lang.Object a) throws java.lang.Object {
        if (a instanceof Double) {
            return Jvm.toDouble(a) - 1.0;
        }
        if (a instanceof Long) {
            return Jvm.toLong(a) - (long)1.0;
        }
        if (a instanceof Integer) {
            return Jvm.toInt(a) - 1;
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1> java.lang.Object opNeg(java.lang.Object a) throws java.lang.Object {
        if (a instanceof Double) {
            return -Jvm.toDouble(a);
        }
        if (a instanceof Long) {
            return Int64.Int64_Impl_.neg(Jvm.toLong(a));
        }
        if (a instanceof Integer) {
            return -Jvm.toInt(a);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public static <T1> java.lang.Object opNegBits(java.lang.Object a) throws java.lang.Object {
        if (a instanceof Long) {
            return Jvm.toLong(a) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (a instanceof Integer) {
            return ~Jvm.toInt(a);
        }
        throw (RuntimeException)Exception.thrown("Invalid operation");
    }

    public /* synthetic */ Jvm(EmptyConstructor _) {
    }

    public static final class Closure_readField_4
    extends Function
    implements java.util.function.Function<String, Array<String>>,
    Function1<String, Array<String>> {
        public final String me;

        public Closure_readField_4(String me) {
            this.me = me;
        }

        public Array invoke(String delimiter) {
            return StringExt.split(this.me, delimiter);
        }

        @Override
        public Array apply(String arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_5
    extends Function
    implements Comparable<String>,
    java.util.function.Function<String, Integer>,
    ToIntFunction<String>,
    Function1<String, Integer> {
        public final String me;

        public Closure_readField_5(String me) {
            this.me = me;
        }

        public int invoke(String str) {
            return StringExt.lastIndexOf(this.me, str, Jvm.dynamicToInteger(null));
        }

        @Override
        public int applyAsInt(String arg0) {
            return this.invoke(arg0);
        }

        @Override
        public int apply(String arg0) {
            return this.invoke(arg0);
        }

        @Override
        public int compareTo(String arg0) {
            return this.invoke(arg0);
        }

        @Override
        public int applyAsInt(java.lang.Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public int apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public int compareTo(java.lang.Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_2
    extends Function
    implements java.util.function.Function<Integer, String>,
    IntFunction<String>,
    Function1<Integer, String> {
        public final String me;

        public Closure_readField_2(String me) {
            this.me = me;
        }

        @Override
        public String invoke(int startIndex) {
            return StringExt.substring(this.me, startIndex, Jvm.dynamicToInteger(null));
        }

        @Override
        public String apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_10
    extends Function
    implements java.util.function.Function<Integer, String>,
    IntFunction<String>,
    Function1<Integer, String> {
        public final String me;

        public Closure_readField_10(String me) {
            this.me = me;
        }

        @Override
        public String invoke(int index) {
            return StringExt.charAt(this.me, index);
        }

        @Override
        public String apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_7
    extends Function
    implements PrivilegedAction<StringIterator>,
    PrivilegedExceptionAction<StringIterator>,
    Callable<StringIterator>,
    Supplier<StringIterator>,
    Function0<StringIterator> {
        public final java.lang.Object obj;

        public Closure_readField_7(java.lang.Object obj) {
            this.obj = obj;
        }

        @Override
        public StringIterator invoke() {
            return new StringIterator((String)this.obj);
        }

        @Override
        public StringIterator get() {
            return this.invoke();
        }

        @Override
        public StringIterator call() {
            return this.invoke();
        }

        @Override
        public StringIterator run() {
            return this.invoke();
        }

        @Override
        public java.lang.Object get() {
            return this.invoke();
        }

        @Override
        public java.lang.Object call() {
            return this.invoke();
        }

        @Override
        public java.lang.Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_6
    extends Function
    implements PrivilegedAction<StringKeyValueIterator>,
    PrivilegedExceptionAction<StringKeyValueIterator>,
    Callable<StringKeyValueIterator>,
    Supplier<StringKeyValueIterator>,
    Function0<StringKeyValueIterator> {
        public final java.lang.Object obj;

        public Closure_readField_6(java.lang.Object obj) {
            this.obj = obj;
        }

        @Override
        public StringKeyValueIterator invoke() {
            return new StringKeyValueIterator((String)this.obj);
        }

        @Override
        public StringKeyValueIterator get() {
            return this.invoke();
        }

        @Override
        public StringKeyValueIterator call() {
            return this.invoke();
        }

        @Override
        public StringKeyValueIterator run() {
            return this.invoke();
        }

        @Override
        public java.lang.Object get() {
            return this.invoke();
        }

        @Override
        public java.lang.Object call() {
            return this.invoke();
        }

        @Override
        public java.lang.Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_8
    extends Function
    implements BiFunction<String, Integer, Integer>,
    ToIntBiFunction<String, Integer>,
    Function2<String, Integer, Integer> {
        public final String me;

        public Closure_readField_8(String me) {
            this.me = me;
        }

        public int invoke(String str, Integer startIndex) {
            return StringExt.indexOf(this.me, str, startIndex);
        }

        @Override
        public int applyAsInt(String arg0, Integer arg1) {
            return this.invoke(arg0, arg1);
        }

        @Override
        public int apply(String arg0, Integer arg1) {
            return this.invoke(arg0, arg1);
        }

        @Override
        public int applyAsInt(java.lang.Object arg0, java.lang.Object arg1) {
            return this.invoke(arg0, arg1);
        }

        @Override
        public int apply(java.lang.Object arg0, java.lang.Object arg1) {
            return this.invoke(arg0, arg1);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0, java.lang.Object arg1) {
            return this.invoke(arg0, arg1);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_9
    extends Function
    implements java.util.function.Function<Integer, Integer>,
    IntFunction<Integer>,
    Function1<Integer, Integer> {
        public final String me;

        public Closure_readField_9(String me) {
            this.me = me;
        }

        @Override
        public Integer invoke(int index) {
            return StringExt.charCodeAt(this.me, index);
        }

        @Override
        public Integer apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final String me;

        public Closure_readField_0(String me) {
            this.me = me;
        }

        @Override
        public String invoke() {
            return StringExt.toUpperCase(this.me);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public java.lang.Object get() {
            return this.invoke();
        }

        @Override
        public java.lang.Object call() {
            return this.invoke();
        }

        @Override
        public java.lang.Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_1
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final String me;

        public Closure_readField_1(String me) {
            this.me = me;
        }

        @Override
        public String invoke() {
            return StringExt.toLowerCase(this.me);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public java.lang.Object get() {
            return this.invoke();
        }

        @Override
        public java.lang.Object call() {
            return this.invoke();
        }

        @Override
        public java.lang.Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_readField_3
    extends Function
    implements java.util.function.Function<Integer, String>,
    IntFunction<String>,
    Function1<Integer, String> {
        public final String me;

        public Closure_readField_3(String me) {
            this.me = me;
        }

        @Override
        public String invoke(int pos) {
            return StringExt.substr(this.me, pos, Jvm.dynamicToInteger(null));
        }

        @Override
        public String apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(int arg0) {
            return this.invoke(arg0);
        }

        @Override
        public java.lang.Object apply(java.lang.Object arg0) {
            return this.invoke(arg0);
        }
    }
}

