/*
 * Decompiled with CFR 0.152.
 */
package sys.thread;

import haxe.MainLoop;
import haxe.java.vm.Mutex;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Sys;
import sys.thread.Lock;

@ClassReflectionInformation(hasSuperClass=false)
public class EventLoop
extends Object {
    public static boolean CREATED;
    public Mutex mutex;
    public Array<Function> oneTimeEvents;
    public int oneTimeEventsIdx;
    public Lock waitLock;
    public int promisedEventsCount;
    public RegularEvent regularEvents;
    public boolean isMainThread;

    public RegularEvent repeat(Function event, int intervalMs) {
        this.mutex.acquire();
        double interval = 0.001 * (double)intervalMs;
        RegularEvent event2 = new RegularEvent(event, Sys.time() + interval, interval);
        RegularEvent _g = this.regularEvents;
        if (_g == null) {
            this.regularEvents = event2;
        } else {
            RegularEvent current = _g;
            RegularEvent previous = null;
            while (true) {
                if (current == null) {
                    previous.next = event2;
                    event2.previous = previous;
                    break;
                }
                if (event2.nextRunTime < current.nextRunTime) {
                    event2.next = current;
                    current.previous = event2;
                    if (previous == null) {
                        this.regularEvents = event2;
                        break;
                    }
                    event2.previous = previous;
                    previous.next = event2;
                    current.previous = event2;
                    break;
                }
                previous = current;
                current = current.next;
            }
        }
        this.waitLock.release();
        this.mutex.release();
        return event2;
    }

    public void cancel(RegularEvent eventHandler) {
        RegularEvent _g;
        this.mutex.acquire();
        RegularEvent event = eventHandler;
        event.cancelled = true;
        if (this.regularEvents == event) {
            this.regularEvents = event.next;
        }
        if ((_g = event.next) != null) {
            _g.previous = event.previous;
        }
        if ((_g = event.previous) != null) {
            _g.next = event.next;
        }
        event.previous = null;
        event.next = null;
        this.mutex.release();
    }

    public void loop() {
        Array<RegularEvent> recycleRegular = Array.ofNative(new RegularEvent[0]);
        Array<Function> recycleOneTimers = Array.ofNative(new Function[0]);
        block4: while (true) {
            double now = Sys.time();
            int eventsToRunIdx = 0;
            double nextEventAt = -1.0;
            this.mutex.acquire();
            while (this.waitLock.wait(0.0)) {
            }
            RegularEvent current = this.regularEvents;
            while (current != null) {
                if (current.nextRunTime <= now) {
                    recycleRegular.__set(eventsToRunIdx++, current);
                    current.nextRunTime += current.interval;
                    nextEventAt = -2.0;
                } else if (nextEventAt == -1.0 ? true : current.nextRunTime < nextEventAt) {
                    nextEventAt = current.nextRunTime;
                }
                current = current.next;
            }
            this.mutex.release();
            int _g = 0;
            int _g1 = eventsToRunIdx;
            while (_g < _g1) {
                int i = _g++;
                if (!recycleRegular.__get((int)i).cancelled) {
                    recycleRegular.__get((int)i).run.invoke();
                }
                recycleRegular.__set(i, null);
            }
            eventsToRunIdx = 0;
            this.mutex.acquire();
            Array<Function> _this = this.oneTimeEvents;
            int _g_current = 0;
            while (_g_current < _this.length) {
                Function _g_value = _this.__get(_g_current);
                int _g_key = _g_current++;
                if (_g_value == null) break;
                recycleOneTimers.__set(eventsToRunIdx++, _g_value);
                this.oneTimeEvents.__set(_g_key, null);
            }
            this.oneTimeEventsIdx = 0;
            boolean hasPromisedEvents = this.promisedEventsCount > 0;
            this.mutex.release();
            int _g2 = 0;
            int _g12 = eventsToRunIdx;
            while (_g2 < _g12) {
                int i = _g2++;
                recycleOneTimers.__get(i).invoke();
                recycleOneTimers.__set(i, null);
            }
            if (this.isMainThread) {
                double next = MainLoop.tick();
                if (MainLoop.hasEvents()) {
                    ++eventsToRunIdx;
                    if (nextEventAt > next) {
                        nextEventAt = next;
                    }
                }
            }
            if (eventsToRunIdx > 0) {
                nextEventAt = -2.0;
            }
            double r_nextEventAt = nextEventAt;
            switch ((int)r_nextEventAt) {
                default: {
                    double timeout = r_nextEventAt - Sys.time();
                    this.waitLock.wait(Math.max(0.0, timeout));
                    continue block4;
                }
                case -2: {
                    continue block4;
                }
                case -1: 
            }
            if (!hasPromisedEvents) break;
            this.waitLock.wait(null);
        }
    }

    public EventLoop() {
        this.mutex = new Mutex();
        this.oneTimeEvents = new Array();
        this.oneTimeEventsIdx = 0;
        this.waitLock = new Lock();
        this.promisedEventsCount = 0;
        this.isMainThread = !CREATED;
        CREATED = true;
    }

    public /* synthetic */ EventLoop(EmptyConstructor _) {
    }

    @ClassReflectionInformation(hasSuperClass=false)
    public static class RegularEvent
    extends Object {
        public double nextRunTime;
        public double interval;
        public Function run;
        public RegularEvent next;
        public RegularEvent previous;
        public boolean cancelled;

        public RegularEvent(Function run, double nextRunTime, double interval) {
            this.cancelled = false;
            this.run = run;
            this.nextRunTime = nextRunTime;
            this.interval = interval;
        }

        public /* synthetic */ RegularEvent(EmptyConstructor _) {
        }
    }
}

