/*
 * Decompiled with CFR 0.152.
 */
package hx.concurrent.executor;

import haxe.Exception;
import haxe.Timer;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Enum;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import hx.concurrent.ConcurrentException;
import hx.concurrent.ServiceState;
import hx.concurrent.executor.AbstractTaskFuture;
import hx.concurrent.executor.Executor;
import hx.concurrent.executor.Schedule;
import hx.concurrent.executor.ScheduleTools;
import hx.concurrent.executor.TaskFuture;
import hx.concurrent.executor.TimerExecutor;
import hx.concurrent.internal.Either2;

@ClassReflectionInformation(hasSuperClass=true)
public class TimerExecutor
extends Executor {
    public Array<TaskFutureImpl<Object>> _scheduledTasks;

    @Override
    public <T> TaskFuture<T> submit(Either2._Either2<Function, Function> task, Schedule schedule) {
        Schedule schedule2 = schedule == null ? Executor.NOW_ONCE : schedule;
        TimerExecutor _gthis = this;
        return (TaskFutureImpl)this._stateLock.execute(new Closure_submit_0(_gthis, task, schedule2), null);
    }

    @Override
    public void onStop() {
        Array<TaskFutureImpl<Object>> _g1 = this._scheduledTasks;
        for (int _g = 0; _g < _g1.length; ++_g) {
            TaskFutureImpl<Object> t = _g1.__get(_g);
            t.cancel();
        }
        this._scheduledTasks = Array.ofNative(new TaskFutureImpl[0]);
    }

    public TimerExecutor(Boolean autostart) {
        boolean autostart2;
        this._scheduledTasks = Array.ofNative(new TaskFutureImpl[0]);
        boolean bl = autostart2 = autostart == null ? true : Jvm.toBoolean(autostart);
        if (autostart2) {
            this.start();
        }
    }

    public /* synthetic */ TimerExecutor(EmptyConstructor _) {
        super(_);
    }

    public static final class Closure_submit_0
    extends Function {
        public final TimerExecutor _gthis;
        public final Either2._Either2 task;
        public final Schedule schedule;

        /*
         * WARNING - void declaration
         */
        public Closure_submit_0(TimerExecutor _gthis, Either2._Either2 _Either22, Schedule schedule) {
            void schedule2;
            void task;
            this._gthis = _gthis;
            this.task = task;
            this.schedule = schedule2;
        }

        @Override
        public TaskFutureImpl invoke() throws Object {
            if (this._gthis.state != ServiceState.RUNNING) {
                throw (RuntimeException)Exception.thrown("Cannot accept new tasks. Executor is not in state [RUNNING] but [" + Std.string((Object)this._gthis.state) + "].");
            }
            int i = this._gthis._scheduledTasks.length;
            while (i-- > 0) {
                if (!this._gthis._scheduledTasks.__get((int)i).isStopped) continue;
                this._gthis._scheduledTasks.splice(i, 1);
            }
            TaskFutureImpl future = new TaskFutureImpl(this._gthis, (Either2._Either2<Function, Function>)this.task, this.schedule);
            block0 : switch (this.schedule.ordinal()) {
                default: {
                    this._gthis._scheduledTasks.push(future);
                    break;
                }
                case 0: {
                    Integer _g = ((Schedule.ONCE)this.schedule).initialDelayMS;
                    if (_g == null) {
                        this._gthis._scheduledTasks.push(future);
                        break;
                    }
                    switch (Jvm.toInt(_g)) {
                        default: {
                            this._gthis._scheduledTasks.push(future);
                            break block0;
                        }
                        case 0: 
                    }
                }
            }
            return future;
        }
    }

    @ClassReflectionInformation(hasSuperClass=true)
    public static class TaskFutureImpl<T>
    extends AbstractTaskFuture<T> {
        public Timer _timer;

        public void run() {
            Enum _g;
            if (this.isStopped) {
                return;
            }
            if (this._timer == null) {
                Timer t = null;
                _g = this.schedule;
                switch (_g.ordinal()) {
                    default: {
                        break;
                    }
                    case 2: {
                        Timer timer = new Timer(null);
                        timer.new(((Schedule.FIXED_RATE)_g).intervalMS);
                        t = timer;
                        t.run = new TimerExecutor.TaskFutureImpl_run(this);
                        break;
                    }
                    case 3: {
                        Timer timer = new Timer(null);
                        timer.new(3600000);
                        t = timer;
                        t.run = new TimerExecutor.TaskFutureImpl_run(this);
                        break;
                    }
                    case 4: {
                        Timer timer = new Timer(null);
                        timer.new(86400000);
                        t = timer;
                        t.run = new TimerExecutor.TaskFutureImpl_run(this);
                        break;
                    }
                    case 5: {
                        Timer timer = new Timer(null);
                        timer.new(604800000);
                        t = timer;
                        t.run = new TimerExecutor.TaskFutureImpl_run(this);
                    }
                }
                this._timer = t;
            }
            Either2._Either2 fnResult = null;
            try {
                _g = this._task;
                switch (_g.ordinal()) {
                    case 0: {
                        fnResult = Either2._Either2.a(((Function)((Either2._Either2.a)_g).v).invoke());
                        break;
                    }
                    case 1: {
                        ((Function)((Either2._Either2.b)_g).v).invoke();
                        fnResult = null;
                    }
                }
            }
            catch (Throwable _g2) {
                fnResult = Either2._Either2.b(new ConcurrentException(Exception.caught(_g2)));
            }
            _g = this.schedule;
            switch (_g.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    this.isStopped = true;
                    break;
                }
                case 1: {
                    this._timer = Timer.delay(new TimerExecutor.TaskFutureImpl_run(this), ((Schedule.FIXED_DELAY)_g).intervalMS);
                }
            }
            this.complete(fnResult, true);
            this._executor.notifyResult(this.result);
        }

        @Override
        public void cancel() {
            Timer t = this._timer;
            if (t != null) {
                t.stop();
            }
            super.cancel();
        }

        public TaskFutureImpl(TimerExecutor executor, Either2._Either2<Function, Function> task, Schedule schedule) {
            super(executor, task, schedule);
            int initialDelay = Std.int(ScheduleTools.firstRunAt(this.schedule) - (double)System.currentTimeMillis());
            if (initialDelay < 1) {
                initialDelay = 1;
            }
            Timer.delay(new TimerExecutor.TaskFutureImpl_run(this), initialDelay);
        }

        public /* synthetic */ TaskFutureImpl(EmptyConstructor _) {
            super(_);
        }
    }
}

