/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.log;

import com.lightstreamer.internal.RLock;
import com.lightstreamer.log.AbstractLogger;
import com.lightstreamer.log.Logger;
import com.lightstreamer.log.LoggerProvider;
import haxe.IMap;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import hx.concurrent.lock.RLock;
import java.util.Iterator;

@ClassReflectionInformation(hasSuperClass=false)
public class LogManager
extends Object {
    public static RLock lock;
    public static StringMap<LoggerProxy> logInstances;
    public static EmptyLogger emptyLogger;
    public static LoggerProvider currentLoggerProvider;

    public static Logger getLogger(String category) {
        return (LoggerProxy)RLock.RLock_Impl_.synchronized(lock, new Closure_getLogger_0(category));
    }

    public static void setLoggerProvider(LoggerProvider provider) {
        RLock.RLock_Impl_.synchronized(lock, new Closure_setLoggerProvider_0(provider));
    }

    public static Logger newLogger(String category) {
        if (currentLoggerProvider == null) {
            return emptyLogger;
        }
        return currentLoggerProvider.getLogger(category);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        RLock this1 = new RLock();
        lock = var0;
        logInstances = new StringMap();
        emptyLogger = new EmptyLogger();
    }

    public /* synthetic */ LogManager(EmptyConstructor _) {
    }

    @ClassReflectionInformation(hasSuperClass=true)
    public static class EmptyLogger
    extends AbstractLogger {
        @Override
        public void fatal(String line, Throwable exception) {
        }

        @Override
        public void error(String line, Throwable exception) {
        }

        @Override
        public void warn(String line, Throwable exception) {
        }

        @Override
        public void info(String line, Throwable exception) {
        }

        @Override
        public void debug(String line, Throwable exception) {
        }

        @Override
        public void trace(String line, Throwable exception) {
        }

        @Override
        public boolean isFatalEnabled() {
            return false;
        }

        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        public EmptyLogger() {
            super(null);
        }

        public /* synthetic */ EmptyLogger(EmptyConstructor _) {
            super(_);
        }
    }

    public static final class Closure_getLogger_0
    extends Function {
        public final String category;

        public Closure_getLogger_0(String category) {
            this.category = category;
        }

        @Override
        public LoggerProxy invoke() {
            LoggerProxy log = logInstances.get(this.category);
            if (log == null) {
                LoggerProxy v = new LoggerProxy(currentLoggerProvider == null ? (Logger)emptyLogger : currentLoggerProvider.getLogger(this.category));
                logInstances.set(this.category, v);
                log = v;
            }
            return log;
        }
    }

    @ClassReflectionInformation(hasSuperClass=true)
    public static class LoggerProxy
    extends AbstractLogger {
        public Logger wrappedLogger;

        @Override
        public void fatal(String line, Throwable exception) {
            this.wrappedLogger.fatal(line, exception);
        }

        @Override
        public void error(String line, Throwable exception) {
            this.wrappedLogger.error(line, exception);
        }

        @Override
        public void warn(String line, Throwable exception) {
            this.wrappedLogger.warn(line, exception);
        }

        @Override
        public void info(String line, Throwable exception) {
            this.wrappedLogger.info(line, exception);
        }

        @Override
        public void debug(String line, Throwable exception) {
            this.wrappedLogger.debug(line, exception);
        }

        @Override
        public void trace(String line, Throwable exception) {
            this.wrappedLogger.trace(line, exception);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.wrappedLogger.isFatalEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.wrappedLogger.isErrorEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.wrappedLogger.isWarnEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.wrappedLogger.isInfoEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.wrappedLogger.isDebugEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.wrappedLogger.isTraceEnabled();
        }

        public LoggerProxy(Logger logger) {
            super(null);
            this.wrappedLogger = logger;
        }

        public /* synthetic */ LoggerProxy(EmptyConstructor _) {
            super(_);
        }
    }

    public static final class Closure_setLoggerProvider_0
    extends Function
    implements Runnable {
        public final LoggerProvider provider;

        public Closure_setLoggerProvider_0(LoggerProvider provider) {
            this.provider = provider;
        }

        @Override
        public void invoke() {
            currentLoggerProvider = this.provider;
            IMap map = logInstances;
            Iterator _g_keys = map.keys();
            while (_g_keys.hasNext()) {
                String key = (String)_g_keys.next();
                LoggerProxy _g_value = (LoggerProxy)map.get(key);
                _g_value.wrappedLogger = currentLoggerProvider == null ? (Logger)emptyLogger : currentLoggerProvider.getLogger(key);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

