/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.inkan;

import com.lightbend.inkan.SignatureValidationException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class Decode {
    private static final String KEY_ALGORITHM = "DSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withDSA";
    private static final Integer SIGNATURE_VERSION = 1;
    private static final String PUBLIC_KEY_V1 = "MIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAVakd8tbtpLC6jXFhgpReLKP6rnk0EuIDFt6oWD4urc4HZy4FZ+zLpyD72zS8Izbw/PQZvYig603/rJ4Qq9kbHBgvBjbtr1XS7F9gw4CTkeKpniKqA6B+nE1Ag8JjvJYpWgMhpiyZ/Iv2C+DWLPjF1bVzqzio2loOKRQPwD0jE1E=";

    public static byte[] decode(String string) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string.getBytes());
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n = byteBuffer.getInt();
            if (n != SIGNATURE_VERSION) {
                throw SignatureValidationException.UnexpectedVersionNumber;
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(PUBLIC_KEY_V1));
            PublicKey publicKey = KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(x509EncodedKeySpec);
            int n2 = byteBuffer.getInt();
            byte[] byArray2 = new byte[n2];
            byteBuffer.get(byArray2, 0, n2);
            int n3 = byteBuffer.getInt();
            byte[] byArray3 = new byte[n3];
            byteBuffer.get(byArray3, 0, n3);
            if (byteBuffer.remaining() != 0) {
                throw SignatureValidationException.UnexpectedBytesRemaining;
            }
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (signature.verify(byArray3)) {
                return byArray2;
            }
            throw SignatureValidationException.InvalidSignature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new SignatureValidationException("Internal error decoding license data", generalSecurityException);
        }
        catch (BufferUnderflowException | SignatureException exception) {
            throw new SignatureValidationException("Malformed signature: " + string, exception);
        }
    }
}

