/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.fortify.frontend.nst.NSTModifierSet;
import com.fortify.frontend.nst.NSTModifiers;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STDecl;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STType;
import com.fortify.frontend.nst.nodes.Visitor;

public class STVarDecl
extends STDecl {
    private String name;
    private STType type;
    private STExpression init;
    private NSTModifierSet modifiers = NSTModifierSet.Empty;

    public void setType(STType sTType) {
        assert (sTType != null);
        sTType.setParent(this);
        this.type = sTType;
    }

    public STVarDecl(SourceInfo sourceInfo) {
        super(sourceInfo);
        this.setType(new STType.STAnyType());
    }

    public STVarDecl() {
        this(new SourceInfo());
    }

    public STVarDecl(SourceInfo sourceInfo, String string) {
        this(sourceInfo, string, new STType.STAnyType());
    }

    public STVarDecl(SourceInfo sourceInfo, String string, STType sTType) {
        super(sourceInfo);
        this.name = string;
        this.setType(sTType);
    }

    @Override
    public FList<STNode> getChildren() {
        return this.filterNullChildren(this.type, this.init);
    }

    public String toString() {
        return this.name;
    }

    public STType getType() {
        return this.type;
    }

    public STType getSTType() {
        return this.type;
    }

    public String getNamespace() {
        return "";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setNamespace(String string) {
    }

    public void setModifiers(NSTModifierSet nSTModifierSet) {
        this.modifiers = nSTModifierSet;
    }

    public void setModifiers(NSTModifiers ... nSTModifiersArray) {
        this.modifiers = this.modifiers.add(nSTModifiersArray);
    }

    public NSTModifierSet getModifiers() {
        return this.modifiers;
    }

    public STExpression getInit() {
        return this.init;
    }

    public void setInit(STExpression sTExpression) {
        sTExpression.setParent(this);
        this.init = sTExpression;
    }

    @Override
    public STVarDecl clone() {
        return this.clone(new STVarDecl(this.getSourceInfo()));
    }

    @Override
    protected STVarDecl clone(STNode sTNode) {
        STVarDecl sTVarDecl = (STVarDecl)sTNode;
        super.clone(sTVarDecl);
        sTVarDecl.name = this.name;
        sTVarDecl.modifiers = this.modifiers;
        if (this.init != null) {
            sTVarDecl.init = this.init.clone();
        }
        if (this.type != null) {
            sTVarDecl.setType(this.type.clone());
        }
        return sTVarDecl;
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }
}

