/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.Visitor;

public abstract class STType
extends STNode {
    public STType(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public boolean isAny() {
        return false;
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }

    @Override
    public abstract STType clone();

    public boolean isFunctionPointer() {
        return false;
    }

    private static STPrimitiveType makePrimitive(SourceInfo sourceInfo, String string) {
        return new STPrimitiveType(sourceInfo, string);
    }

    public static STPrimitiveType makePrimitiveVoid(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "void");
    }

    public static STPrimitiveType makePrimitiveInt(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "int");
    }

    public static STPrimitiveType makePrimitiveBoolean(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "boolean");
    }

    public static STPrimitiveType makePrimitiveChar(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "char");
    }

    public static STPrimitiveType makePrimitiveDouble(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "double");
    }

    public static STPrimitiveType makePrimitiveFloat(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "float");
    }

    public static STPrimitiveType makePrimitiveLong(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "long");
    }

    public static STPrimitiveType makePrimitiveShort(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "short");
    }

    public static STPrimitiveType makePrimitiveByte(SourceInfo sourceInfo) {
        return STType.makePrimitive(sourceInfo, "byte");
    }

    public static class STPrimitiveType
    extends STType {
        private String name;

        public STPrimitiveType(SourceInfo sourceInfo, String string) {
            super(sourceInfo);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public FList<STNode> getChildren() {
            return FTreeList.emptyList();
        }

        @Override
        public STType clone() {
            return (STType)this.clone(new STPrimitiveType(this.getSourceInfo(), this.name));
        }
    }

    public static class STFunctionPointerType
    extends STType {
        private FList<STType> parameters = FTreeList.emptyList();
        private STType returnType;

        private STFunctionPointerType(SourceInfo sourceInfo) {
            super(sourceInfo);
        }

        public STFunctionPointerType(SourceInfo sourceInfo, STType sTType, FList<STType> fList) {
            super(sourceInfo);
            this.returnType = sTType;
            this.parameters = fList;
        }

        @Override
        public boolean isFunctionPointer() {
            return true;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getReturnType());
            stringBuilder.append(" ");
            stringBuilder.append("(");
            boolean bl = true;
            for (STType sTType : this.parameters) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(sTType);
                bl = false;
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public STType getReturnType() {
            return this.returnType;
        }

        public void setReturnType(STType sTType) {
            this.returnType = sTType;
        }

        public FList<STType> getParameters() {
            return this.parameters;
        }

        public void setParameters(FList<STType> fList) {
            this.parameters = fList;
            for (STType sTType : fList) {
                sTType.setParent(this);
            }
        }

        public void addParameter(STType sTType) {
            this.parameters = this.parameters.withLast(sTType);
            sTType.setParent(this);
        }

        @Override
        public FList<STNode> getChildren() {
            FTreeList<STNode> fTreeList = FTreeList.emptyList();
            if (this.returnType != null) {
                fTreeList = fTreeList.withLast(this.returnType);
            }
            fTreeList = fTreeList.concat(this.parameters);
            return fTreeList;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public STType clone() {
            return this.clone(new STFunctionPointerType(this.getSourceInfo()));
        }

        @Override
        protected STType clone(STNode sTNode) {
            STFunctionPointerType sTFunctionPointerType = (STFunctionPointerType)sTNode;
            super.clone(sTFunctionPointerType);
            sTFunctionPointerType.setReturnType(this.returnType.clone());
            FTreeList fTreeList = new FTreeList();
            for (STType sTType : this.parameters) {
                sTFunctionPointerType.addParameter(sTType.clone());
            }
            return sTFunctionPointerType;
        }
    }

    public static class STArrayType
    extends STType {
        private STType base;

        public STArrayType(SourceInfo sourceInfo, STType sTType) {
            super(sourceInfo);
            this.setBase(sTType);
        }

        public void setBase(STType sTType) {
            this.base = sTType;
            sTType.setParent(this);
        }

        public STType getBase() {
            return this.base;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public FList<STNode> getChildren() {
            return this.filterNullChildren(this.base);
        }

        @Override
        public STType clone() {
            return (STType)this.clone(new STArrayType(this.getSourceInfo(), this.base.clone()));
        }
    }

    public static class STPointerType
    extends STType {
        private STType base;

        public STPointerType(SourceInfo sourceInfo, STType sTType) {
            super(sourceInfo);
            this.setBase(sTType);
        }

        public void setBase(STType sTType) {
            this.base = sTType;
            sTType.setParent(this);
        }

        public STType getBase() {
            return this.base;
        }

        public String toString() {
            return this.getBase().toString() + "*";
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public FList<STNode> getChildren() {
            return this.filterNullChildren(this.base);
        }

        @Override
        public STType clone() {
            return (STType)this.clone(new STPointerType(this.getSourceInfo(), this.base.clone()));
        }
    }

    public static class STAnyType
    extends STType {
        public STAnyType(SourceInfo sourceInfo) {
            super(sourceInfo);
        }

        public STAnyType() {
            super(new SourceInfo());
        }

        @Override
        public boolean isAny() {
            return true;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public STType clone() {
            return (STType)this.clone(new STAnyType(this.getSourceInfo()));
        }

        @Override
        public FList<STNode> getChildren() {
            return FTreeList.emptyList();
        }
    }

    public static class STClassType
    extends STType {
        private String name;

        public STClassType(String string) {
            super(new SourceInfo());
            this.name = string;
        }

        public STClassType(SourceInfo sourceInfo, String string) {
            super(sourceInfo);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public FList<STNode> getChildren() {
            return FTreeList.emptyList();
        }

        @Override
        public STType clone() {
            return (STType)this.clone(new STClassType(this.getSourceInfo(), this.name));
        }
    }
}

