/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FHashMap;
import com.ergy.fset.FList;
import com.ergy.fset.FMap;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STBlock;
import com.fortify.frontend.nst.nodes.STClassDecl;
import com.fortify.frontend.nst.nodes.STFunDecl;
import com.fortify.frontend.nst.nodes.Visitor;
import com.fortify.frontend.nst.util.AnnotationKey;
import java.util.Map;

public abstract class STNode {
    private SourceInfo source;
    private FMap<AnnotationKey<?>, Object> annotations = new FHashMap();
    private STNode parent;

    public STNode getParent() {
        return this.parent;
    }

    public STNode() {
    }

    public STNode(SourceInfo sourceInfo) {
        this.setSourceInfo(sourceInfo);
    }

    public abstract FList<STNode> getChildren();

    protected FList<STNode> filterNullChildren(STNode ... sTNodeArray) {
        FList<STNode> fList = FTreeList.emptyList();
        for (STNode sTNode : sTNodeArray) {
            if (sTNode == null) continue;
            fList = fList.withLast(sTNode);
        }
        return fList;
    }

    public <T> void annotate(AnnotationKey<T> annotationKey, T t) {
        this.annotations = this.annotations.with(annotationKey, t);
    }

    public <T> T getAnnotation(AnnotationKey<T> annotationKey) {
        return (T)this.annotations.get(annotationKey);
    }

    public Map<AnnotationKey<?>, Object> getAnnotations() {
        return this.annotations;
    }

    public void setParent(STNode sTNode) {
        this.parent = sTNode;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        if (sourceInfo != null) {
            this.source = sourceInfo;
        }
    }

    public SourceInfo getSourceInfo() {
        return this.source;
    }

    public abstract STNode clone();

    protected STNode clone(STNode sTNode) {
        sTNode.annotations.putAll((Map<AnnotationKey<?>, Object>)this.annotations);
        return sTNode;
    }

    public abstract <E> E accept(Visitor<E> var1);

    public STClassDecl getEnclosingClass() {
        STNode sTNode;
        for (sTNode = this.parent; sTNode != null && !(sTNode instanceof STClassDecl); sTNode = sTNode.getParent()) {
        }
        return (STClassDecl)sTNode;
    }

    public STFunDecl getEnclosingFunction() {
        STNode sTNode;
        for (sTNode = this.parent; sTNode != null && !(sTNode instanceof STFunDecl); sTNode = sTNode.getParent()) {
        }
        return (STFunDecl)sTNode;
    }

    public STBlock getEnclosingBlock() {
        STNode sTNode;
        for (sTNode = this.parent; sTNode != null && !(sTNode instanceof STBlock); sTNode = sTNode.getParent()) {
        }
        return (STBlock)sTNode;
    }

    public void replaceChild(STNode sTNode, STNode sTNode2) {
    }
}

