/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.Visitor;
import java.util.Collection;

public class STFunCall
extends STExpression {
    private String name;
    private FList<STExpression> arguments = new FTreeList<STExpression>();
    private boolean direct = true;

    @Override
    public FList<STNode> getChildren() {
        return new FTreeList<STNode>((Collection<STNode>)this.arguments);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append(this.name);
        } else {
            stringBuilder.append("???");
        }
        stringBuilder.append("(");
        boolean bl = true;
        for (STExpression sTExpression : this.arguments) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(sTExpression);
            bl = false;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void setArguments(FList<STExpression> fList) {
        for (STExpression sTExpression : fList) {
            sTExpression.setParent(this);
        }
        this.arguments = fList;
    }

    public void setArgument(STExpression sTExpression, int n) {
        sTExpression.setParent(this);
        this.arguments = this.arguments.less(n).withInserted(n, sTExpression);
    }

    public STFunCall() {
    }

    public STFunCall(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public boolean isDirect() {
        return this.direct;
    }

    public boolean isVirtual() {
        return !this.direct;
    }

    public void setDirect() {
        this.direct = true;
    }

    public void setVirtual() {
        this.direct = false;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public FList<STExpression> getArguments() {
        return this.arguments;
    }

    public STExpression getArgument(int n) {
        return (STExpression)this.arguments.get(n);
    }

    @Override
    public STFunCall clone() {
        return this.clone(new STFunCall(this.getSourceInfo()));
    }

    @Override
    protected STFunCall clone(STNode sTNode) {
        STFunCall sTFunCall = (STFunCall)sTNode;
        super.clone(sTFunCall);
        sTFunCall.setName(this.name);
        for (STExpression sTExpression : this.getArguments()) {
            sTFunCall.addArgument(sTExpression.clone());
        }
        return sTFunCall;
    }

    public void addArgument(STExpression sTExpression) {
        sTExpression.setParent(this);
        this.arguments = this.arguments.withLast(sTExpression);
    }

    public void addArgumentStart(STExpression sTExpression) {
        sTExpression.setParent(this);
        this.arguments = this.arguments.withFirst(sTExpression);
    }

    public void replaceArgument(int n, STExpression sTExpression) {
        sTExpression.setParent(this);
        this.arguments = this.arguments.less(n).withInserted(n, sTExpression);
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }

    public static class Indirect
    extends STFunCall {
        private STExpression pointer;

        public Indirect(SourceInfo sourceInfo) {
            super(sourceInfo);
        }

        @Override
        public FList<STNode> getChildren() {
            return super.getChildren().withLast(this.pointer);
        }

        public STExpression getPointer() {
            return this.pointer;
        }

        public void setPointer(STExpression sTExpression) {
            this.pointer = sTExpression;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }
    }
}

