/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STFunDecl;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STStatement;
import com.fortify.frontend.nst.nodes.Visitor;
import java.util.Collection;

public class STBlock
extends STStatement {
    private FList<STNode> body = new FTreeList<STNode>();
    private boolean foldable = true;

    public FList<STNode> getBody() {
        return this.body;
    }

    @Override
    public FList<STNode> getChildren() {
        return this.body;
    }

    public void setBody(FList<STNode> fList) {
        for (STNode sTNode : fList) {
            sTNode.setParent(this);
        }
        this.body = fList;
    }

    public void setFoldable(boolean bl) {
        this.foldable = bl;
    }

    public boolean isFoldable() {
        return this.foldable;
    }

    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    public void setBody(Collection<? extends STNode> collection) {
        for (STNode sTNode : collection) {
            this.add(sTNode);
        }
    }

    public STBlock(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public STBlock() {
    }

    public void add(STNode sTNode) {
        assert (!(sTNode instanceof STFunDecl));
        if (sTNode != null) {
            sTNode.setParent(this);
            this.body = this.body.withLast(sTNode);
        }
    }

    public void addBefore(STNode sTNode, STNode sTNode2) {
        int n = this.body.indexOf(sTNode);
        if (n != -1) {
            sTNode2.setParent(this);
            this.body = this.body.withInserted(n, sTNode2);
        }
    }

    public void addAfter(STNode sTNode, STNode sTNode2) {
        int n = this.body.indexOf(sTNode);
        if (n != -1) {
            sTNode2.setParent(this);
            this.body = n < this.body.size() ? this.body.withInserted(n + 1, sTNode2) : this.body.withLast(sTNode2);
        }
    }

    public void addFront(STNode sTNode) {
        assert (!(sTNode instanceof STFunDecl));
        sTNode.setParent(this);
        this.body = this.body.withFirst(sTNode);
    }

    public FList<STNode> getStatements() {
        return this.body;
    }

    public int getChildCount() {
        return this.body.size();
    }

    public STNode getFirst() {
        if (this.body.size() > 0) {
            STNode sTNode = (STNode)this.body.get(0);
            if (sTNode instanceof STBlock) {
                return ((STBlock)sTNode).getFirst();
            }
            return sTNode;
        }
        return null;
    }

    public STNode getLast() {
        if (this.body.size() == 0) {
            return null;
        }
        STNode sTNode = (STNode)this.body.get(this.body.size() - 1);
        if (sTNode instanceof STBlock) {
            return ((STBlock)sTNode).getLast();
        }
        return sTNode;
    }

    public STNode getNext(STNode sTNode) {
        int n = this.body.indexOf(sTNode);
        if (n != -1 && this.body.size() > n + 1) {
            return (STNode)this.body.get(n + 1);
        }
        return null;
    }

    public void removeLast() {
        if (this.body.size() > 0) {
            this.body = this.body.subList(0, this.body.size() - 1);
        }
    }

    public void remove(STNode sTNode) {
        int n = this.body.indexOf(sTNode);
        if (n >= 0 && n < this.body.size()) {
            this.body = this.body.less(n);
        }
    }

    public void removeAll(Collection<? extends STNode> collection) {
        for (STNode sTNode : collection) {
            this.remove(sTNode);
        }
    }

    @Override
    public void replaceChild(STNode sTNode, STNode sTNode2) {
        sTNode2.setParent(this);
        this.body = this.body.with(this.body.indexOf(sTNode), sTNode2);
    }

    @Override
    public STBlock clone() {
        return this.clone(new STBlock(this.getSourceInfo()));
    }

    @Override
    protected STBlock clone(STNode sTNode) {
        STBlock sTBlock = (STBlock)sTNode;
        super.clone(sTBlock);
        FList<STNode> fList = new FTreeList<STNode>();
        sTBlock.setLabel(this.getLabel());
        for (int i = 0; i < this.getStatements().size(); ++i) {
            STNode sTNode2 = ((STNode)this.getStatements().get(i)).clone();
            sTNode2.setParent(sTBlock);
            fList = fList.withLast(sTNode2);
        }
        sTBlock.setBody(fList);
        return sTBlock;
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }

    public <E extends STNode> void replaceLastStatement(Visitor<E> visitor) {
        if (!this.body.isEmpty()) {
            STNode sTNode = (STNode)this.body.get(this.body.size() - 1);
            STNode sTNode2 = (STNode)sTNode.accept(visitor);
            this.body = this.body.subList(0, this.body.size() - 1).withLast(sTNode2);
        }
    }
}

