/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFList;
import com.ergy.fset.FList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class FTreeList<Elt>
extends AbstractFList<Elt>
implements Comparable<FTreeList<Elt>>,
Serializable {
    private static final FTreeList<?> EMPTY_INSTANCE = new FTreeList();
    private final transient Object tree;
    private final Comparator<Elt> elt_comp;
    private transient int hash_code = Integer.MIN_VALUE;
    private static final int MAX_LEAF_ARRAY_LENGTH = 8;
    private static final int BALANCE_FACTOR = 4;
    private static Field TreeField;

    public static <Elt> FTreeList<Elt> emptyList() {
        return EMPTY_INSTANCE;
    }

    public FTreeList() {
        this.tree = null;
        this.elt_comp = null;
    }

    public FTreeList(Comparator<? super Elt> comparator) {
        this.tree = null;
        this.elt_comp = comparator;
    }

    public FTreeList(Collection<? extends Elt> collection) {
        this.elt_comp = null;
        this.tree = collection instanceof FTreeList ? ((FTreeList)collection).tree : FTreeList.fromCollection(collection);
    }

    public FTreeList(Collection<? extends Elt> collection, Comparator<? super Elt> comparator) {
        this.elt_comp = comparator;
        this.tree = collection instanceof FTreeList ? ((FTreeList)collection).tree : FTreeList.fromCollection(collection);
    }

    public <T extends Elt> FTreeList(T ... TArray) {
        this.elt_comp = null;
        this.tree = FTreeList.fromCollection(TArray);
    }

    public <T extends Elt> FTreeList(Comparator<? super Elt> comparator, T ... TArray) {
        this.elt_comp = comparator;
        this.tree = FTreeList.fromCollection(TArray);
    }

    static Object fromCollection(Object object) {
        int n;
        Iterator iterator = null;
        Object[] objectArray = null;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
            n = objectArray.length;
        } else {
            Collection collection = (Collection)object;
            n = collection.size();
            iterator = collection.iterator();
        }
        if (n == 0) {
            return null;
        }
        int n2 = n / 8 + n % 8 > 0 ? 1 : 0;
        int n3 = n / n2;
        int n4 = n % n2;
        int n5 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n2; ++i) {
            int n6;
            int n7 = i < n4 ? n3 + 1 : n3;
            Object[] objectArray2 = new Object[n7];
            if (iterator != null) {
                for (n6 = 0; n6 < n7; ++n6) {
                    objectArray2[n6] = iterator.next();
                }
            } else {
                for (n6 = 0; n6 < n7; ++n6) {
                    objectArray2[n6] = objectArray[n6 + n5];
                }
            }
            n5 += n7;
            arrayList.add(objectArray2);
            n6 = i;
            while ((n6 & 1) == 1) {
                Object e = arrayList.remove(arrayList.size() - 1);
                Object e2 = arrayList.remove(arrayList.size() - 1);
                arrayList.add(FTreeList.makeNode(e2, e));
                n6 >>= 1;
            }
        }
        while (arrayList.size() > 1) {
            Object e = arrayList.remove(arrayList.size() - 1);
            Object e3 = arrayList.remove(arrayList.size() - 1);
            arrayList.add(FTreeList.makeNode(e3, e));
        }
        return arrayList.get(0);
    }

    @Override
    public boolean isEmpty() {
        return this.tree == null;
    }

    @Override
    public int size() {
        return FTreeList.treeSize(this.tree);
    }

    @Override
    public Elt get(int n) {
        if (n < 0 || n >= FTreeList.treeSize(this.tree)) {
            throw new IndexOutOfBoundsException();
        }
        return (Elt)FTreeList.get(this.tree, n);
    }

    @Override
    public Iterator<Elt> iterator() {
        return new FTLIterator(this.tree);
    }

    @Override
    public ListIterator<Elt> listIterator() {
        return new FTLIterator(this.tree);
    }

    public ListIterator<Elt> iterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new FTLIterator(this.tree, n);
    }

    @Override
    public ListIterator<Elt> listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new FTLIterator(this.tree, n);
    }

    @Override
    public FTreeList<Elt> with(int n, Elt Elt) {
        int n2 = FTreeList.treeSize(this.tree);
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return new FTreeList<Elt>(FTreeList.insert(this.tree, n, Elt), this.elt_comp);
        }
        return new FTreeList<Elt>(FTreeList.with(this.tree, n, Elt), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> withInserted(int n, Elt Elt) {
        if (n < 0 || n > FTreeList.treeSize(this.tree)) {
            throw new IndexOutOfBoundsException();
        }
        return new FTreeList<Elt>(FTreeList.insert(this.tree, n, Elt), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> withFirst(Elt Elt) {
        return new FTreeList<Elt>(FTreeList.insert(this.tree, 0, Elt), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> withLast(Elt Elt) {
        return new FTreeList<Elt>(FTreeList.insert(this.tree, FTreeList.treeSize(this.tree), Elt), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> less(int n) {
        if (n < 0 || n >= FTreeList.treeSize(this.tree)) {
            throw new IndexOutOfBoundsException();
        }
        return new FTreeList<Elt>(FTreeList.less(this.tree, n), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> lessFirst() {
        return this.less(0);
    }

    @Override
    public FTreeList<Elt> lessLast() {
        return this.less(this.size() - 1);
    }

    @Override
    public FTreeList<Elt> concat(List<? extends Elt> list) {
        if (list.isEmpty()) {
            return this;
        }
        if (list instanceof FTreeList) {
            return new FTreeList<Elt>(FTreeList.concat(this.tree, ((FTreeList)list).tree), this.elt_comp);
        }
        return new FTreeList<Elt>(FTreeList.concat(this.tree, FTreeList.fromCollection(list)), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> reverse() {
        if (this.tree == null) {
            return this;
        }
        return new FTreeList<Elt>(FTreeList.reverse(this.tree), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> subseq(int n, int n2) {
        int n3 = FTreeList.treeSize(this.tree);
        if (n < 0 || n > n3 || n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return new FTreeList<Elt>(FTreeList.subseq(this.tree, n, n2), this.elt_comp);
    }

    @Override
    public FTreeList<Elt> prefix(int n) {
        return this.subseq(0, n);
    }

    @Override
    public FTreeList<Elt> suffix(int n) {
        return this.subseq(this.size() - n, this.size());
    }

    @Override
    public FTreeList<Elt> suffixFrom(int n) {
        return this.subseq(n, this.size());
    }

    @Override
    public boolean isPrefix(FList<Elt> fList) {
        int n = FTreeList.treeSize(this.tree);
        if (n > fList.size()) {
            return false;
        }
        if (fList instanceof FTreeList) {
            return this.equals(this.tree, 0, ((FTreeList)fList).tree, 0, 0, n);
        }
        Iterator<Elt> iterator = this.iterator();
        Iterator iterator2 = fList.iterator();
        while (iterator.hasNext()) {
            if (FTreeList.eql(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuffix(FList<Elt> fList) {
        int n;
        int n2 = FTreeList.treeSize(this.tree);
        if (n2 > (n = fList.size())) {
            return false;
        }
        if (fList instanceof FTreeList) {
            Object object = ((FTreeList)fList).tree;
            return this.equals(this.tree, n - n2, object, 0, n - n2, n);
        }
        Iterator<Elt> iterator = this.iterator();
        ListIterator listIterator = fList.listIterator(n - n2);
        while (iterator.hasNext()) {
            if (FTreeList.eql(iterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public FList<Elt> subList(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException();
        }
        return this.subseq(n, n2);
    }

    @Override
    public FTreeList<Elt> sorted(Comparator<? super Elt> comparator) {
        Object[] objectArray = this.toArray();
        Arrays.sort(objectArray, comparator);
        return new FTreeList<Elt>(objectArray);
    }

    public FTreeList sorted() {
        return this.sorted((Comparator)null);
    }

    @Override
    public boolean contains(Object object) {
        return FTreeList.indexOf(this.tree, object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        return FTreeList.indexOf(this.tree, object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return FTreeList.lastIndexOf(this.tree, object);
    }

    @Override
    public int compareTo(FTreeList<Elt> fTreeList) {
        if (fTreeList == this) {
            return 0;
        }
        if (fTreeList == null || !(fTreeList instanceof FTreeList) || !FTreeList.eql(this.elt_comp, fTreeList.elt_comp)) {
            throw new ClassCastException();
        }
        return this.compareTo(this.tree, fTreeList.tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FTreeList) {
            FTreeList fTreeList = (FTreeList)object;
            return this.equals(this.tree, fTreeList.tree);
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Elt> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Object e;
            Elt Elt = iterator.next();
            if (FTreeList.eql(Elt, e = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = FTreeList.hashCode(this.tree, 1);
        }
        return this.hash_code;
    }

    String dump() {
        return FTreeList.dump(this.tree);
    }

    boolean verify() {
        return this.verify(this.tree);
    }

    FTreeList(Object object, Comparator<? super Elt> comparator) {
        this.tree = object;
        this.elt_comp = comparator;
    }

    private static Object makeNode(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return new Node(FTreeList.treeSize(object) + FTreeList.treeSize(object2), object, object2);
    }

    static int treeSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            return ((Object[])object).length;
        }
        return ((Node)object).size;
    }

    static Object get(Object object, int n) {
        if (!(object instanceof Node)) {
            return ((Object[])object)[n];
        }
        Node node = (Node)object;
        int n2 = FTreeList.treeSize(node.left);
        if (n < n2) {
            return FTreeList.get(node.left, n);
        }
        return FTreeList.get(node.right, n - n2);
    }

    private static Object with(Object object, int n, Object object2) {
        if (!(object instanceof Node)) {
            return FTreeList.update((Object[])object, n, object2);
        }
        Node node = (Node)object;
        int n2 = FTreeList.treeSize(node.left);
        if (n < n2) {
            return FTreeList.makeNode(FTreeList.with(node.left, n, object2), node.right);
        }
        return FTreeList.makeNode(node.left, FTreeList.with(node.right, n - n2, object2));
    }

    static Object insert(Object object, int n, Object object2) {
        if (object == null) {
            Object[] objectArray = new Object[]{object2};
            return objectArray;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            if (n2 < 8) {
                return FTreeList.insert(objectArray, n, object2);
            }
            if (n * 2 < n2) {
                return FTreeList.makeNode(FTreeList.subseqInsert(objectArray, 0, n, n, object2), FTreeList.subseq(objectArray, n, n2));
            }
            return FTreeList.makeNode(FTreeList.subseq(objectArray, 0, n), FTreeList.subseqInsert(objectArray, n, n2, 0, object2));
        }
        Node node = (Node)object;
        int n3 = FTreeList.treeSize(node.left);
        if (n < n3) {
            return FTreeList.buildNode(FTreeList.insert(node.left, n, object2), node.right);
        }
        return FTreeList.buildNode(node.left, FTreeList.insert(node.right, n - n3, object2));
    }

    static Object less(Object object, int n) {
        if (!(object instanceof Node)) {
            return FTreeList.less((Object[])object, n);
        }
        Node node = (Node)object;
        int n2 = FTreeList.treeSize(node.left);
        if (n < n2) {
            return FTreeList.buildNode(FTreeList.less(node.left, n), node.right);
        }
        return FTreeList.buildNode(node.left, FTreeList.less(node.right, n - n2));
    }

    private static Object reverse(Object object) {
        if (!(object instanceof Node)) {
            return FTreeList.reverse((Object[])object);
        }
        Node node = (Node)object;
        return FTreeList.makeNode(FTreeList.reverse(node.right), FTreeList.reverse(node.left));
    }

    private int compareTo(Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        int n2 = FTreeList.treeSize(object);
        if (n2 < (n = FTreeList.treeSize(object2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return this.compareTo(object, 0, object2, 0, 0, n2);
    }

    private int compareTo(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (n3 == n4) {
            return 0;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    int n5 = this.compareElements(objectArray[i - n], objectArray2[i - n2]);
                    if (n5 == 0) continue;
                    return n5;
                }
                return 0;
            }
            return -this.compareTo(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object3 = node.left;
        int n6 = FTreeList.treeSize(object3);
        int n7 = n + n6;
        RankTrimResult rankTrimResult = this.rankTrim(object3, n, n3, n7);
        RankTrimResult rankTrimResult2 = this.rankTrim(object2, n2, n3, n7);
        int n8 = this.compareTo(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n7);
        if (n8 != 0) {
            return n8;
        }
        int n9 = n7;
        RankTrimResult rankTrimResult3 = this.rankTrim(node.right, n9, n9, n4);
        RankTrimResult rankTrimResult4 = this.rankTrim(object2, n2, n9, n4);
        return this.compareTo(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n9, n4);
    }

    private boolean equals(Object object, Object object2) {
        int n;
        if (object == object2) {
            return true;
        }
        int n2 = FTreeList.treeSize(object);
        if (n2 != (n = FTreeList.treeSize(object2))) {
            return false;
        }
        return this.equals(object, 0, object2, 0, 0, n2);
    }

    private boolean equals(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (n3 == n4) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    Object object3 = objectArray[i - n];
                    Object object4 = objectArray2[i - n2];
                    if (FTreeList.eql(object3, object4)) continue;
                    return false;
                }
                return true;
            }
            return this.equals(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object5 = node.left;
        int n5 = FTreeList.treeSize(object5);
        int n6 = n + n5;
        RankTrimResult rankTrimResult = this.rankTrim(object5, n, n3, n6);
        RankTrimResult rankTrimResult2 = this.rankTrim(object2, n2, n3, n6);
        if (!this.equals(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n6)) {
            return false;
        }
        RankTrimResult rankTrimResult3 = this.rankTrim(node.right, n6, n6, n4);
        RankTrimResult rankTrimResult4 = this.rankTrim(object2, n2, n6, n4);
        return this.equals(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n6, n4);
    }

    private RankTrimResult rankTrim(Object object, int n, int n2, int n3) {
        while (object instanceof Node) {
            Node node = (Node)object;
            int n4 = n + FTreeList.treeSize(node.left);
            if (n4 >= n2) {
                if (n4 < n3) break;
                object = node.left;
                continue;
            }
            n = n4;
            object = node.right;
        }
        return new RankTrimResult(object, n);
    }

    private static Object concat(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        int n = FTreeList.treeSize(object);
        int n2 = FTreeList.treeSize(object2);
        if (object instanceof Node && n > n2 * 4) {
            Node node = (Node)object;
            return FTreeList.buildNode(node.left, FTreeList.concat(node.right, object2));
        }
        if (object2 instanceof Node && n2 > n * 4) {
            Node node = (Node)object2;
            return FTreeList.buildNode(FTreeList.concat(object, node.left), node.right);
        }
        return FTreeList.buildNode(object, object2);
    }

    private static Object buildNode(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (!(object instanceof Node) && !(object2 instanceof Node)) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length + objectArray2.length < 8) {
                return FTreeList.concat(objectArray, objectArray2);
            }
            return FTreeList.makeNode(object, object2);
        }
        int n = FTreeList.treeSize(object);
        int n2 = FTreeList.treeSize(object2);
        if (object2 instanceof Node && n2 > n * 4) {
            Node node = (Node)object2;
            Object object3 = node.left;
            Object object4 = node.right;
            if (!(object3 instanceof Node) || FTreeList.treeSize(object3) <= FTreeList.treeSize(object4)) {
                return FTreeList.makeNode(FTreeList.buildNode(object, object3), object4);
            }
            Node node2 = (Node)object3;
            return FTreeList.makeNode(FTreeList.buildNode(object, node2.left), FTreeList.buildNode(node2.right, object4));
        }
        if (object instanceof Node && n > n2 * 4) {
            Node node = (Node)object;
            Object object5 = node.left;
            Object object6 = node.right;
            if (!(object6 instanceof Node) || FTreeList.treeSize(object6) <= FTreeList.treeSize(object5)) {
                return FTreeList.makeNode(object5, FTreeList.buildNode(object6, object2));
            }
            Node node3 = (Node)object6;
            return FTreeList.makeNode(FTreeList.buildNode(object5, node3.left), FTreeList.buildNode(node3.right, object2));
        }
        return FTreeList.makeNode(object, object2);
    }

    private int compareElements(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (this.elt_comp != null) {
            return this.elt_comp.compare(object, object2);
        }
        Comparable comparable = (Comparable)object;
        Comparable comparable2 = (Comparable)object2;
        return comparable.compareTo(comparable2);
    }

    private static Object subseq(Object object, int n, int n2) {
        if (n >= n2) {
            return null;
        }
        if (n == 0 && n2 == FTreeList.treeSize(object)) {
            return object;
        }
        if (!(object instanceof Node)) {
            return FTreeList.subseq((Object[])object, n, n2);
        }
        Node node = (Node)object;
        int n3 = FTreeList.treeSize(node.left);
        if (n2 <= n3) {
            return FTreeList.subseq(node.left, n, n2);
        }
        if (n >= n3) {
            return FTreeList.subseq(node.right, n - n3, n2 - n3);
        }
        return FTreeList.concat(FTreeList.subseq(node.left, n, n3), FTreeList.subseq(node.right, 0, n2 - n3));
    }

    private static int indexOf(Object object, Object object2) {
        if (object == null) {
            return -1;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!FTreeList.eql(object2, objectArray[i])) continue;
                return i;
            }
            return -1;
        }
        Node node = (Node)object;
        int n = FTreeList.indexOf(node.left, object2);
        if (n >= 0) {
            return n;
        }
        int n2 = FTreeList.indexOf(node.right, object2);
        if (n2 >= 0) {
            return n2 + FTreeList.treeSize(node.left);
        }
        return -1;
    }

    private static int lastIndexOf(Object object, Object object2) {
        if (object == null) {
            return -1;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            while (--n >= 0) {
                if (!FTreeList.eql(object2, objectArray[n])) continue;
                return n;
            }
            return -1;
        }
        Node node = (Node)object;
        int n = FTreeList.lastIndexOf(node.right, object2);
        if (n >= 0) {
            return n + FTreeList.treeSize(node.left);
        }
        int n2 = FTreeList.lastIndexOf(node.left, object2);
        if (n2 >= 0) {
            return n2;
        }
        return -1;
    }

    private static Object[] concat(Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = objectArray2 == null ? 0 : objectArray2.length;
        int n4 = n2 + n3;
        Object[] objectArray3 = new Object[n4];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
        }
        for (n = 0; n < n3; ++n) {
            objectArray3[n + n2] = objectArray2[n];
        }
        return objectArray3;
    }

    private static Object[] update(Object[] objectArray, int n, Object object) {
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray2[i] = objectArray[i];
        }
        objectArray2[n] = object;
        return objectArray2;
    }

    private static Object[] insert(Object[] objectArray, int n, Object object) {
        int n2;
        int n3 = objectArray.length + 1;
        Object[] objectArray2 = new Object[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        objectArray2[n] = object;
        for (n2 = n + 1; n2 < n3; ++n2) {
            objectArray2[n2] = objectArray[n2 - 1];
        }
        return objectArray2;
    }

    private static Object[] less(Object[] objectArray, int n) {
        int n2;
        int n3 = objectArray.length - 1;
        if (n3 == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            objectArray2[n2] = objectArray[n2 + 1];
        }
        return objectArray2;
    }

    private static Object[] reverse(Object[] objectArray) {
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = objectArray[n - i - 1];
        }
        return objectArray2;
    }

    private static Object[] subseq(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return null;
        }
        int n3 = n2 - n;
        Object[] objectArray2 = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray2[i] = objectArray[i + n];
        }
        return objectArray2;
    }

    private static Object[] subseqInsert(Object[] objectArray, int n, int n2, int n3, Object object) {
        int n4;
        int n5 = n2 - n;
        Object[] objectArray2 = new Object[n5 + 1];
        for (n4 = 0; n4 < n3; ++n4) {
            objectArray2[n4] = objectArray[n4 + n];
        }
        objectArray2[n3] = object;
        for (n4 = n3; n4 < n5; ++n4) {
            objectArray2[n4 + 1] = objectArray[n4 + n];
        }
        return objectArray2;
    }

    private static int hashCode(Object object, int n) {
        if (object == null) {
            return n;
        }
        if (!(object instanceof Node)) {
            for (Object object2 : (Object[])object) {
                n = 31 * n + (object2 == null ? 0 : object2.hashCode());
            }
        } else {
            Node node = (Node)object;
            n = FTreeList.hashCode(node.left, n);
            n = FTreeList.hashCode(node.right, n);
        }
        return n;
    }

    private static String dump(Object object) {
        if (object == null) {
            return "null";
        }
        if (!(object instanceof Node)) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(FTreeList.dump(objectArray[i]));
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return "(" + node.size + ";\n" + FTreeList.indent(FTreeList.dump(node.left), "  ") + ",\n" + FTreeList.indent(FTreeList.dump(node.right), "  ") + ")";
        }
        return object.toString();
    }

    private static String indent(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\n' || i >= n - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private boolean verify(Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return objectArray.length <= 8;
        }
        Node node = (Node)object;
        if (node.left == null || node.right == null) {
            return false;
        }
        int n = FTreeList.treeSize(node.left);
        int n2 = FTreeList.treeSize(node.right);
        if (node.size != n + n2) {
            return false;
        }
        if (n2 > 4 && n > n2 * 4 || n > 4 && n2 > n * 4) {
            return false;
        }
        return this.verify(node.left) && this.verify(node.right);
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        Iterator<Elt> iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        try {
            TreeField.set(this, FTreeList.fromCollection(objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FTreeList deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            TreeField = FTreeList.class.getDeclaredField("tree");
            TreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }

    static final class FTLIterator<Elt>
    implements ListIterator<Elt> {
        private IteratorNode inode;
        private boolean at_start = false;
        private boolean at_end = false;
        static final int RIGHT_END = Integer.MAX_VALUE;

        FTLIterator(Object object) {
            this.inode = new IteratorNode(object, 0, null);
            this.at_start = true;
            if (object == null) {
                this.at_end = true;
            }
            this.canonicalizeFwd();
        }

        private FTLIterator(Object object, int n) {
            this.inode = new IteratorNode(object, 0, null);
            this.at_start = n == 0;
            boolean bl = this.at_end = n == FTreeList.treeSize(object);
            if (this.at_end) {
                if (object instanceof Node) {
                    this.inode.index = 2;
                } else {
                    this.inode.index = n;
                }
                return;
            }
            while (this.inode.subtree instanceof Node) {
                Node node = (Node)this.inode.subtree;
                int n2 = FTreeList.treeSize(node.left);
                if (n < n2) {
                    this.inode.index = 0;
                    this.inode = new IteratorNode(node.left, 0, this.inode);
                    continue;
                }
                n -= n2;
                this.inode.index = 1;
                this.inode = new IteratorNode(node.right, 0, this.inode);
            }
            this.inode.index = n;
        }

        private void canonicalizeFwd() {
            if (this.at_end) {
                return;
            }
            while (true) {
                if (!(this.inode.subtree instanceof Node)) {
                    if (this.inode.index < ((Object[])this.inode.subtree).length) break;
                    if (this.inode.parent == null) {
                        this.at_end = true;
                        break;
                    }
                    this.inode = this.inode.parent;
                    ++this.inode.index;
                    continue;
                }
                Node node = (Node)this.inode.subtree;
                if (this.inode.index == 0) {
                    this.inode = new IteratorNode(node.left, 0, this.inode);
                    continue;
                }
                if (this.inode.index == 1) {
                    this.inode = new IteratorNode(node.right, 0, this.inode);
                    continue;
                }
                if (this.inode.parent == null) {
                    this.at_end = true;
                    break;
                }
                this.inode = this.inode.parent;
                ++this.inode.index;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.at_end;
        }

        @Override
        public Elt next() {
            if (this.at_end) {
                throw new NoSuchElementException();
            }
            Object object = ((Object[])this.inode.subtree)[this.inode.index++];
            this.at_start = false;
            this.canonicalizeFwd();
            return (Elt)object;
        }

        @Override
        public int nextIndex() {
            int n = 0;
            IteratorNode iteratorNode = this.inode;
            while (iteratorNode != null) {
                if (!(iteratorNode.subtree instanceof Node)) {
                    n += iteratorNode.index;
                } else if (iteratorNode.index == 1) {
                    n += FTreeList.treeSize(((Node)iteratorNode.subtree).left);
                } else if (iteratorNode.index == 2) {
                    n += FTreeList.treeSize(iteratorNode.subtree);
                }
                iteratorNode = iteratorNode.parent;
            }
            return n;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        private void canonicalizeRev() {
            block7: {
                if (this.at_start) {
                    return;
                }
                while (true) {
                    Object object;
                    if (!(this.inode.subtree instanceof Node)) {
                        if (this.inode.index == Integer.MAX_VALUE) {
                            this.inode.index = ((Object[])this.inode.subtree).length;
                        }
                        if (this.inode.index > 0) break block7;
                        object = this.inode.parent;
                        while (object != null && ((IteratorNode)object).index <= 0) {
                            object = ((IteratorNode)object).parent;
                        }
                        if (object == null) {
                            this.at_start = true;
                            break block7;
                        }
                        this.inode = object;
                        --this.inode.index;
                        continue;
                    }
                    object = (Node)this.inode.subtree;
                    if (this.inode.index == 2 || this.inode.index == Integer.MAX_VALUE) {
                        this.inode.index = 1;
                        this.inode = new IteratorNode(((Node)object).right, Integer.MAX_VALUE, this.inode);
                        continue;
                    }
                    if (this.inode.index != 0) break;
                    this.inode = new IteratorNode(((Node)object).left, Integer.MAX_VALUE, this.inode);
                }
                throw new RuntimeException("Bug in `FTreeList.FTLIterator.canonicalizeRev'");
            }
        }

        @Override
        public boolean hasPrevious() {
            return !this.at_start;
        }

        @Override
        public Elt previous() {
            this.canonicalizeRev();
            if (this.at_start) {
                throw new NoSuchElementException();
            }
            Object object = ((Object[])this.inode.subtree)[--this.inode.index];
            if (this.inode.index == 0) {
                IteratorNode iteratorNode = this.inode.parent;
                while (iteratorNode != null && iteratorNode.index <= 0) {
                    iteratorNode = iteratorNode.parent;
                }
                if (iteratorNode == null) {
                    this.at_start = true;
                }
            }
            this.at_end = false;
            return (Elt)object;
        }

        @Override
        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        private static final class IteratorNode {
            private final Object subtree;
            private int index;
            private final IteratorNode parent;

            public IteratorNode(Object object, int n, IteratorNode iteratorNode) {
                this.subtree = object;
                this.index = n;
                this.parent = iteratorNode;
            }
        }
    }

    private static final class RankTrimResult {
        public Object subtree;
        public int base;

        public RankTrimResult(Object object, int n) {
            this.subtree = object;
            this.base = n;
        }
    }

    private static final class Node {
        private final int size;
        private final Object left;
        private final Object right;

        public Node(int n, Object object, Object object2) {
            this.size = n;
            this.left = object;
            this.right = object2;
        }
    }
}

