/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFMap;
import com.ergy.fset.BinaryOp;
import com.ergy.fset.FHashMap;
import com.ergy.fset.FHashSet;
import com.ergy.fset.FList;
import com.ergy.fset.FMap;
import com.ergy.fset.FSet;
import com.ergy.fset.FTreeList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FLinkedHashMap<Key, Val>
extends AbstractFMap<Key, Val>
implements Comparable<FLinkedHashMap<Key, Val>>,
Serializable {
    private static final FLinkedHashMap<?, ?> EMPTY_INSTANCE = new FLinkedHashMap();
    final transient Object map_tree;
    private final transient Object list_tree;
    private final Val dflt;
    private transient int hash_code = Integer.MIN_VALUE;
    private static Field MapTreeField;
    private static Field ListTreeField;

    public static <Key, Val> FLinkedHashMap<Key, Val> emptyMap() {
        return EMPTY_INSTANCE;
    }

    public FLinkedHashMap() {
        this.map_tree = null;
        this.list_tree = null;
        this.dflt = null;
    }

    private FLinkedHashMap(Object object, Object object2, Val Val) {
        this.map_tree = object;
        this.list_tree = object2;
        this.dflt = Val;
    }

    public static <Key, Val> FLinkedHashMap<Key, Val> withDefault(Val Val) {
        return new FLinkedHashMap<Key, Val>(null, null, Val);
    }

    @Override
    public boolean isEmpty() {
        return this.map_tree == null;
    }

    @Override
    public int size() {
        return FHashMap.treeSize(this.map_tree);
    }

    public FList<Key> keyList() {
        return new FTreeList(this.list_tree, null);
    }

    @Override
    public Map.Entry<Key, Val> arb() {
        return (Map.Entry)FHashMap.arb(this.map_tree);
    }

    @Override
    public boolean contains(Map.Entry<Key, Val> entry) {
        Key Key = entry.getKey();
        Object object = FHashMap.get(this.map_tree, Key, FLinkedHashMap.hashCode(Key));
        return object != FHashMap.NO_ELEMENT && FLinkedHashMap.eql(object, entry.getValue());
    }

    @Override
    public boolean containsKey(Object object) {
        return FHashMap.get(this.map_tree, object, FLinkedHashMap.hashCode(object)) != FHashMap.NO_ELEMENT;
    }

    @Override
    public Val get(Object object) {
        Object object2 = FHashMap.get(this.map_tree, object, FLinkedHashMap.hashCode(object));
        if (object2 == FHashMap.NO_ELEMENT) {
            return this.dflt;
        }
        return (Val)object2;
    }

    @Override
    public FLinkedHashMap<Key, Val> with(Key Key, Val Val) {
        int n = FLinkedHashMap.hashCode(Key);
        Object object = FHashMap.with(this.map_tree, Key, n, Val);
        if (object == this.map_tree) {
            return this;
        }
        if (FHashMap.treeSize(object) == FHashMap.treeSize(this.map_tree)) {
            return new FLinkedHashMap<Key, Val>(object, this.list_tree, this.dflt);
        }
        Object object2 = FTreeList.insert(this.list_tree, FTreeList.treeSize(this.list_tree), Key);
        return new FLinkedHashMap<Key, Val>(object, object2, this.dflt);
    }

    @Override
    public FLinkedHashMap<Key, Val> less(Key Key) {
        Object object = FHashMap.less(this.map_tree, Key, FLinkedHashMap.hashCode(Key));
        if (object == this.map_tree) {
            return this;
        }
        FTreeList.FTLIterator fTLIterator = new FTreeList.FTLIterator(this.list_tree);
        int n = 0;
        while (!FLinkedHashMap.eql(Key, fTLIterator.next())) {
            ++n;
        }
        Object object2 = FTreeList.less(this.list_tree, n);
        return new FLinkedHashMap<Key, Val>(object, object2, this.dflt);
    }

    @Override
    public Set<Key> keySet() {
        return new AbstractSet<Key>(){

            @Override
            public Iterator<Key> iterator() {
                return new FTreeList.FTLIterator(FLinkedHashMap.this.list_tree);
            }

            @Override
            public int size() {
                return FLinkedHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return FLinkedHashMap.this.containsKey(object);
            }
        };
    }

    @Override
    public Collection<Val> values() {
        return new AbstractCollection<Val>(){

            @Override
            public Iterator<Val> iterator() {
                return new FLHMValueIterator(FLinkedHashMap.this.map_tree, FLinkedHashMap.this.list_tree);
            }

            @Override
            public int size() {
                return FLinkedHashMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Key, Val>> entrySet() {
        return new AbstractSet<Map.Entry<Key, Val>>(){

            @Override
            public Iterator<Map.Entry<Key, Val>> iterator() {
                return new FLHMIterator(FLinkedHashMap.this.map_tree, FLinkedHashMap.this.list_tree);
            }

            @Override
            public int size() {
                return FLinkedHashMap.this.size();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public FHashSet<Key> domain() {
        return FHashSet.make(FHashMap.domain(this.map_tree));
    }

    @Override
    public FSet<Val> range() {
        return FHashMap.range(this.map_tree, new FHashSet());
    }

    @Override
    public FSet<Val> range(FSet<Val> fSet) {
        fSet = fSet.difference(fSet);
        return FHashMap.range(this.map_tree, fSet);
    }

    @Override
    public FHashSet<Map.Entry<Key, Val>> toSet() {
        return (FHashSet)this.toSet(new FHashSet<Map.Entry<Key, Val>>());
    }

    @Override
    public FSet<Map.Entry<Key, Val>> toSet(FSet<Map.Entry<Key, Val>> fSet) {
        FSet<Map.Entry<Key, Val>> fSet2 = fSet.difference(fSet);
        FHashMap.FHMIterator fHMIterator = new FHashMap.FHMIterator(this.map_tree);
        while (fHMIterator.hasNext()) {
            fSet2 = fSet2.with((Map.Entry<Key, Val>)fHMIterator.next());
        }
        return fSet2;
    }

    @Override
    public FLinkedHashMap<Key, Val> union(FMap<? extends Key, ? extends Val> fMap) {
        FMap<Key, Val> fMap2 = this;
        for (Map.Entry<Key, Val> entry : fMap) {
            fMap2 = fMap2.with((Object)entry.getKey(), (Object)entry.getValue());
        }
        return fMap2;
    }

    @Override
    public FLinkedHashMap<Key, Val> union(FMap<? extends Key, ? extends Val> fMap, BinaryOp<Val> binaryOp) {
        FMap<Key, Val> fMap2 = this;
        for (Map.Entry<Key, Val> entry : fMap) {
            Key Key;
            fMap2 = fMap2.with((Object)Key, (Object)(this.containsKey(Key = entry.getKey()) ? binaryOp.apply(this.get(Key), entry.getValue()) : entry.getValue()));
        }
        return fMap2;
    }

    @Override
    public FLinkedHashMap<Key, Val> restrictedTo(FSet<Key> fSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FLinkedHashMap<Key, Val> restrictedFrom(FSet<Key> fSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Val getDefault() {
        return this.dflt;
    }

    @Override
    public Iterator<Map.Entry<Key, Val>> iterator() {
        return new FLHMIterator(this.map_tree, this.list_tree);
    }

    @Override
    public int compareTo(FLinkedHashMap<Key, Val> fLinkedHashMap) {
        return FHashMap.compareTo(this.map_tree, fLinkedHashMap.map_tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FLinkedHashMap) {
            FLinkedHashMap fLinkedHashMap = (FLinkedHashMap)object;
            return FHashMap.equals(this.map_tree, fLinkedHashMap.map_tree);
        }
        if (object instanceof FHashMap) {
            FHashMap fHashMap = (FHashMap)object;
            return FHashMap.equals(this.map_tree, fHashMap.tree);
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (FHashMap.contains(this.map_tree, entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = FHashMap.myHashCode(this.map_tree);
        }
        return this.hash_code;
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int hashCode(Object object) {
        return FHashMap.hashCode(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Map.Entry<Key, Val> entry : this) {
            FHashMap.Entry entry2 = (FHashMap.Entry)entry;
            objectOutputStream.writeObject(entry2.key);
            objectOutputStream.writeObject(entry2.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object object = null;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            object = FHashMap.with(object, object2, FLinkedHashMap.hashCode(object2), object3);
            objectArray[i] = object2;
        }
        try {
            MapTreeField.set(this, object);
            ListTreeField.set(this, FTreeList.fromCollection(objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FLinkedHashMap deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            MapTreeField = FLinkedHashMap.class.getDeclaredField("map_tree");
            ListTreeField = FLinkedHashMap.class.getDeclaredField("list_tree");
            MapTreeField.setAccessible(true);
            ListTreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }

    private static final class FLHMValueIterator<Val>
    implements Iterator<Val> {
        private final Object map_tree;
        private final FTreeList.FTLIterator<Object> list_it;

        private FLHMValueIterator(Object object, Object object2) {
            this.map_tree = object;
            this.list_it = new FTreeList.FTLIterator(object2);
        }

        @Override
        public boolean hasNext() {
            return this.list_it.hasNext();
        }

        @Override
        public Val next() {
            Object object = this.list_it.next();
            return (Val)FHashMap.get(this.map_tree, object, FHashMap.hashCode(object));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FLHMIterator<Key, Val>
    implements Iterator<Map.Entry<Key, Val>> {
        private final Object map_tree;
        private final FTreeList.FTLIterator<Key> list_it;

        private FLHMIterator(Object object, Object object2) {
            this.map_tree = object;
            this.list_it = new FTreeList.FTLIterator(object2);
        }

        @Override
        public boolean hasNext() {
            return this.list_it.hasNext();
        }

        @Override
        public Map.Entry<Key, Val> next() {
            Key Key = this.list_it.next();
            Object object = FHashMap.get(this.map_tree, Key, FHashMap.hashCode(Key));
            return new FHashMap.Entry(Key, object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

