/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.tools.fortify.plugin;

import com.lightbend.prodsuite.licenses.EnterpriseSuiteLicense;
import com.lightbend.prodsuite.licenses.LicenseParser;
import com.lightbend.tools.fortify.plugin.BuildInfo$;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class LicenseChecker$ {
    public static LicenseChecker$ MODULE$;

    static {
        new LicenseChecker$();
    }

    public void verifyEntitlements(File licensePath, boolean suppressEntitlementCheck, Function1<String, BoxedUnit> error) {
        BuildInfo$.MODULE$.checkGrant().foreach((Function1 & java.io.Serializable & Serializable)grant -> {
            LicenseChecker$.$anonfun$verifyEntitlements$1(licensePath, error, grant);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<String, Option<ZonedDateTime>> validateGrant(File path, String grant) {
        EnterpriseSuiteLicense enterpriseSuiteLicense;
        try {
            byte[] bytes = Files.readAllBytes(path.toPath());
            enterpriseSuiteLicense = LicenseParser.parse(new String(bytes, Charset.forName("UTF-8")));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                throw new RuntimeException(new StringBuilder(32).append("Error validating license file `").append(path).append("`").toString(), ex);
            }
            throw throwable;
        }
        EnterpriseSuiteLicense esl = enterpriseSuiteLicense;
        if (!esl.getGrants().contains(grant)) {
            throw new RuntimeException(new StringBuilder(57).append("License file `").append(path).append("` does not contain the required grant '").append(grant).append("' (").append(esl).append(")").toString());
        }
        Option exp = Option$.MODULE$.apply(esl.getExpiry().orElse(null));
        exp.foreach((Function1 & java.io.Serializable & Serializable)expires -> {
            LicenseChecker$.$anonfun$validateGrant$1(path, esl, expires);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)esl.getUser(), (Object)exp);
    }

    public static final /* synthetic */ void $anonfun$verifyEntitlements$1(File licensePath$1, Function1 error$1, String grant) {
        try {
            Tuple2<String, Option<ZonedDateTime>> tuple2 = MODULE$.validateGrant(licensePath$1, grant);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String user = (String)tuple2._1();
            Option exp = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)exp);
            Tuple2 tuple23 = tuple22;
            String user2 = (String)tuple23._1();
            Option exp2 = (Option)tuple23._2();
            String when = (String)exp2.map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "never");
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("scala-fortify ").append(BuildInfo$.MODULE$.version()).append(", licensed to ").append(user2).append(" (expires: ").append(when).append(")").toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                error$1.apply((Object)"License validation failed:");
                throw ex;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$validateGrant$1(File path$1, EnterpriseSuiteLicense esl$1, ZonedDateTime expires) {
        if (expires.isBefore(ZonedDateTime.now())) {
            throw new RuntimeException(new StringBuilder(30).append("License file `").append(path$1).append("` expired at ").append(expires).append(" (").append(esl$1).append(")").toString());
        }
    }

    private LicenseChecker$() {
        MODULE$ = this;
    }
}

