/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STDereference;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STFieldDecl;
import com.fortify.frontend.nst.nodes.STLocation;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STType;
import com.fortify.frontend.nst.nodes.Visitor;

public class STFieldAccess
extends STLocation {
    private String field;
    private STExpression instance;
    private STType instanceType = new STType.STAnyType();

    public STFieldAccess(SourceInfo sourceInfo, STExpression sTExpression, STFieldDecl sTFieldDecl, STType sTType) {
        this(sourceInfo, sTExpression, sTFieldDecl.getName(), sTType);
    }

    public STFieldAccess(SourceInfo sourceInfo, STExpression sTExpression, String string, STType sTType) {
        super(sourceInfo);
        this.setField(string);
        if (sTExpression != null) {
            this.setInstance(sTExpression);
        }
        this.setInstanceType(sTType);
    }

    public STFieldAccess(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public STFieldAccess() {
    }

    @Override
    public FList<STNode> getChildren() {
        return this.filterNullChildren(this.instance, this.instanceType);
    }

    public void setInstance(STExpression sTExpression) {
        sTExpression.setParent(this);
        if (sTExpression instanceof STLocation && !(sTExpression instanceof STDereference)) {
            sTExpression = new STDereference(sTExpression.getSourceInfo(), (STLocation)sTExpression);
        }
        this.instance = sTExpression;
    }

    public void setField(String string) {
        this.field = string;
    }

    public void setInstanceType(STType sTType) {
        sTType.setParent(this);
        this.instanceType = sTType;
    }

    public STType getInstanceType() {
        return this.instanceType;
    }

    public STExpression getInstance() {
        return this.instance;
    }

    public String getField() {
        return this.field;
    }

    public String getName() {
        return this.field;
    }

    public void setName(String string) {
        this.setField(string);
    }

    public String toString() {
        return this.instance + "." + this.field;
    }

    @Override
    public STFieldAccess clone() {
        return this.clone(new STFieldAccess(this.getSourceInfo()));
    }

    @Override
    public STFieldAccess clone(STNode sTNode) {
        STFieldAccess sTFieldAccess = (STFieldAccess)sTNode;
        super.clone(sTFieldAccess);
        if (this.instance != null) {
            sTFieldAccess.setInstance(this.instance.clone());
        }
        sTFieldAccess.setField(this.field);
        sTFieldAccess.setInstanceType(this.instanceType.clone());
        return sTFieldAccess;
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }
}

