/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFMap;
import com.ergy.fset.BinaryOp;
import com.ergy.fset.FHashSet;
import com.ergy.fset.FLinkedHashMap;
import com.ergy.fset.FMap;
import com.ergy.fset.FSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class FHashMap<Key, Val>
extends AbstractFMap<Key, Val>
implements Comparable<FHashMap<Key, Val>>,
Serializable {
    private static BinaryOp second = new BinaryOp(){

        public Object apply(Object object, Object object2) {
            return object2;
        }
    };
    private static final FHashMap<?, ?> EMPTY_INSTANCE = new FHashMap();
    final transient Object tree;
    private final Val dflt;
    private transient int hash_code = Integer.MIN_VALUE;
    private static final int MAX_LEAF_ARRAY_LENGTH = 16;
    private static final int BALANCE_FACTOR = 4;
    private static final int NEGATIVE_INFINITY = Integer.MIN_VALUE;
    private static final int POSITIVE_INFINITY = Integer.MAX_VALUE;
    static final Object NO_ELEMENT = new Object();
    private static final int BIN_SEARCH_NOT_FOUND = 0;
    private static final int BIN_SEARCH_FOUND = 1;
    private static final int BIN_SEARCH_FOUND_MASK = 1;
    private static final int BIN_SEARCH_INDEX_SHIFT = 1;
    private static Field TreeField;

    public static <Key, Val> FHashMap<Key, Val> emptyMap() {
        return EMPTY_INSTANCE;
    }

    public FHashMap() {
        this.tree = null;
        this.dflt = null;
    }

    public FHashMap(Map<? extends Key, ? extends Val> map) {
        this.tree = FHashMap.fromMap(map);
        this.dflt = null;
    }

    private static <Key, Val> Object fromMap(Map<? extends Key, ? extends Val> map) {
        if (map instanceof FHashMap) {
            return ((FHashMap)map).tree;
        }
        Object object = null;
        for (Map.Entry<Key, Val> entry : map.entrySet()) {
            Key Key = entry.getKey();
            object = FHashMap.with(object, Key, FHashMap.hashCode(Key), entry.getValue());
        }
        return object;
    }

    public FHashMap(Key[] KeyArray, Val[] ValArray) {
        if (KeyArray.length != ValArray.length) {
            throw new IllegalArgumentException();
        }
        Object object = null;
        this.dflt = null;
        if (KeyArray.length != ValArray.length) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        for (int i = 0; i < KeyArray.length; ++i) {
            object = FHashMap.with(object, KeyArray[i], FHashMap.hashCode(KeyArray[i]), ValArray[i]);
        }
        this.tree = object;
    }

    public static <Key, Val> FHashMap<Key, Val> withDefault(Val Val) {
        return new FHashMap<Key, Val>(null, Val);
    }

    public static <Key, Val> FHashMap<Key, Val> withDefault(Map<? extends Key, ? extends Val> map, Val Val) {
        return new FHashMap<Key, Val>(FHashMap.fromMap(map), Val);
    }

    @Override
    public boolean isEmpty() {
        return this.tree == null;
    }

    @Override
    public int size() {
        return FHashMap.treeSize(this.tree);
    }

    @Override
    public Map.Entry<Key, Val> arb() {
        return (Map.Entry)FHashMap.arb(this.tree);
    }

    @Override
    public boolean contains(Map.Entry<Key, Val> entry) {
        return FHashMap.contains(this.tree, entry);
    }

    @Override
    public boolean containsKey(Object object) {
        return FHashMap.get(this.tree, object, FHashMap.hashCode(object)) != NO_ELEMENT;
    }

    @Override
    public Val get(Object object) {
        Object object2 = FHashMap.get(this.tree, object, FHashMap.hashCode(object));
        if (object2 == NO_ELEMENT) {
            return this.dflt;
        }
        return (Val)object2;
    }

    @Override
    public FHashMap<Key, Val> with(Key Key, Val Val) {
        Object object = FHashMap.with(this.tree, Key, FHashMap.hashCode(Key), Val);
        if (object == this.tree) {
            return this;
        }
        return new FHashMap<Key, Val>(object, this.dflt);
    }

    @Override
    public FHashMap<Key, Val> less(Key Key) {
        Object object = FHashMap.less(this.tree, Key, FHashMap.hashCode(Key));
        if (object == this.tree) {
            return this;
        }
        if (object == null && this.dflt == null) {
            return FHashMap.emptyMap();
        }
        return new FHashMap<Key, Val>(object, this.dflt);
    }

    @Override
    public Set<Key> keySet() {
        return new AbstractSet<Key>(){

            @Override
            public Iterator<Key> iterator() {
                return new FHMKeyIterator(FHashMap.this.tree);
            }

            @Override
            public int size() {
                return FHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return FHashMap.this.containsKey(object);
            }
        };
    }

    @Override
    public Collection<Val> values() {
        return new AbstractCollection<Val>(){

            @Override
            public Iterator<Val> iterator() {
                return new FHMValueIterator(FHashMap.this.tree);
            }

            @Override
            public int size() {
                return FHashMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Key, Val>> entrySet() {
        return new AbstractSet<Map.Entry<Key, Val>>(){

            @Override
            public Iterator<Map.Entry<Key, Val>> iterator() {
                return FHashMap.this.iterator();
            }

            @Override
            public int size() {
                return FHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return FHashMap.this.contains(entry);
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public FHashSet<Key> domain() {
        Object object = FHashMap.domain(this.tree);
        return FHashSet.make(object);
    }

    @Override
    public FSet<Val> range() {
        return FHashMap.range(this.tree, new FHashSet());
    }

    @Override
    public FSet<Val> range(FSet<Val> fSet) {
        fSet = fSet.difference(fSet);
        return FHashMap.range(this.tree, fSet);
    }

    @Override
    public FHashSet<Map.Entry<Key, Val>> toSet() {
        return (FHashSet)this.toSet(new FHashSet<Map.Entry<Key, Val>>());
    }

    @Override
    public FSet<Map.Entry<Key, Val>> toSet(FSet<Map.Entry<Key, Val>> fSet) {
        FSet<Map.Entry<Key, Val>> fSet2 = fSet.difference(fSet);
        for (Map.Entry<Key, Val> entry : this) {
            fSet2 = fSet2.with(entry);
        }
        return fSet2;
    }

    @Override
    public FHashMap<Key, Val> union(FMap<? extends Key, ? extends Val> fMap) {
        return this.union((FMap)fMap, second);
    }

    @Override
    public FHashMap<Key, Val> union(FMap<? extends Key, ? extends Val> fMap, BinaryOp<Val> binaryOp) {
        FHashMap<? extends Key, ? extends Val> fHashMap = new FHashMap<Key, Val>(fMap);
        Object object = FHashMap.union(this.tree, fHashMap.tree, binaryOp);
        return new FHashMap<Key, Val>(object, this.dflt);
    }

    @Override
    public FHashMap<Key, Val> restrictedTo(FSet<Key> fSet) {
        FHashSet<Key> fHashSet = new FHashSet<Key>(fSet);
        Object object = FHashMap.restrictedTo(this.tree, fHashSet.tree);
        return new FHashMap<Key, Val>(object, this.dflt);
    }

    @Override
    public FHashMap<Key, Val> restrictedFrom(FSet<Key> fSet) {
        FHashSet<Key> fHashSet = new FHashSet<Key>(fSet);
        Object object = FHashMap.restrictedFrom(this.tree, fHashSet.tree);
        return new FHashMap<Key, Val>(object, this.dflt);
    }

    @Override
    public Val getDefault() {
        return this.dflt;
    }

    @Override
    public Iterator<Map.Entry<Key, Val>> iterator() {
        return new FHMIterator(this.tree);
    }

    @Override
    public int compareTo(FHashMap<Key, Val> fHashMap) {
        return FHashMap.compareTo(this.tree, fHashMap.tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FHashMap) {
            FHashMap fHashMap = (FHashMap)object;
            return FHashMap.equals(this.tree, fHashMap.tree);
        }
        if (object instanceof FLinkedHashMap) {
            FLinkedHashMap fLinkedHashMap = (FLinkedHashMap)object;
            return FHashMap.equals(this.tree, fLinkedHashMap.map_tree);
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = FHashMap.myHashCode(this.tree);
        }
        return this.hash_code;
    }

    String dump() {
        return FHashMap.dump(this.tree);
    }

    boolean verify() {
        return this.verify(this.tree, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n = object.hashCode();
        if (n == Integer.MIN_VALUE) {
            return -2147483647;
        }
        if (n == Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        return n;
    }

    private static Node makeNode(Object object, Object object2, Object object3, Object object4) {
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            object2 = entry.value;
            object = entry.key;
        }
        return FHashMap.makeNode(object, FHashMap.hashCode(object), object2, object3, object4);
    }

    private static Node makeNode(Object object, int n, Object object2, Object object3, Object object4) {
        return new Node(FHashMap.treeSize(object3) + FHashMap.treeSize(object4) + FHashMap.keySize(object), object, n, object2, object3, object4);
    }

    static int treeSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            return ((Object[])object).length >> 1;
        }
        return ((Node)object).size;
    }

    private static int keySize(Object object) {
        if (object instanceof EquivalentMap) {
            return ((EquivalentMap)object).contents.size();
        }
        return 1;
    }

    private FHashMap(Object object, Val Val) {
        this.tree = object;
        this.dflt = Val;
    }

    static Object arb(Object object) {
        if (object == null) {
            throw new NoSuchElementException();
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = n >> 1;
            int n3 = n2 >> 1;
            return new Entry(objectArray[n3], objectArray[n3 + n2]);
        }
        Node node = (Node)object;
        if (node.key instanceof EquivalentMap) {
            return ((EquivalentMap)node.key).contents.get(0);
        }
        return node;
    }

    static <Key, Val> boolean contains(Object object, Map.Entry<Key, Val> entry) {
        Key Key = entry.getKey();
        Object object2 = FHashMap.get(object, Key, FHashMap.hashCode(Key));
        return object2 != NO_ELEMENT && FHashMap.eql(object2, entry.getValue());
    }

    static Object get(Object object, Object object2, int n) {
        if (object == null) {
            return NO_ELEMENT;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = FHashMap.binarySearch(objectArray, n);
            int n3 = n2 >> 1;
            if ((n2 & 1) == 1 && FHashMap.eql(object2, objectArray[n3])) {
                return objectArray[n3 + (objectArray.length >> 1)];
            }
            return NO_ELEMENT;
        }
        Node node = (Node)object;
        Object object3 = node.key;
        int n4 = node.khash;
        if (n == n4) {
            if (object3 instanceof EquivalentMap) {
                ArrayList arrayList = ((EquivalentMap)object3).contents;
                int n5 = arrayList.size();
                for (int i = 0; i < n5; ++i) {
                    Entry entry = (Entry)arrayList.get(i);
                    if (!FHashMap.eql(object2, entry.key)) continue;
                    return entry.value;
                }
                return NO_ELEMENT;
            }
            if (FHashMap.eql(object2, object3)) {
                return node.value;
            }
            return NO_ELEMENT;
        }
        if (n < n4) {
            return FHashMap.get(node.left, object2, n);
        }
        return FHashMap.get(node.right, object2, n);
    }

    static Object with(Object object, Object object2, int n, Object object3) {
        if (object == null) {
            if (!(object2 instanceof EquivalentMap)) {
                Object[] objectArray = new Object[]{object2, object3};
                return objectArray;
            }
            return FHashMap.makeNode(object2, n, object3, null, null);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            int n3 = n2 >> 1;
            int n4 = FHashMap.binarySearch(objectArray, n);
            int n5 = n4 & 1;
            int n6 = n4 >> 1;
            if (n5 == 1 && !(object2 instanceof EquivalentMap) && FHashMap.eql(object2, objectArray[n6])) {
                if (FHashMap.eql(object3, objectArray[n6 + n3])) {
                    return object;
                }
                return FHashMap.update2(objectArray, n6, object3);
            }
            if (n5 == 0 && n2 + 1 < 16 && !(object2 instanceof EquivalentMap)) {
                return FHashMap.insert2(objectArray, n6, object2, object3);
            }
            return FHashMap.makeNode(n5 == 1 ? FHashMap.equivUnion(objectArray[n6], objectArray[n6 + n3], object2, object3, second) : object2, n, object3, FHashMap.subseq2(objectArray, 0, n6), FHashMap.subseq2(objectArray, n5 == 1 ? n6 + 1 : n6, n3));
        }
        Node node = (Node)object;
        Object object4 = node.key;
        int n7 = node.khash;
        if (n == n7) {
            if (!(object2 instanceof EquivalentMap) && !(object4 instanceof EquivalentMap) && FHashMap.eql(object2, object4) && FHashMap.eql(object3, node.value)) {
                return object;
            }
            return FHashMap.makeNode(FHashMap.equivUnion(object4, node.value, object2, object3, second), object3, node.left, node.right);
        }
        if (n < n7) {
            Object object5 = FHashMap.with(node.left, object2, n, object3);
            if (object5 == node.left) {
                return object;
            }
            return FHashMap.buildNode(object4, n7, node.value, object5, node.right);
        }
        Object object6 = FHashMap.with(node.right, object2, n, object3);
        if (object6 == node.right) {
            return object;
        }
        return FHashMap.buildNode(object4, n7, node.value, node.left, object6);
    }

    static Object less(Object object, Object object2, int n) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = FHashMap.binarySearch(objectArray, n);
            int n3 = n2 & 1;
            int n4 = n2 >> 1;
            if (n3 == 1) {
                if (FHashMap.eql(object2, objectArray[n4])) {
                    return FHashMap.remove2(objectArray, n4);
                }
                return object;
            }
            return object;
        }
        Node node = (Node)object;
        Object object3 = node.key;
        int n5 = node.khash;
        if (n == n5) {
            if (!(object3 instanceof EquivalentMap)) {
                if (!FHashMap.eql(object2, object3)) {
                    return object;
                }
                return FHashMap.join(node.left, node.right);
            }
            return FHashMap.buildNode(FHashMap.equivLess(object3, object2), null, node.left, node.right);
        }
        if (n < n5) {
            Object object4 = FHashMap.less(node.left, object2, n);
            if (object4 == node.left) {
                return object;
            }
            return FHashMap.buildNode(object3, n5, node.value, object4, node.right);
        }
        Object object5 = FHashMap.less(node.right, object2, n);
        if (object5 == node.right) {
            return object;
        }
        return FHashMap.buildNode(object3, n5, node.value, node.left, object5);
    }

    static Object domain(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = objectArray[i];
            }
            return objectArray2;
        }
        Node node = (Node)object;
        Object object2 = FHashMap.domain(node.left);
        Object object3 = FHashMap.domain(node.right);
        if (node.key instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)node.key).contents;
            ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(((Entry)arrayList.get((int)i)).key);
            }
            return FHashSet.makeNode(new FHashSet.EquivalentSet(arrayList2), object2, object3);
        }
        return FHashSet.makeNode(node.key, object2, object3);
    }

    static <Val> FSet<Object> range(Object object, FSet<Val> fSet) {
        if (object == null) {
            return fSet;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            for (int i = 0; i < n; ++i) {
                fSet = fSet.with(objectArray[n + i]);
            }
            return fSet;
        }
        Node node = (Node)object;
        if (node.key instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)node.key).contents;
            for (int i = 0; i < arrayList.size(); ++i) {
                fSet = fSet.with(((Entry)arrayList.get((int)i)).value);
            }
            return fSet;
        }
        return FHashMap.range(node.left, fSet).with(node.value).union(FHashMap.range(node.right, fSet));
    }

    private static Object union(Object object, Object object2, BinaryOp binaryOp) {
        return FHashMap.union(object, object2, binaryOp, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Object union(Object object, Object object2, BinaryOp binaryOp, int n, int n2) {
        if (object == object2) {
            return object;
        }
        if (object == null) {
            return FHashMap.split(object2, n, n2);
        }
        if (object2 == null) {
            return FHashMap.split(object, n, n2);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (!(object2 instanceof Node)) {
                return FHashMap.union2(objectArray, (Object[])object2, binaryOp, n, n2);
            }
            Node node = (Node)object2;
            Object object3 = node.key;
            int n3 = node.khash;
            Object object4 = FHashMap.union(FHashMap.trim(object, n, n3), FHashMap.trim(node.left, n, n3), binaryOp, n, n3);
            Object object5 = FHashMap.union(FHashMap.trim(object, n3, n2), FHashMap.trim(node.right, n3, n2), binaryOp, n3, n2);
            Entry entry = FHashMap.findEquiv(object, n3);
            if (entry == null) {
                return FHashMap.concat(object3, n3, node.value, object4, object5);
            }
            Object object6 = FHashMap.equivUnion(entry.key, entry.value, object3, node.value, binaryOp);
            if (object6 instanceof EquivalentMap) {
                return FHashMap.concat(object6, n3, null, object4, object5);
            }
            Entry entry2 = (Entry)object6;
            return FHashMap.concat(entry2.key, n3, entry2.value, object4, object5);
        }
        Node node = (Node)object;
        Object object7 = node.key;
        int n4 = node.khash;
        Object object8 = FHashMap.union(FHashMap.trim(node.left, n, n4), FHashMap.trim(object2, n, n4), binaryOp, n, n4);
        Object object9 = FHashMap.union(FHashMap.trim(node.right, n4, n2), FHashMap.trim(object2, n4, n2), binaryOp, n4, n2);
        Entry entry = FHashMap.findEquiv(object2, n4);
        if (entry == null) {
            return FHashMap.concat(object7, n4, node.value, object8, object9);
        }
        Object object10 = FHashMap.equivUnion(object7, node.value, entry.key, entry.value, binaryOp);
        if (object10 instanceof EquivalentMap) {
            return FHashMap.concat(object10, n4, null, object8, object9);
        }
        Entry entry3 = (Entry)object10;
        return FHashMap.concat(entry3.key, n4, entry3.value, object8, object9);
    }

    private static Object restrictedTo(Object object, Object object2) {
        return FHashMap.restrictedTo(object, object2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Object restrictedTo(Object object, Object object2, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (!(object2 instanceof FHashSet.Node)) {
                return FHashMap.restrictedTo2(objectArray, (Object[])object2, n, n2);
            }
            FHashSet.Node node = (FHashSet.Node)object2;
            Object object3 = node.element;
            Object object4 = object3 instanceof FHashSet.EquivalentSet ? ((FHashSet.EquivalentSet)object3).contents.get(0) : object3;
            int n3 = FHashSet.hashCode(object4);
            Object object5 = FHashMap.restrictedTo(FHashMap.trim(object, n, n3), node.left, n, n3);
            Object object6 = FHashMap.restrictedTo(FHashMap.trim(object, n3, n2), node.right, n3, n2);
            Entry entry = FHashMap.findEquiv(object, n3);
            if (entry == null) {
                return FHashMap.join(object5, object6);
            }
            Object object7 = FHashMap.equivRestrictedTo(entry.key, entry.value, object3);
            if (object7 == null) {
                return FHashMap.join(object5, object6);
            }
            Entry entry2 = (Entry)object7;
            return FHashMap.concat(entry2.key, n3, entry2.value, object5, object6);
        }
        Node node = (Node)object;
        Object object8 = node.key;
        if (object8 instanceof EquivalentMap) {
            Object object9 = ((Entry)((EquivalentMap)((EquivalentMap)object8)).contents.get((int)0)).key;
        } else {
            Object object10 = object8;
        }
        int n4 = node.khash;
        Object object11 = FHashMap.restrictedTo(node.left, FHashSet.trim(object2, n, n4), n, n4);
        Object object12 = FHashMap.restrictedTo(node.right, FHashSet.trim(object2, n4, n2), n4, n2);
        Object object13 = FHashSet.findEquiv(object2, n4);
        if (object13 == FHashSet.NO_ELEMENT) {
            return FHashMap.join(object11, object12);
        }
        Object object14 = FHashMap.equivRestrictedTo(object8, node.value, object13);
        if (object14 == null) {
            return FHashMap.join(object11, object12);
        }
        if (object14 instanceof EquivalentMap) {
            return FHashMap.concat(object14, n4, null, object11, object12);
        }
        Entry entry = (Entry)object14;
        return FHashMap.concat(entry.key, n4, entry.value, object11, object12);
    }

    private static Object restrictedFrom(Object object, Object object2) {
        return FHashMap.restrictedFrom(object, object2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Object restrictedFrom(Object object, Object object2, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            return FHashMap.split(object, n, n2);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (!(object2 instanceof FHashSet.Node)) {
                return FHashMap.restrictedFrom2(objectArray, (Object[])object2, n, n2);
            }
            FHashSet.Node node = (FHashSet.Node)object2;
            Object object3 = node.element;
            Object object4 = object3 instanceof FHashSet.EquivalentSet ? ((FHashSet.EquivalentSet)object3).contents.get(0) : object3;
            int n3 = FHashSet.hashCode(object4);
            Object object5 = FHashMap.restrictedFrom(FHashMap.trim(object, n, n3), FHashSet.trim(node.left, n, n3), n, n3);
            Object object6 = FHashMap.restrictedFrom(FHashMap.trim(object, n3, n2), FHashSet.trim(node.right, n3, n2), n3, n2);
            Entry entry = FHashMap.findEquiv(object, n3);
            if (entry == null) {
                return FHashMap.join(object5, object6);
            }
            Object object7 = FHashMap.equivRestrictedFrom(entry.key, entry.value, object3);
            if (object7 == null) {
                return FHashMap.join(object5, object6);
            }
            Entry entry2 = (Entry)object7;
            return FHashMap.concat(entry2.key, n3, entry2.value, object5, object6);
        }
        Node node = (Node)object;
        Object object8 = node.key;
        if (object8 instanceof EquivalentMap) {
            Object object9 = ((Entry)((EquivalentMap)((EquivalentMap)object8)).contents.get((int)0)).key;
        } else {
            Object object10 = object8;
        }
        int n4 = node.khash;
        Object object11 = FHashMap.restrictedFrom(node.left, FHashSet.trim(object2, n, n4), n, n4);
        Object object12 = FHashMap.restrictedFrom(node.right, FHashSet.trim(object2, n4, n2), n4, n2);
        Object object13 = FHashSet.findEquiv(object2, n4);
        if (object13 == FHashSet.NO_ELEMENT) {
            return FHashMap.concat(object8, n4, node.value, object11, object12);
        }
        Object object14 = FHashMap.equivRestrictedFrom(object8, node.value, object13);
        if (object14 == null) {
            return FHashMap.join(object11, object12);
        }
        if (object14 instanceof EquivalentMap) {
            return FHashMap.concat(object14, n4, null, object11, object12);
        }
        Entry entry = (Entry)object14;
        return FHashMap.concat(entry.key, n4, entry.value, object11, object12);
    }

    static int compareTo(Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        int n2 = FHashMap.treeSize(object);
        if (n2 < (n = FHashMap.treeSize(object2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return FHashMap.compareTo(object, 0, object2, 0, 0, n2);
    }

    private static int compareTo(Object object, int n, Object object2, int n2, int n3, int n4) {
        int n5;
        if (object == object2 && n == n2 || n3 == n4) {
            return 0;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                int n6 = objectArray.length >> 1;
                int n7 = objectArray2.length >> 1;
                for (int i = n3; i < n4; ++i) {
                    int n8;
                    int n9 = FHashMap.hashCode(objectArray[i - n]);
                    if (n9 < (n8 = FHashMap.hashCode(objectArray2[i - n2]))) {
                        return -1;
                    }
                    if (n9 > n8) {
                        return 1;
                    }
                    Object object3 = objectArray[i - n + n6];
                    Object object4 = objectArray2[i - n2 + n7];
                    int n10 = ((Comparable)object3).compareTo((Comparable)object4);
                    if (n10 == 0) continue;
                    return n10;
                }
                return 0;
            }
            return -FHashMap.compareTo(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object5 = node.left;
        int n11 = FHashMap.treeSize(object5);
        int n12 = n + n11;
        RankTrimResult rankTrimResult = FHashMap.rankTrim(object5, n, n3, n12);
        RankTrimResult rankTrimResult2 = FHashMap.rankTrim(object2, n2, n3, n12);
        int n13 = FHashMap.compareTo(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n12);
        if (n13 != 0) {
            return n13;
        }
        Object object6 = node.key;
        Entry entry = FHashMap.rankEntry(object2, n12 - n2);
        int n14 = node.khash;
        if (n14 < (n5 = FHashMap.hashCode(entry.key))) {
            return -1;
        }
        if (n14 > n5) {
            return 1;
        }
        int n15 = FHashMap.equivCompare(object6, node.value, entry.key, entry.value);
        if (n15 != 0) {
            return n15;
        }
        int n16 = n + n11 + FHashMap.keySize(object6);
        RankTrimResult rankTrimResult3 = FHashMap.rankTrim(node.right, n16, n16, n4);
        RankTrimResult rankTrimResult4 = FHashMap.rankTrim(object2, n2, n16, n4);
        return FHashMap.compareTo(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n16, n4);
    }

    static boolean equals(Object object, Object object2) {
        int n;
        if (object == object2) {
            return true;
        }
        int n2 = FHashMap.treeSize(object);
        if (n2 != (n = FHashMap.treeSize(object2))) {
            return false;
        }
        return FHashMap.equals(object, 0, object2, 0, 0, n2);
    }

    private static boolean equals(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (object == object2 && n == n2 || n3 == n4) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    Object object3 = objectArray[i - n];
                    Object object4 = objectArray2[i - n2];
                    if (!FHashMap.eql(object3, object4)) {
                        return false;
                    }
                    int n5 = objectArray.length >> 1;
                    Object object5 = objectArray[i - n + n5];
                    int n6 = objectArray2.length >> 1;
                    Object object6 = objectArray2[i - n2 + n6];
                    if (FHashMap.eql(object5, object6)) continue;
                    return false;
                }
                return true;
            }
            return FHashMap.equals(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object7 = node.left;
        int n7 = FHashMap.treeSize(object7);
        int n8 = n + n7;
        RankTrimResult rankTrimResult = FHashMap.rankTrim(object7, n, n3, n8);
        RankTrimResult rankTrimResult2 = FHashMap.rankTrim(object2, n2, n3, n8);
        if (!FHashMap.equals(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n8)) {
            return false;
        }
        Object object8 = node.key;
        Object object9 = node.value;
        Entry entry = FHashMap.rankEntry(object2, n8 - n2);
        Object object10 = entry.value;
        if (!FHashMap.equivEquals(object8, entry.key)) {
            return false;
        }
        if (!(object8 instanceof EquivalentMap) && !FHashMap.eql(object9, object10)) {
            return false;
        }
        int n9 = FHashMap.keySize(object8);
        int n10 = n + n7 + n9;
        RankTrimResult rankTrimResult3 = FHashMap.rankTrim(node.right, n10, n10, n4);
        RankTrimResult rankTrimResult4 = FHashMap.rankTrim(object2, n2, n10, n4);
        return FHashMap.equals(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n10, n4);
    }

    private static RankTrimResult rankTrim(Object object, int n, int n2, int n3) {
        while (object != null && object instanceof Node) {
            Node node = (Node)object;
            int n4 = n + FHashMap.treeSize(node.left);
            if (n4 >= n2) {
                if (n4 < n3) break;
                object = node.left;
                continue;
            }
            int n5 = n4 + FHashMap.keySize(node.key);
            if (n5 > n2) break;
            object = node.right;
            n = n5;
        }
        return new RankTrimResult(object, n);
    }

    private static Entry rankEntry(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return new Entry(objectArray[n], objectArray[n + (objectArray.length >> 1)]);
        }
        Node node = (Node)object;
        int n2 = FHashMap.treeSize(node.left);
        if (n < n2) {
            return FHashMap.rankEntry(node.left, n);
        }
        int n3 = FHashMap.keySize(node.key);
        if (n < n2 + n3) {
            return node;
        }
        return FHashMap.rankEntry(node.right, n - (n2 + n3));
    }

    private static Entry findEquiv(Object object, int n) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = FHashMap.binarySearch(objectArray, n);
            int n3 = n2 & 1;
            int n4 = n2 >> 1;
            if (n3 == 1) {
                return new Entry(objectArray[n4], objectArray[n4 + (objectArray.length >> 1)]);
            }
            return null;
        }
        Node node = (Node)object;
        int n5 = node.khash;
        if (n == n5) {
            return node;
        }
        if (n < n5) {
            return FHashMap.findEquiv(node.left, n);
        }
        return FHashMap.findEquiv(node.right, n);
    }

    private static Object split(Object object, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (n == Integer.MIN_VALUE && n2 == Integer.MAX_VALUE) {
            return object;
        }
        if (!(object instanceof Node)) {
            int n3;
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length >> 1;
            int n5 = n == Integer.MIN_VALUE ? 0 : FHashMap.binarySearchLo(objectArray, n);
            int n6 = n3 = n2 == Integer.MAX_VALUE ? n4 : FHashMap.binarySearchHi(objectArray, n2);
            if (n5 >= n3) {
                return null;
            }
            if (n5 == 0 && n3 == n4) {
                return object;
            }
            return FHashMap.subseq2(objectArray, n5, n3);
        }
        Node node = (Node)object;
        int n7 = node.khash;
        if (n != Integer.MIN_VALUE && n7 <= n) {
            if (n2 == Integer.MAX_VALUE && n7 == n) {
                return node.right;
            }
            return FHashMap.split(node.right, n, n2);
        }
        if (n2 != Integer.MAX_VALUE && n7 >= n2) {
            if (n == Integer.MIN_VALUE && n7 == n2) {
                return node.left;
            }
            return FHashMap.split(node.left, n, n2);
        }
        Object object2 = FHashMap.split(node.left, n, Integer.MAX_VALUE);
        Object object3 = FHashMap.split(node.right, Integer.MIN_VALUE, n2);
        if (object2 == node.left && object3 == node.right) {
            return object;
        }
        return FHashMap.concat(node.key, n7, node.value, object2, object3);
    }

    private static Object trim(Object object, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length >> 1;
            if (n != Integer.MIN_VALUE && FHashMap.hashCode(objectArray[n3 - 1]) <= n || n2 != Integer.MAX_VALUE && FHashMap.hashCode(objectArray[0]) >= n2) {
                return null;
            }
            return object;
        }
        Node node = (Node)object;
        int n4 = node.khash;
        if (n == Integer.MIN_VALUE || n4 > n) {
            if (n2 == Integer.MAX_VALUE || n4 < n2) {
                return object;
            }
            return FHashMap.trim(node.left, n, n2);
        }
        return FHashMap.trim(node.right, n, n2);
    }

    private static Object concat(Object object, int n, Object object2, Object object3, Object object4) {
        if (object3 == null) {
            return FHashMap.with(object4, object, n, object2);
        }
        if (object4 == null) {
            return FHashMap.with(object3, object, n, object2);
        }
        int n2 = FHashMap.treeSize(object3);
        int n3 = FHashMap.treeSize(object4);
        if (object3 instanceof Node && n2 > n3 * 4) {
            Node node = (Node)object3;
            return FHashMap.buildNode(node.key, node.khash, node.value, node.left, FHashMap.concat(object, n, object2, node.right, object4));
        }
        if (object4 instanceof Node && n3 > n2 * 4) {
            Node node = (Node)object4;
            return FHashMap.buildNode(node.key, node.khash, node.value, FHashMap.concat(object, n, object2, object3, node.left), node.right);
        }
        return FHashMap.buildNode(object, n, object2, object3, object4);
    }

    private static Object buildNode(Object object, Object object2, Object object3, Object object4) {
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            object2 = entry.value;
            object = entry.key;
        }
        return FHashMap.buildNode(object, FHashMap.hashCode(object), object2, object3, object4);
    }

    private static Object buildNode(Object object, int n, Object object2, Object object3, Object object4) {
        if (!(object3 != null && object3 instanceof Node || object4 != null && object4 instanceof Node)) {
            if (!(object instanceof EquivalentMap) && (object3 == null ? 0 : ((Object[])object3).length) + 1 + (object4 == null ? 0 : ((Object[])object4).length) < 16) {
                return FHashMap.makeArray2(object, object2, (Object[])object3, (Object[])object4);
            }
            return FHashMap.makeNode(object, n, object2, object3, object4);
        }
        int n2 = FHashMap.treeSize(object3);
        int n3 = FHashMap.treeSize(object4);
        if (object4 instanceof Node && n3 > n2 * 4) {
            Node node = (Node)object4;
            Object object5 = node.left;
            Object object6 = node.right;
            if (!(object5 instanceof Node) || FHashMap.treeSize(object5) <= FHashMap.treeSize(object6)) {
                return FHashMap.makeNode(node.key, node.khash, node.value, FHashMap.buildNode(object, n, object2, object3, object5), object6);
            }
            Node node2 = (Node)object5;
            return FHashMap.makeNode(node2.key, node2.khash, node2.value, FHashMap.buildNode(object, n, object2, object3, node2.left), FHashMap.buildNode(node.key, node.khash, node.value, node2.right, object6));
        }
        if (object3 instanceof Node && n2 > n3 * 4) {
            Node node = (Node)object3;
            Object object7 = node.left;
            Object object8 = node.right;
            if (!(object8 instanceof Node) || FHashMap.treeSize(object8) <= FHashMap.treeSize(object7)) {
                return FHashMap.makeNode(node.key, node.khash, node.value, object7, FHashMap.buildNode(object, n, object2, object8, object4));
            }
            Node node3 = (Node)object8;
            return FHashMap.makeNode(node3.key, node3.khash, node3.value, FHashMap.buildNode(node.key, node.khash, node.value, object7, node3.left), FHashMap.buildNode(object, n, object2, node3.right, object4));
        }
        return FHashMap.makeNode(object, n, object2, object3, object4);
    }

    private static Object join(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        Object object3 = FHashMap.min(object2);
        Object object4 = null;
        if (object3 instanceof Entry) {
            Entry entry = (Entry)object3;
            object3 = entry.key;
            object4 = entry.value;
        }
        return FHashMap.concat(object3, FHashMap.hashCode(object3), object4, object, FHashMap.lessMin(object2));
    }

    private static Object min(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return new Entry(objectArray[0], objectArray[objectArray.length >> 1]);
        }
        Node node = (Node)object;
        if (node.left == null) {
            if (node.key instanceof EquivalentMap) {
                return node.key;
            }
            return node;
        }
        return FHashMap.min(node.left);
    }

    private static Object lessMin(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return FHashMap.subseq2(objectArray, 1, objectArray.length >> 1);
        }
        Node node = (Node)object;
        if (node.left == null) {
            return node.right;
        }
        return FHashMap.concat(node.key, node.khash, node.value, FHashMap.lessMin(node.left), node.right);
    }

    static int myHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                Object object3 = objectArray[i + n];
                int n3 = (object2 == null ? 0 : object2.hashCode()) ^ (object3 == null ? 0 : object3.hashCode());
                n2 += n3;
            }
            return n2;
        }
        Node node = (Node)object;
        int n = FHashMap.myHashCode(node.left) + FHashMap.myHashCode(node.right);
        Object object4 = node.key;
        if (object4 instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object4).contents;
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                n += ((Entry)arrayList.get(i)).hashCode();
            }
        } else {
            n += (object4 == null ? 0 : object4.hashCode()) ^ (node.value == null ? 0 : node.value.hashCode());
        }
        return n;
    }

    private static String dump(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object).contents;
            String string = "[";
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + FHashMap.dump(arrayList.get(i));
            }
            return string + "]";
        }
        if (object instanceof Object[]) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(FHashMap.dump(objectArray[i]));
                stringBuffer.append(" -> ");
                stringBuffer.append(FHashMap.dump(objectArray[i + n]));
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return "(" + node.size + ", " + FHashMap.dump(node.key) + (node.key instanceof EquivalentMap ? "" : " -> " + FHashMap.dump(node.value)) + " (" + node.khash + ");\n" + FHashMap.indent(FHashMap.dump(node.left), "  ") + ",\n" + FHashMap.indent(FHashMap.dump(node.right), "  ") + ")";
        }
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            return FHashMap.dump(entry.key) + " -> " + FHashMap.dump(entry.value);
        }
        return object.toString();
    }

    private static String indent(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\n' || i >= n - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private boolean verify(Object object, int n, int n2) {
        int n3;
        if (object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n4 = n;
            int n5 = objectArray.length >> 1;
            int n6 = n5;
            for (int i = 0; i < n6; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof EquivalentMap) {
                    return false;
                }
                int n7 = FHashMap.hashCode(object2);
                if (n4 != Integer.MIN_VALUE && n4 >= n7) {
                    return false;
                }
                n4 = n7;
            }
            return n2 == Integer.MAX_VALUE || n4 < n2;
        }
        Node node = (Node)object;
        int n8 = node.khash;
        if (n8 != FHashMap.hashCode(node.key)) {
            return false;
        }
        int n9 = FHashMap.treeSize(node.left);
        if (node.size != n9 + (n3 = FHashMap.treeSize(node.right)) + FHashMap.keySize(node.key)) {
            return false;
        }
        if (node.key instanceof Entry) {
            return false;
        }
        if (node.key instanceof EquivalentMap && ((EquivalentMap)node.key).contents.size() < 2) {
            return false;
        }
        if (n3 > 4 && n9 > n3 * 4 || n9 > 4 && n3 > n9 * 4) {
            return false;
        }
        return this.verify(node.left, n, n8) && this.verify(node.right, n8, n2);
    }

    private static Object equivUnion(Object object, Object object2, Object object3, Object object4, BinaryOp binaryOp) {
        if (object instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object).contents;
            if (object3 instanceof EquivalentMap) {
                ArrayList arrayList2 = ((EquivalentMap)object3).contents;
                ArrayList arrayList3 = (ArrayList)arrayList2.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = (Entry)arrayList.get(i);
                    boolean bl = false;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2 && !bl; ++j) {
                        Entry entry2 = (Entry)arrayList3.get(j);
                        if (!FHashMap.eql(entry2.key, entry.key)) continue;
                        arrayList3.set(j, new Entry(entry.key, binaryOp.apply(entry.value, entry2.value)));
                        bl = true;
                    }
                    if (bl) continue;
                    arrayList3.add(entry);
                }
                arrayList3.trimToSize();
                return new EquivalentMap(arrayList3);
            }
            ArrayList arrayList4 = (ArrayList)arrayList.clone();
            boolean bl = false;
            int n = arrayList4.size();
            for (int i = 0; i < n && !bl; ++i) {
                Entry entry = (Entry)arrayList4.get(i);
                if (!FHashMap.eql(object3, entry.key)) continue;
                arrayList4.set(i, new Entry(entry.key, binaryOp.apply(entry.value, object4)));
                bl = true;
            }
            if (!bl) {
                arrayList4.add(new Entry(object3, object4));
            }
            arrayList4.trimToSize();
            return new EquivalentMap(arrayList4);
        }
        if (object3 instanceof EquivalentMap) {
            ArrayList arrayList = (ArrayList)((EquivalentMap)object3).contents.clone();
            boolean bl = false;
            int n = arrayList.size();
            for (int i = 0; i < n && !bl; ++i) {
                Entry entry = (Entry)arrayList.get(i);
                if (!FHashMap.eql(object, entry.key)) continue;
                arrayList.set(i, new Entry(object, binaryOp.apply(object2, entry.value)));
                bl = true;
            }
            if (!bl) {
                arrayList.add(new Entry(object, object2));
            }
            arrayList.trimToSize();
            return new EquivalentMap(arrayList);
        }
        if (FHashMap.eql(object, object3)) {
            return new Entry(object, binaryOp.apply(object2, object4));
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>(2);
        arrayList.add(new Entry(object, object2));
        arrayList.add(new Entry(object3, object4));
        return new EquivalentMap(arrayList);
    }

    private static Object equivRestrictedTo(Object object, Object object2, Object object3) {
        if (object instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object).contents;
            if (object3 instanceof FHashSet.EquivalentSet) {
                ArrayList<Object> arrayList2 = ((FHashSet.EquivalentSet)object3).contents;
                ArrayList<Entry> arrayList3 = new ArrayList<Entry>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = (Entry)arrayList.get(i);
                    if (!arrayList2.contains(entry.key)) continue;
                    arrayList3.add(entry);
                }
                if (arrayList3.size() == 0) {
                    return null;
                }
                if (arrayList3.size() == 1) {
                    return arrayList3.get(0);
                }
                arrayList3.trimToSize();
                return new EquivalentMap(arrayList3);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Entry entry = (Entry)arrayList.get(i);
                if (!FHashMap.eql(object3, entry.key)) continue;
                return entry;
            }
            return null;
        }
        if (object3 instanceof FHashSet.EquivalentSet) {
            ArrayList<Object> arrayList = ((FHashSet.EquivalentSet)object3).contents;
            if (arrayList.contains(object)) {
                return new Entry(object, object2);
            }
            return null;
        }
        if (FHashMap.eql(object, object3)) {
            return new Entry(object, object2);
        }
        return null;
    }

    private static Object equivRestrictedFrom(Object object, Object object2, Object object3) {
        if (object instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object).contents;
            ArrayList<Entry> arrayList2 = new ArrayList<Entry>();
            if (object3 instanceof FHashSet.EquivalentSet) {
                ArrayList<Object> arrayList3 = ((FHashSet.EquivalentSet)object3).contents;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = (Entry)arrayList.get(i);
                    if (arrayList3.contains(entry.key)) continue;
                    arrayList2.add(entry);
                }
            } else {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = (Entry)arrayList.get(i);
                    if (FHashMap.eql(object3, entry.key)) continue;
                    arrayList2.add(entry);
                }
            }
            if (arrayList2.size() == 0) {
                return null;
            }
            if (arrayList2.size() == 1) {
                return arrayList2.get(0);
            }
            arrayList2.trimToSize();
            return new EquivalentMap(arrayList2);
        }
        if (object3 instanceof FHashSet.EquivalentSet) {
            ArrayList<Object> arrayList = ((FHashSet.EquivalentSet)object3).contents;
            if (!arrayList.contains(object)) {
                return new Entry(object, object2);
            }
            return null;
        }
        if (!FHashMap.eql(object, object3)) {
            return new Entry(object, object2);
        }
        return null;
    }

    private static Object equivLess(Object object, Object object2) {
        ArrayList arrayList = ((EquivalentMap)object).contents;
        int n = -1;
        int n2 = arrayList.size();
        for (int i = 0; i < n2 && n < 0; ++i) {
            Entry entry = (Entry)arrayList.get(i);
            if (!FHashMap.eql(object2, entry.key)) continue;
            n = i;
        }
        if (n >= 0) {
            arrayList = (ArrayList)arrayList.clone();
            arrayList.remove(n);
            if (arrayList.size() == 1) {
                return arrayList.get(0);
            }
            return new EquivalentMap(arrayList);
        }
        return object;
    }

    private static int equivCompare(Object object, Object object2, Object object3, Object object4) {
        if (object instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object).contents;
            if (object3 instanceof EquivalentMap) {
                int n;
                int n2;
                ArrayList arrayList2 = ((EquivalentMap)object3).contents;
                int n3 = arrayList.size();
                if (n3 < (n2 = arrayList2.size())) {
                    return 1;
                }
                if (n3 > n2) {
                    return -1;
                }
                FSet fSet = new FHashSet();
                FSet fSet2 = new FHashSet();
                for (n = 0; n < n3; ++n) {
                    fSet = fSet.with(((Entry)arrayList.get((int)n)).value);
                }
                for (n = 0; n < n2; ++n) {
                    fSet2 = fSet2.with(((Entry)arrayList2.get((int)n)).value);
                }
                return fSet.compareTo(fSet2);
            }
            return -1;
        }
        if (object3 instanceof EquivalentMap) {
            return 1;
        }
        return ((Comparable)object2).compareTo((Comparable)object4);
    }

    private static boolean equivEquals(Object object, Object object2) {
        if (object instanceof EquivalentMap) {
            ArrayList arrayList = ((EquivalentMap)object).contents;
            if (object2 instanceof EquivalentMap) {
                int n;
                ArrayList arrayList2 = ((EquivalentMap)object2).contents;
                int n2 = arrayList.size();
                if (n2 != (n = arrayList2.size())) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    boolean bl = false;
                    Entry entry = (Entry)arrayList.get(i);
                    for (int j = 0; j < n && !bl; ++j) {
                        Entry entry2 = (Entry)arrayList2.get(j);
                        if (!FHashMap.eql(entry.key, entry2.key) || !FHashMap.eql(entry.value, entry2.value)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (object2 instanceof EquivalentMap) {
            return false;
        }
        return FHashMap.eql(object, object2);
    }

    private static Object[] makeArray2(Object object, Object object2, Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length >> 1;
        int n3 = objectArray2 == null ? 0 : objectArray2.length >> 1;
        int n4 = n2 + 1 + n3;
        Object[] objectArray3 = new Object[n4 << 1];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
            objectArray3[n + n4] = objectArray[n + n2];
        }
        objectArray3[n2] = object;
        objectArray3[n2 + n4] = object2;
        for (n = 0; n < n3; ++n) {
            objectArray3[n + n2 + 1] = objectArray2[n];
            objectArray3[n + n2 + 1 + n4] = objectArray2[n + n3];
        }
        return objectArray3;
    }

    private static Object[] insert2(Object[] objectArray, int n, Object object, Object object2) {
        int n2;
        int n3 = objectArray.length >> 1;
        Object[] objectArray2 = new Object[objectArray.length + 2];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
            objectArray2[n2 + n3 + 1] = objectArray[n2 + n3];
        }
        objectArray2[n] = object;
        objectArray2[n + n3 + 1] = object2;
        for (n2 = n; n2 < n3; ++n2) {
            objectArray2[n2 + 1] = objectArray[n2];
            objectArray2[n2 + n3 + 2] = objectArray[n2 + n3];
        }
        return objectArray2;
    }

    private static Object[] remove2(Object[] objectArray, int n) {
        int n2;
        int n3 = objectArray.length >> 1;
        if (n3 == 1) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length - 2];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
            objectArray2[n2 + n3 - 1] = objectArray[n2 + n3];
        }
        for (n2 = n + 1; n2 < n3; ++n2) {
            objectArray2[n2 - 1] = objectArray[n2];
            objectArray2[n2 + n3 - 2] = objectArray[n2 + n3];
        }
        return objectArray2;
    }

    private static Object[] subseq2(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return null;
        }
        int n3 = objectArray.length >> 1;
        int n4 = n2 - n;
        Object[] objectArray2 = new Object[n4 << 1];
        for (int i = 0; i < n4; ++i) {
            objectArray2[i] = objectArray[i + n];
            objectArray2[i + n4] = objectArray[i + n + n3];
        }
        return objectArray2;
    }

    private static Object[] update2(Object[] objectArray, int n, Object object) {
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray2[i] = objectArray[i];
        }
        objectArray2[n + (n2 >> 1)] = object;
        return objectArray2;
    }

    private static Object union2(Object[] objectArray, Object[] objectArray2, BinaryOp binaryOp, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length >> 1;
        int n6 = objectArray2.length >> 1;
        int n7 = n5;
        int n8 = n6;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n7 && n >= FHashMap.hashCode(objectArray[n3]); ++n3) {
            }
            while (n4 < n8 && n >= FHashMap.hashCode(objectArray2[n4])) {
                ++n4;
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n7 && n2 <= FHashMap.hashCode(objectArray[n7 - 1])) {
                --n7;
            }
            while (n4 < n8 && n2 <= FHashMap.hashCode(objectArray2[n8 - 1])) {
                --n8;
            }
        }
        int n9 = n7 - n3 + (n8 - n4);
        ArrayList<Object> arrayList = new ArrayList<Object>(n9);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n9);
        boolean bl = false;
        Object object = null;
        Object object2 = null;
        int n10 = 0;
        int n11 = 0;
        if (n3 < n7) {
            object = objectArray[n3];
            n10 = FHashMap.hashCode(object);
        }
        if (n4 < n8) {
            object2 = objectArray2[n4];
            n11 = FHashMap.hashCode(object2);
        }
        while (true) {
            if (n3 == n7) {
                while (n4 < n8) {
                    arrayList.add(objectArray2[n4]);
                    arrayList2.add(objectArray2[n4 + n6]);
                    ++n4;
                }
                break;
            }
            if (n4 == n8) {
                while (n3 < n7) {
                    arrayList.add(objectArray[n3]);
                    arrayList2.add(objectArray[n3 + n5]);
                    ++n3;
                }
                break;
            }
            if (n10 < n11) {
                arrayList.add(object);
                arrayList2.add(objectArray[n3 + n5]);
                if (++n3 >= n7) continue;
                object = objectArray[n3];
                n10 = FHashMap.hashCode(object);
                continue;
            }
            if (n10 > n11) {
                arrayList.add(object2);
                arrayList2.add(objectArray2[n4 + n6]);
                if (++n4 >= n8) continue;
                object2 = objectArray2[n4];
                n11 = FHashMap.hashCode(object2);
                continue;
            }
            if (FHashMap.eql(object, object2)) {
                arrayList.add(object);
                arrayList2.add(binaryOp.apply(objectArray[n3 + n5], objectArray2[n4 + n6]));
            } else {
                arrayList.add(FHashMap.equivUnion(object, objectArray[n3 + n5], object2, objectArray2[n4 + n6], binaryOp));
                arrayList2.add(null);
                bl = true;
            }
            ++n4;
            if (++n3 < n7) {
                object = objectArray[n3];
                n10 = FHashMap.hashCode(object);
            }
            if (n4 >= n8) continue;
            object2 = objectArray2[n4];
            n11 = FHashMap.hashCode(object2);
        }
        if (bl) {
            Object object3 = null;
            Iterator iterator = arrayList.iterator();
            Iterator iterator2 = arrayList2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                object3 = FHashMap.with(object3, e, FHashMap.hashCode(e), iterator2.next());
            }
            return object3;
        }
        int n12 = arrayList.size();
        arrayList.addAll(arrayList2);
        Object[] objectArray3 = arrayList.toArray();
        if (objectArray3.length > 16) {
            int n13 = n12 >> 1;
            return FHashMap.makeNode(arrayList.get(n13), arrayList2.get(n13), FHashMap.subseq2(objectArray3, 0, n13), FHashMap.subseq2(objectArray3, n13 + 1, n12));
        }
        return objectArray3;
    }

    private static Object[] restrictedTo2(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length >> 1;
        int n6 = objectArray2.length;
        int n7 = n5;
        int n8 = n6;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n7 && n >= FHashMap.hashCode(objectArray[n3]); ++n3) {
            }
            while (n4 < n8 && n >= FHashMap.hashCode(objectArray2[n4])) {
                ++n4;
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n7 && n2 <= FHashMap.hashCode(objectArray[n7 - 1])) {
                --n7;
            }
            while (n4 < n8 && n2 <= FHashMap.hashCode(objectArray2[n8 - 1])) {
                --n8;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n7 - n3);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n7 - n3);
        Object object = null;
        Object object2 = null;
        int n9 = 0;
        int n10 = 0;
        if (n3 < n7) {
            object = objectArray[n3];
            n9 = FHashMap.hashCode(object);
        }
        if (n4 < n8) {
            object2 = objectArray2[n4];
            n10 = FHashMap.hashCode(object2);
        }
        while (n3 < n7 && n4 < n8) {
            if (n9 < n10) {
                if (++n3 >= n7) continue;
                object = objectArray[n3];
                n9 = FHashMap.hashCode(object);
                continue;
            }
            if (n9 > n10) {
                if (++n4 >= n8) continue;
                object2 = objectArray2[n4];
                n10 = FHashMap.hashCode(object2);
                continue;
            }
            if (FHashMap.eql(object, object2)) {
                arrayList.add(object);
                arrayList2.add(objectArray[n3 + n5]);
            }
            ++n4;
            if (++n3 < n7) {
                object = objectArray[n3];
                n9 = FHashMap.hashCode(object);
            }
            if (n4 >= n8) continue;
            object2 = objectArray2[n4];
            n10 = FHashMap.hashCode(object2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.addAll(arrayList2);
        return arrayList.toArray();
    }

    private static Object[] restrictedFrom2(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length >> 1;
        int n6 = objectArray2.length;
        int n7 = n5;
        int n8 = n6;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n7 && n >= FHashMap.hashCode(objectArray[n3]); ++n3) {
            }
            while (n4 < n8 && n >= FHashMap.hashCode(objectArray2[n4])) {
                ++n4;
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n7 && n2 <= FHashMap.hashCode(objectArray[n7 - 1])) {
                --n7;
            }
            while (n4 < n8 && n2 <= FHashMap.hashCode(objectArray2[n8 - 1])) {
                --n8;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n7 - n3);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n7 - n3);
        Object object = null;
        Object object2 = null;
        int n9 = 0;
        int n10 = 0;
        if (n3 < n7) {
            object = objectArray[n3];
            n9 = FHashMap.hashCode(object);
        }
        if (n4 < n8) {
            object2 = objectArray2[n4];
            n10 = FHashMap.hashCode(object2);
        }
        while (n3 < n7 && n4 < n8) {
            if (n9 < n10) {
                arrayList.add(object);
                arrayList2.add(objectArray[n3 + n5]);
                if (++n3 >= n7) continue;
                object = objectArray[n3];
                n9 = FHashMap.hashCode(object);
                continue;
            }
            if (n9 > n10) {
                if (++n4 >= n8) continue;
                object2 = objectArray2[n4];
                n10 = FHashMap.hashCode(object2);
                continue;
            }
            if (!FHashMap.eql(object, object2)) {
                arrayList.add(object);
                arrayList2.add(objectArray[n3 + n5]);
            }
            ++n4;
            if (++n3 < n7) {
                object = objectArray[n3];
                n9 = FHashMap.hashCode(object);
            }
            if (n4 >= n8) continue;
            object2 = objectArray2[n4];
            n10 = FHashMap.hashCode(object2);
        }
        while (n3 < n7) {
            arrayList.add(objectArray[n3]);
            arrayList2.add(objectArray[n3 + n5]);
            ++n3;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.addAll(arrayList2);
        return arrayList.toArray();
    }

    private static int binarySearch(Object[] objectArray, int n) {
        int n2 = objectArray.length >> 1;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Object object = objectArray[n5];
            int n6 = FHashMap.hashCode(object);
            if (n == n6) {
                return n5 << 1 | 1;
            }
            if (n < n6) {
                n4 = n5 - 1;
                continue;
            }
            n3 = n5 + 1;
        }
        return n3 << 1 | 0;
    }

    private static int binarySearchLo(Object[] objectArray, int n) {
        int n2 = FHashMap.binarySearch(objectArray, n);
        int n3 = n2 >> 1;
        if ((n2 & 1) == 1) {
            return n3 + 1;
        }
        return n3;
    }

    private static int binarySearchHi(Object[] objectArray, int n) {
        int n2 = FHashMap.binarySearch(objectArray, n);
        return n2 >> 1;
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Map.Entry<Key, Val> entry : this) {
            Entry entry2 = (Entry)entry;
            objectOutputStream.writeObject(entry2.key);
            objectOutputStream.writeObject(entry2.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object object = null;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            object = FHashMap.with(object, object2, FHashMap.hashCode(object2), object3);
        }
        try {
            TreeField.set(this, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FHashMap deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            TreeField = FHashMap.class.getDeclaredField("tree");
            TreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }

    private static class FHMValueIterator<Val>
    implements Iterator<Val> {
        private FHMIterator<Object, Val> fhmIter;

        FHMValueIterator(Object object) {
            this.fhmIter = new FHMIterator(object);
        }

        @Override
        public boolean hasNext() {
            return this.fhmIter.hasNext();
        }

        @Override
        public Val next() {
            return (Val)this.fhmIter.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FHMKeyIterator<Key>
    implements Iterator<Key> {
        private FHMIterator<Key, Object> fhmIter;

        FHMKeyIterator(Object object) {
            this.fhmIter = new FHMIterator(object);
        }

        @Override
        public boolean hasNext() {
            return this.fhmIter.hasNext();
        }

        @Override
        public Key next() {
            Object object;
            if (((FHMIterator)this.fhmIter).inode == null) {
                throw new NoSuchElementException();
            }
            if (!(((FHMIterator)this.fhmIter).inode.subtree instanceof Node)) {
                Object[] objectArray = (Object[])((FHMIterator)this.fhmIter).inode.subtree;
                object = objectArray[((FHMIterator)this.fhmIter).inode.index];
            } else {
                Node node = (Node)((FHMIterator)this.fhmIter).inode.subtree;
                if (node.key instanceof EquivalentMap) {
                    ArrayList arrayList = ((EquivalentMap)node.key).contents;
                    object = ((Entry)arrayList.get((int)(((FHMIterator.IteratorNode)((FHMIterator)this.fhmIter).inode).index - 1))).key;
                } else {
                    object = node.key;
                }
            }
            ((FHMIterator)this.fhmIter).inode.index++;
            ((FHMIterator)this.fhmIter).canonicalize();
            return (Key)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class FHMIterator<Key, Val>
    implements Iterator<Map.Entry<Key, Val>> {
        private IteratorNode inode;

        FHMIterator(Object object) {
            this.inode = new IteratorNode(object, 0, null);
            this.canonicalize();
        }

        private void canonicalize() {
            while (this.inode != null) {
                if (this.inode.subtree == null) {
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                if (!(this.inode.subtree instanceof Node)) {
                    if (this.inode.index < ((Object[])this.inode.subtree).length >> 1) break;
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                Node node = (Node)this.inode.subtree;
                if (this.inode.index == 0) {
                    this.inode = new IteratorNode(node.left, 0, this.inode);
                    continue;
                }
                if (this.inode.index != FHashMap.keySize(node.key) + 1) break;
                this.inode = new IteratorNode(node.right, 0, this.inode.parent);
            }
        }

        @Override
        public boolean hasNext() {
            return this.inode != null;
        }

        @Override
        public Map.Entry<Key, Val> next() {
            Entry entry;
            if (this.inode == null) {
                throw new NoSuchElementException();
            }
            if (!(this.inode.subtree instanceof Node)) {
                Object[] objectArray = (Object[])this.inode.subtree;
                entry = new Entry(objectArray[this.inode.index], objectArray[this.inode.index + (objectArray.length >> 1)]);
            } else {
                Node node = (Node)this.inode.subtree;
                if (node.key instanceof EquivalentMap) {
                    ArrayList arrayList = ((EquivalentMap)node.key).contents;
                    entry = arrayList.get(this.inode.index - 1);
                } else {
                    entry = node;
                }
            }
            this.inode.index++;
            this.canonicalize();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static final class IteratorNode {
            private final Object subtree;
            private int index;
            private final IteratorNode parent;

            IteratorNode(Object object, int n, IteratorNode iteratorNode) {
                this.subtree = object;
                this.index = n;
                this.parent = iteratorNode;
            }
        }
    }

    private static final class EquivalentMap {
        private ArrayList<Entry> contents;

        private EquivalentMap(ArrayList<Entry> arrayList) {
            this.contents = arrayList;
        }

        public int hashCode() {
            Object object = this.contents.get((int)0).key;
            return object == null ? 0 : object.hashCode();
        }
    }

    private static final class RankTrimResult {
        Object subtree;
        int base;

        RankTrimResult(Object object, int n) {
            this.subtree = object;
            this.base = n;
        }
    }

    static final class Node
    extends Entry {
        private final int khash;
        final int size;
        final Object left;
        final Object right;

        Node(int n, Object object, int n2, Object object2, Object object3, Object object4) {
            super(object, object2);
            this.size = n;
            this.khash = n2;
            this.left = object3;
            this.right = object4;
        }
    }

    static class Entry
    implements Map.Entry<Object, Object> {
        final Object key;
        final Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return FHashMap.eql(this.key, entry.getKey()) && FHashMap.eql(this.value, entry.getValue());
        }
    }
}

