/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STBlock;
import com.fortify.frontend.nst.nodes.STCatch;
import com.fortify.frontend.nst.nodes.STFinally;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STStatement;
import com.fortify.frontend.nst.nodes.Visitor;

public class STTry
extends STStatement {
    private STBlock code;
    private FList<STCatch> catches = new FTreeList<STCatch>();
    private STFinally finallyNode = null;

    @Override
    public FList<STNode> getChildren() {
        return this.filterNullChildren(this.code, this.finallyNode).concat(this.catches);
    }

    public void setCatches(FList<STCatch> fList) {
        for (STCatch sTCatch : fList) {
            sTCatch.setParent(this);
        }
        this.catches = this.catches;
    }

    public void setFinally(STFinally sTFinally) {
        if (sTFinally != null) {
            sTFinally.setParent(this);
        }
        this.finallyNode = sTFinally;
    }

    public STTry() {
        this.code = new STBlock();
        this.code.setParent(this);
    }

    public STTry(SourceInfo sourceInfo) {
        super(sourceInfo);
        this.code = new STBlock(sourceInfo);
        this.code.setParent(this);
    }

    public FList<STCatch> getCatches() {
        return this.catches;
    }

    public STFinally getFinally() {
        return this.finallyNode;
    }

    public String toString() {
        return "try " + this.code.toString();
    }

    public STBlock getBody() {
        return this.code;
    }

    public void setBody(STBlock sTBlock) {
        sTBlock.setParent(this);
        this.code = sTBlock;
    }

    @Override
    public STTry clone() {
        return this.clone(new STTry(this.getSourceInfo()));
    }

    @Override
    protected STTry clone(STNode sTNode) {
        STTry sTTry = (STTry)sTNode;
        super.clone(sTTry);
        sTTry.setBody(this.code.clone());
        for (STCatch sTCatch : this.getCatches()) {
            sTTry.addCatch(sTCatch.clone());
        }
        if (this.finallyNode != null) {
            sTTry.setFinally(this.finallyNode.clone());
        }
        return sTTry;
    }

    public void addCatch(STCatch sTCatch) {
        sTCatch.setParent(this);
        this.catches = this.catches.withLast(sTCatch);
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }
}

