/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STClassDecl;
import com.fortify.frontend.nst.nodes.STExternalDeclarations;
import com.fortify.frontend.nst.nodes.STFunDecl;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STVarDecl;
import com.fortify.frontend.nst.nodes.Visitor;
import java.io.File;

public class STCompilationUnit
extends STNode {
    private File sourceFile;
    private String sourceLanguage;
    private String identifier;
    private FList<STFunDecl> functions = new FTreeList<STFunDecl>();
    private FList<STClassDecl> classes = new FTreeList<STClassDecl>();
    private FList<STVarDecl> vars = new FTreeList<STVarDecl>();
    private STExternalDeclarations externalDeclarations;

    @Override
    public FList<STNode> getChildren() {
        FList<STNode> fList = FTreeList.emptyList().concat(this.functions);
        fList = fList.concat(this.classes);
        fList = fList.concat(this.vars);
        fList = fList.withLast((STClassDecl)((Object)this.externalDeclarations));
        return fList;
    }

    public void setVars(FList<STVarDecl> fList) {
        this.vars = fList;
    }

    public FList<STVarDecl> getVars() {
        return this.vars;
    }

    public void setClasses(FList<STClassDecl> fList) {
        this.classes = fList;
    }

    public void setFunctions(FList<STFunDecl> fList) {
        this.functions = fList;
    }

    public void removeFunction(STFunDecl sTFunDecl) {
        int n = this.functions.indexOf(sTFunDecl);
        if (n != -1) {
            this.functions = this.functions.less(n);
        }
    }

    public STExternalDeclarations getExternalDeclarations() {
        return this.externalDeclarations;
    }

    public void setExternalDeclarations(STExternalDeclarations sTExternalDeclarations) {
        sTExternalDeclarations.setParent(this);
        this.externalDeclarations = sTExternalDeclarations;
    }

    public STCompilationUnit(SourceInfo sourceInfo, String string, File file) {
        super(sourceInfo);
        this.sourceFile = file;
        this.sourceLanguage = string;
    }

    public void add(STFunDecl sTFunDecl) {
        sTFunDecl.setParent(this);
        this.functions = this.functions.withLast(sTFunDecl);
    }

    public FList<STFunDecl> getFunctions() {
        return this.functions;
    }

    public void add(STVarDecl sTVarDecl) {
        sTVarDecl.setParent(this);
        this.vars = this.vars.withLast(sTVarDecl);
    }

    public void add(STClassDecl sTClassDecl) {
        sTClassDecl.setParent(this);
        this.classes = this.classes.withLast(sTClassDecl);
    }

    public void remove(STClassDecl sTClassDecl) {
        int n = this.classes.indexOf(sTClassDecl);
        if (n >= 0) {
            this.classes = this.classes.less(n);
        }
    }

    public FList<STClassDecl> getClasses() {
        return this.classes;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public STCompilationUnit clone() {
        return this.clone(new STCompilationUnit(this.getSourceInfo(), this.sourceLanguage, this.sourceFile));
    }

    @Override
    protected STCompilationUnit clone(STNode sTNode) {
        STCompilationUnit sTCompilationUnit = (STCompilationUnit)sTNode;
        super.clone(sTCompilationUnit);
        for (STFunDecl sTNode2 : this.functions) {
            sTCompilationUnit.add(sTNode2.clone());
        }
        for (STClassDecl sTClassDecl : this.classes) {
            sTCompilationUnit.add(sTClassDecl.clone());
        }
        for (STVarDecl sTVarDecl : this.vars) {
            sTCompilationUnit.add(sTVarDecl.clone());
        }
        return sTCompilationUnit;
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }
}

