/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FLinkedHashMap;
import com.ergy.fset.FList;
import com.ergy.fset.FMap;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.NSTModifierSet;
import com.fortify.frontend.nst.NSTModifiers;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STFieldDecl;
import com.fortify.frontend.nst.nodes.STFunDecl;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STType;
import com.fortify.frontend.nst.nodes.Visitor;
import java.util.List;

public class STClassDecl
extends STNode {
    private String uniqueName = null;
    private String simpleName = null;
    private String namespace = null;
    private NSTModifierSet modifiers = NSTModifierSet.Empty;
    private FList<STFunDecl> funDecls = new FTreeList<STFunDecl>();
    private FMap<String, STFieldDecl> fieldDecls = new FLinkedHashMap<String, STFieldDecl>();
    private FList<STType> extendsList = new FTreeList<STType>();

    @Override
    public FList<STNode> getChildren() {
        FList<Object> fList = FTreeList.emptyList();
        fList = fList.concat(this.funDecls);
        fList = fList.concat(new FTreeList(this.fieldDecls.values()));
        fList = fList.concat(this.extendsList);
        return fList;
    }

    public void setExtendsList(FList<STType> fList) {
        this.extendsList = fList;
    }

    public FList<STType> getExtendsList() {
        return this.extendsList;
    }

    public STClassDecl(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public String toString() {
        return this.uniqueName;
    }

    public FList<STFunDecl> getFunDecls() {
        return this.funDecls;
    }

    public void setFunDecls(FList<STFunDecl> fList) {
        this.funDecls = fList;
    }

    public STFunDecl getFunction(String string) {
        for (STFunDecl sTFunDecl : this.funDecls) {
            if (!string.equals(sTFunDecl.getSimpleName())) continue;
            return sTFunDecl;
        }
        return null;
    }

    public void addFunction(STFunDecl sTFunDecl) {
        sTFunDecl.setParent(this);
        this.funDecls = this.funDecls.withLast(sTFunDecl);
    }

    public STFieldDecl getField(String string) {
        return (STFieldDecl)this.fieldDecls.get(string);
    }

    public FList<STFieldDecl> getFieldDecls() {
        return new FTreeList<STFieldDecl>(this.fieldDecls.values());
    }

    public void setFieldDecls(FList<STFieldDecl> fList) {
        this.fieldDecls = new FLinkedHashMap<String, STFieldDecl>();
        for (STFieldDecl sTFieldDecl : fList) {
            this.addField(sTFieldDecl);
        }
    }

    public NSTModifierSet getModifiers() {
        return this.modifiers;
    }

    public void addModifiers(NSTModifiers ... nSTModifiersArray) {
        this.modifiers = this.modifiers.add(nSTModifiersArray);
    }

    public void setModifiers(NSTModifierSet nSTModifierSet) {
        this.modifiers = nSTModifierSet;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public void setSimpleName(String string) {
        this.simpleName = string;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.uniqueName;
    }

    public void setName(String string) {
        this.uniqueName = string;
        if (this.simpleName == null) {
            this.simpleName = string;
        }
    }

    public FList<STFunDecl> getDecls() {
        return this.funDecls;
    }

    @Override
    public STClassDecl clone() {
        return this.clone(new STClassDecl(this.getSourceInfo()));
    }

    @Override
    protected STClassDecl clone(STNode sTNode) {
        STClassDecl sTClassDecl = (STClassDecl)sTNode;
        super.clone(sTClassDecl);
        for (STFunDecl sTNode2 : this.funDecls) {
            sTClassDecl.addFunDecl(sTNode2.clone());
        }
        for (STFieldDecl sTFieldDecl : this.fieldDecls.values()) {
            sTClassDecl.addField(sTFieldDecl.clone());
        }
        for (STType sTType : this.extendsList) {
            sTClassDecl.addExtends(sTType.clone());
        }
        sTClassDecl.setModifiers(this.modifiers);
        sTClassDecl.setName(this.uniqueName);
        sTClassDecl.setSimpleName(this.simpleName);
        sTClassDecl.setNamespace(this.namespace);
        return sTClassDecl;
    }

    public void addFunDecl(STFunDecl sTFunDecl) {
        int n = -1;
        for (int i = 0; i < this.funDecls.size(); ++i) {
            if (!((STFunDecl)this.funDecls.get(i)).similarPrototype(sTFunDecl)) continue;
            n = i;
            break;
        }
        sTFunDecl.setParent(this);
        if (n == -1) {
            this.funDecls = this.funDecls.withLast(sTFunDecl);
            return;
        }
        FList<STFunDecl> fList = this.funDecls.subList(0, n).concat(this.funDecls.subList(n + 1, this.funDecls.size()));
        fList = fList.withLast(sTFunDecl);
        this.funDecls = fList;
    }

    public void addFunDecls(List<STFunDecl> list) {
        for (STFunDecl sTFunDecl : list) {
            this.addFunDecl(sTFunDecl);
        }
    }

    public void addField(STFieldDecl sTFieldDecl) {
        if (this.containsField(sTFieldDecl)) {
            return;
        }
        sTFieldDecl.setParent(this);
        this.fieldDecls = this.fieldDecls.with(sTFieldDecl.getName(), sTFieldDecl);
    }

    public void addExtends(STType sTType) {
        sTType.setParent(this);
        this.extendsList = this.extendsList.withLast(sTType);
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }

    public boolean containsFun(STFunDecl sTFunDecl) {
        for (STFunDecl sTFunDecl2 : this.funDecls) {
            if (!sTFunDecl.similarPrototype(sTFunDecl2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsFun(String string) {
        for (STFunDecl sTFunDecl : this.funDecls) {
            if (!sTFunDecl.getSimpleName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsField(STFieldDecl sTFieldDecl) {
        return this.fieldDecls.get(sTFieldDecl.getName()) != null;
    }
}

