/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFSet;
import com.ergy.fset.FLinkedHashSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FHashSet<Elt>
extends AbstractFSet<Elt>
implements Comparable<FHashSet<Elt>>,
Serializable {
    private static final FHashSet<?> EMPTY_INSTANCE = new FHashSet();
    final transient Object tree;
    private transient int hash_code = Integer.MIN_VALUE;
    private static final int MAX_LEAF_ARRAY_LENGTH = 8;
    private static final int BALANCE_FACTOR = 4;
    private static final int NEGATIVE_INFINITY = Integer.MIN_VALUE;
    private static final int POSITIVE_INFINITY = Integer.MAX_VALUE;
    static boolean debug = false;
    static final Object NO_ELEMENT = new Object();
    private static final int BIN_SEARCH_NOT_FOUND = 0;
    private static final int BIN_SEARCH_FOUND = 1;
    private static final int BIN_SEARCH_FOUND_MASK = 1;
    private static final int BIN_SEARCH_INDEX_SHIFT = 1;
    private static Field TreeField;

    public static <Elt> FHashSet<Elt> emptySet() {
        return EMPTY_INSTANCE;
    }

    public FHashSet() {
        this.tree = null;
    }

    public FHashSet(Elt Elt) {
        this.tree = FHashSet.with(null, Elt, 0);
    }

    public FHashSet(Collection<? extends Elt> collection) {
        if (collection instanceof FHashSet) {
            this.tree = ((FHashSet)collection).tree;
        } else {
            Object object = null;
            for (Elt Elt : collection) {
                object = FHashSet.with(object, Elt, FHashSet.hashCode(Elt));
            }
            this.tree = object;
        }
    }

    public <T extends Elt> FHashSet(T ... TArray) {
        Object object = null;
        for (T t : TArray) {
            object = FHashSet.with(object, t, FHashSet.hashCode(t));
        }
        this.tree = object;
    }

    @Override
    public boolean isEmpty() {
        return this.tree == null;
    }

    @Override
    public int size() {
        return FHashSet.treeSize(this.tree);
    }

    @Override
    public Elt arb() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        if (!(this.tree instanceof Node)) {
            Object[] objectArray = (Object[])this.tree;
            int n = objectArray.length;
            return (Elt)objectArray[n >> 1];
        }
        Node node = (Node)this.tree;
        if (node.element instanceof EquivalentSet) {
            return (Elt)((EquivalentSet)node.element).contents.get(0);
        }
        return (Elt)node.element;
    }

    @Override
    public boolean contains(Object object) {
        return FHashSet.contains(this.tree, object, FHashSet.hashCode(object));
    }

    @Override
    public Iterator<Elt> iterator() {
        return new FHSIterator(this.tree);
    }

    @Override
    public FHashSet<Elt> with(Elt Elt) {
        Object object = FHashSet.with(this.tree, Elt, FHashSet.hashCode(Elt));
        if (object == this.tree) {
            return this;
        }
        return FHashSet.make(object);
    }

    @Override
    public FHashSet<Elt> less(Elt Elt) {
        Object object = FHashSet.less(this.tree, Elt, FHashSet.hashCode(Elt));
        if (object == this.tree) {
            return this;
        }
        if (object == null) {
            return FHashSet.emptySet();
        }
        return FHashSet.make(object);
    }

    @Override
    public FHashSet<Elt> union(Collection<? extends Elt> collection) {
        if (collection == this || collection.isEmpty()) {
            return this;
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            if (this.isEmpty()) {
                return fHashSet;
            }
            Object object = FHashSet.union(this.tree, fHashSet.tree);
            return FHashSet.make(object);
        }
        FHashSet<? extends Elt> fHashSet = new FHashSet<Elt>(collection);
        Object object = FHashSet.union(this.tree, fHashSet.tree);
        return FHashSet.make(object);
    }

    @Override
    public FHashSet<Elt> intersection(Collection<? extends Elt> collection) {
        if (collection == this) {
            return this;
        }
        if (this.isEmpty() || collection.isEmpty()) {
            return EMPTY_INSTANCE;
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            if (fHashSet.tree == this.tree) {
                return fHashSet;
            }
            Object object = FHashSet.intersection(this.tree, fHashSet.tree);
            return FHashSet.make(object);
        }
        FHashSet<? extends Elt> fHashSet = new FHashSet<Elt>(collection);
        Object object = FHashSet.intersection(this.tree, fHashSet.tree);
        return FHashSet.make(object);
    }

    @Override
    public FHashSet<Elt> difference(Collection<? extends Elt> collection) {
        if (this.isEmpty() || collection == this) {
            return EMPTY_INSTANCE;
        }
        if (collection.isEmpty()) {
            return this;
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            if (fHashSet.tree == this.tree) {
                return new FHashSet<Elt>();
            }
            Object object = FHashSet.difference(this.tree, fHashSet.tree);
            return FHashSet.make(object);
        }
        FHashSet<? extends Elt> fHashSet = new FHashSet<Elt>(collection);
        Object object = FHashSet.difference(this.tree, fHashSet.tree);
        return FHashSet.make(object);
    }

    @Override
    public int compareTo(FHashSet<Elt> fHashSet) {
        return FHashSet.compareTo(this.tree, fHashSet.tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)object;
            return FHashSet.equals(this.tree, fHashSet.tree);
        }
        if (object instanceof FLinkedHashSet) {
            FLinkedHashSet fLinkedHashSet = (FLinkedHashSet)object;
            return FHashSet.equals(this.tree, fLinkedHashSet.set_tree);
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (this.size() != collection.size()) {
            return false;
        }
        for (Object e : collection) {
            if (FHashSet.contains(this.tree, e, FHashSet.hashCode(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubset(Collection<?> collection) {
        if (collection == this) {
            return true;
        }
        if (this.size() > collection.size()) {
            return false;
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            return FHashSet.isSubset(this.tree, fHashSet.tree);
        }
        if (collection instanceof FLinkedHashSet) {
            FLinkedHashSet fLinkedHashSet = (FLinkedHashSet)collection;
            return FHashSet.isSubset(this.tree, fLinkedHashSet.set_tree);
        }
        for (Elt Elt : this) {
            if (collection.contains(Elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuperset(Collection<?> collection) {
        if (collection == this) {
            return true;
        }
        if (this.size() < collection.size()) {
            return false;
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            return FHashSet.isSubset(fHashSet.tree, this.tree);
        }
        if (collection instanceof FLinkedHashSet) {
            FLinkedHashSet fLinkedHashSet = (FLinkedHashSet)collection;
            return FHashSet.isSubset(fLinkedHashSet.set_tree, this.tree);
        }
        for (Object obj : collection) {
            if (FHashSet.contains(this.tree, obj, FHashSet.hashCode(obj))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = FHashSet.myHashCode(this.tree);
        }
        return this.hash_code;
    }

    String dump() {
        return FHashSet.dump(this.tree);
    }

    boolean verify() {
        return FHashSet.verify(this.tree, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private FHashSet(int n, Object object) {
        this.tree = object;
    }

    static <Elt> FHashSet<Elt> make(Object object) {
        if (object == null) {
            return EMPTY_INSTANCE;
        }
        return new FHashSet<Elt>(42, object);
    }

    static int hashCode(Object object) {
        if (object instanceof EquivalentSet) {
            object = ((EquivalentSet)object).contents.get(0);
        }
        if (object == null) {
            return 0;
        }
        int n = object.hashCode();
        if (n == Integer.MIN_VALUE) {
            return -2147483647;
        }
        if (n == Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        return n;
    }

    static Node makeNode(Object object, Object object2, Object object3) {
        return new Node(FHashSet.treeSize(object2) + FHashSet.treeSize(object3) + FHashSet.elementSize(object), object, object2, object3);
    }

    static int treeSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            return ((Object[])object).length;
        }
        return ((Node)object).size;
    }

    private static int elementSize(Object object) {
        if (object instanceof EquivalentSet) {
            return ((EquivalentSet)object).contents.size();
        }
        return 1;
    }

    static boolean contains(Object object, Object object2, int n) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = FHashSet.binarySearch(objectArray, n);
            if ((n2 & 1) == 1) {
                Object object3 = objectArray[n2 >> 1];
                return FHashSet.eql(object2, object3);
            }
            return false;
        }
        Node node = (Node)object;
        Object object4 = node.element;
        int n3 = FHashSet.hashCode(object4);
        if (n == n3) {
            if (object4 instanceof EquivalentSet) {
                return ((EquivalentSet)object4).contents.contains(object2);
            }
            return FHashSet.eql(object2, object4);
        }
        if (n < n3) {
            return FHashSet.contains(node.left, object2, n);
        }
        return FHashSet.contains(node.right, object2, n);
    }

    static Object with(Object object, Object object2, int n) {
        if (object == null) {
            if (!(object2 instanceof EquivalentSet)) {
                Object[] objectArray = new Object[]{object2};
                return objectArray;
            }
            return FHashSet.makeNode(object2, null, null);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = FHashSet.binarySearch(objectArray, n);
            int n3 = n2 & 1;
            int n4 = n2 >> 1;
            if (n3 == 1 && !(object2 instanceof EquivalentSet) && FHashSet.eql(object2, objectArray[n4])) {
                return object;
            }
            if (n3 == 0 && objectArray.length < 8 && !(object2 instanceof EquivalentSet)) {
                return FHashSet.insert(objectArray, n4, object2);
            }
            return FHashSet.makeNode(n3 == 1 ? FHashSet.equivUnion(objectArray[n4], object2) : object2, FHashSet.subseq(objectArray, 0, n4), FHashSet.subseq(objectArray, n3 == 1 ? n4 + 1 : n4, objectArray.length));
        }
        Node node = (Node)object;
        Object object3 = node.element;
        int n5 = FHashSet.hashCode(object3);
        if (n == n5) {
            if (!(object2 instanceof EquivalentSet) && !(object3 instanceof EquivalentSet) && FHashSet.eql(object2, object3)) {
                return object;
            }
            return FHashSet.makeNode(FHashSet.equivUnion(object2, object3), node.left, node.right);
        }
        if (n < n5) {
            Object object4 = FHashSet.with(node.left, object2, n);
            if (object4 == node.left) {
                return object;
            }
            return FHashSet.buildNode(object3, object4, node.right);
        }
        Object object5 = FHashSet.with(node.right, object2, n);
        if (object5 == node.right) {
            return object;
        }
        return FHashSet.buildNode(object3, node.left, object5);
    }

    static Object less(Object object, Object object2, int n) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n2 = FHashSet.binarySearch(objectArray, n);
            int n3 = n2 & 1;
            int n4 = n2 >> 1;
            if (n3 == 1) {
                Object object3 = objectArray[n4];
                if (FHashSet.eql(object2, object3)) {
                    return FHashSet.remove(objectArray, n4);
                }
                return object;
            }
            return object;
        }
        Node node = (Node)object;
        Object object4 = node.element;
        int n5 = FHashSet.hashCode(object4);
        if (n == n5) {
            if (!(object4 instanceof EquivalentSet)) {
                if (!FHashSet.eql(object2, object4)) {
                    return object;
                }
                return FHashSet.join(node.left, node.right);
            }
            Object object5 = FHashSet.equivDiff(object4, object2);
            return FHashSet.buildNode(object5, node.left, node.right);
        }
        if (n < n5) {
            Object object6 = FHashSet.less(node.left, object2, n);
            if (object6 == node.left) {
                return object;
            }
            return FHashSet.buildNode(object4, object6, node.right);
        }
        Object object7 = FHashSet.less(node.right, object2, n);
        if (object7 == node.right) {
            return object;
        }
        return FHashSet.buildNode(object4, node.left, object7);
    }

    private static Object union(Object object, Object object2) {
        return FHashSet.union(object, object2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Object union(Object object, Object object2, int n, int n2) {
        if (object == object2 || object2 == null) {
            return FHashSet.split(object, n, n2);
        }
        if (object == null) {
            return FHashSet.split(object2, n, n2);
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                return FHashSet.union((Object[])object, (Object[])object2, n, n2);
            }
            return FHashSet.union(object2, object, n, n2);
        }
        Node node = (Node)object;
        Object object3 = node.element;
        int n3 = FHashSet.hashCode(object3);
        Object object4 = FHashSet.findEquiv(object2, n3);
        return FHashSet.concat(FHashSet.equivUnion(object3, object4), n3, FHashSet.union(FHashSet.trim(node.left, n, n3), FHashSet.trim(object2, n, n3), n, n3), FHashSet.union(FHashSet.trim(node.right, n3, n2), FHashSet.trim(object2, n3, n2), n3, n2));
    }

    private static Object intersection(Object object, Object object2) {
        return FHashSet.intersection(object, object2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Object intersection(Object object, Object object2, int n, int n2) {
        if (object == object2) {
            return FHashSet.split(object, n, n2);
        }
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                return FHashSet.intersection((Object[])object, (Object[])object2, n, n2);
            }
            return FHashSet.intersection(FHashSet.trim(object2, n, n2), object, n, n2);
        }
        Node node = (Node)object;
        Object object3 = node.element;
        int n3 = FHashSet.hashCode(object3);
        Object object4 = FHashSet.findEquiv(object2, n3);
        Object object5 = FHashSet.intersection(node.left, FHashSet.trim(object2, n, n3), n, n3);
        Object object6 = FHashSet.intersection(node.right, FHashSet.trim(object2, n3, n2), n3, n2);
        Object object7 = FHashSet.equivIntersect(object3, object4);
        if (object7 == NO_ELEMENT) {
            return FHashSet.join(object5, object6);
        }
        return FHashSet.concat(object7, n3, object5, object6);
    }

    private static Object difference(Object object, Object object2) {
        return FHashSet.difference(object, object2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Object difference(Object object, Object object2, int n, int n2) {
        if (object == null || object == object2) {
            return null;
        }
        if (object2 == null) {
            return FHashSet.split(object, n, n2);
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                return FHashSet.difference((Object[])object, (Object[])object2, n, n2);
            }
            Node node = (Node)object2;
            Object object3 = node.element;
            int n3 = FHashSet.hashCode(object3);
            Object object4 = FHashSet.findEquiv(object, n3);
            Object object5 = FHashSet.difference(FHashSet.trim(object, n, n3), FHashSet.trim(node.left, n, n3), n, n3);
            Object object6 = FHashSet.difference(FHashSet.trim(object, n3, n2), FHashSet.trim(node.right, n3, n2), n3, n2);
            Object object7 = FHashSet.equivDiff(object4, object3);
            if (object7 == NO_ELEMENT) {
                return FHashSet.join(object5, object6);
            }
            return FHashSet.concat(object7, n3, object5, object6);
        }
        Node node = (Node)object;
        Object object8 = node.element;
        int n4 = FHashSet.hashCode(object8);
        Object object9 = FHashSet.findEquiv(object2, n4);
        Object object10 = FHashSet.difference(node.left, FHashSet.trim(object2, n, n4), n, n4);
        Object object11 = FHashSet.difference(node.right, FHashSet.trim(object2, n4, n2), n4, n2);
        Object object12 = FHashSet.equivDiff(object8, object9);
        if (object12 == NO_ELEMENT) {
            return FHashSet.join(object10, object11);
        }
        return FHashSet.concat(object12, n4, object10, object11);
    }

    static int compareTo(Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        int n2 = FHashSet.treeSize(object);
        if (n2 < (n = FHashSet.treeSize(object2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return FHashSet.compareTo(object, 0, object2, 0, 0, n2);
    }

    private static int compareTo(Object object, int n, Object object2, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (object == object2 && n == n2 || n3 == n4) {
            return 0;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    int n7;
                    int n8 = FHashSet.hashCode(objectArray[i - n]);
                    if (n8 < (n7 = FHashSet.hashCode(objectArray2[i - n2]))) {
                        return -1;
                    }
                    if (n8 <= n7) continue;
                    return 1;
                }
                return 0;
            }
            return -FHashSet.compareTo(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object3 = node.left;
        int n9 = FHashSet.treeSize(object3);
        int n10 = n + n9;
        RankTrimResult rankTrimResult = FHashSet.rankTrim(object3, n, n3, n10);
        RankTrimResult rankTrimResult2 = FHashSet.rankTrim(object2, n2, n3, n10);
        int n11 = FHashSet.compareTo(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n10);
        if (n11 != 0) {
            return n11;
        }
        Object object4 = node.element;
        Object object5 = FHashSet.rankElement(object2, n10 - n2);
        int n12 = FHashSet.hashCode(object4);
        if (n12 < (n6 = FHashSet.hashCode(object5))) {
            return -1;
        }
        if (n12 > n6) {
            return 1;
        }
        int n13 = FHashSet.elementSize(object4);
        if (n13 < (n5 = FHashSet.elementSize(object5))) {
            return 1;
        }
        if (n13 > n5) {
            return -1;
        }
        int n14 = n + n9 + n13;
        RankTrimResult rankTrimResult3 = FHashSet.rankTrim(node.right, n14, n14, n4);
        RankTrimResult rankTrimResult4 = FHashSet.rankTrim(object2, n2, n14, n4);
        return FHashSet.compareTo(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n14, n4);
    }

    static boolean equals(Object object, Object object2) {
        int n;
        if (object == object2) {
            return true;
        }
        int n2 = FHashSet.treeSize(object);
        if (n2 != (n = FHashSet.treeSize(object2))) {
            return false;
        }
        return FHashSet.equals(object, 0, object2, 0, 0, n2);
    }

    private static boolean equals(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (object == object2 && n == n2 || n3 == n4) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    Object object3 = objectArray[i - n];
                    Object object4 = objectArray2[i - n2];
                    if (!(object3 == null ? object4 != null : FHashSet.hashCode(object3) != FHashSet.hashCode(object4) || !object3.equals(object4))) continue;
                    return false;
                }
                return true;
            }
            return FHashSet.equals(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object5 = node.left;
        int n5 = FHashSet.treeSize(object5);
        int n6 = n + n5;
        RankTrimResult rankTrimResult = FHashSet.rankTrim(object5, n, n3, n6);
        RankTrimResult rankTrimResult2 = FHashSet.rankTrim(object2, n2, n3, n6);
        if (!FHashSet.equals(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n6)) {
            return false;
        }
        Object object6 = node.element;
        Object object7 = FHashSet.rankElement(object2, n6 - n2);
        if (object6 == null ? object7 != null : FHashSet.hashCode(object6) != FHashSet.hashCode(object7) || !FHashSet.equivEquals(object6, object7)) {
            return false;
        }
        int n7 = FHashSet.elementSize(object6);
        int n8 = n + n5 + n7;
        RankTrimResult rankTrimResult3 = FHashSet.rankTrim(node.right, n8, n8, n4);
        RankTrimResult rankTrimResult4 = FHashSet.rankTrim(object2, n2, n8, n4);
        return FHashSet.equals(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n8, n4);
    }

    private static RankTrimResult rankTrim(Object object, int n, int n2, int n3) {
        while (object != null && object instanceof Node) {
            Node node = (Node)object;
            int n4 = n + FHashSet.treeSize(node.left);
            if (n4 >= n2) {
                if (n4 < n3) break;
                object = node.left;
                continue;
            }
            int n5 = n4 + FHashSet.elementSize(node.element);
            if (n5 > n2) break;
            n = n5;
            object = node.right;
        }
        return new RankTrimResult(object, n);
    }

    private static Object rankElement(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Node)) {
            return ((Object[])object)[n];
        }
        Node node = (Node)object;
        int n2 = FHashSet.treeSize(node.left);
        if (n < n2) {
            return FHashSet.rankElement(node.left, n);
        }
        Object object2 = node.element;
        int n3 = FHashSet.elementSize(object2);
        if (n < n2 + n3) {
            return object2;
        }
        return FHashSet.rankElement(node.right, n - (n2 + n3));
    }

    static boolean isSubset(Object object, Object object2) {
        return FHashSet.isSubset(object, object2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static boolean isSubset(Object object, Object object2, int n, int n2) {
        if (object == object2 || object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (object2 == null || !(object2 instanceof Node)) {
                return FHashSet.isSubset((Object[])object, (Object[])object2, n, n2);
            }
            Node node = (Node)object2;
            Object object3 = node.element;
            int n3 = FHashSet.hashCode(object3);
            if (!FHashSet.isSubset(FHashSet.trim(object, n, n3), node.left, n, n3)) {
                return false;
            }
            Object object4 = FHashSet.findEquiv(object, n3);
            if (!FHashSet.equivIsSubset(object4, object3)) {
                return false;
            }
            return FHashSet.isSubset(FHashSet.trim(object, n3, n2), node.right, n3, n2);
        }
        if (object2 == null) {
            return false;
        }
        Node node = (Node)object;
        Object object5 = node.element;
        int n4 = FHashSet.hashCode(object5);
        if (!FHashSet.isSubset(node.left, FHashSet.trim(object2, n, n4), n, n4)) {
            return false;
        }
        Object object6 = FHashSet.findEquiv(object2, n4);
        if (!FHashSet.equivIsSubset(object5, object6)) {
            return false;
        }
        return FHashSet.isSubset(node.right, FHashSet.trim(object2, n4, n2), n4, n2);
    }

    static Object findEquiv(Object object, int n) {
        if (object == null) {
            return NO_ELEMENT;
        }
        if (!(object instanceof Node)) {
            int n2 = FHashSet.binarySearch((Object[])object, n);
            int n3 = n2 & 1;
            int n4 = n2 >> 1;
            if (n3 == 1) {
                return ((Object[])object)[n4];
            }
            return NO_ELEMENT;
        }
        Node node = (Node)object;
        Object object2 = node.element;
        int n5 = FHashSet.hashCode(object2);
        if (n == n5) {
            return object2;
        }
        if (n < n5) {
            return FHashSet.findEquiv(node.left, n);
        }
        return FHashSet.findEquiv(node.right, n);
    }

    private static Object split(Object object, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (n == Integer.MIN_VALUE && n2 == Integer.MAX_VALUE) {
            return object;
        }
        if (!(object instanceof Node)) {
            int n3;
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length;
            int n5 = n == Integer.MIN_VALUE ? 0 : FHashSet.binarySearchLo(objectArray, n);
            int n6 = n3 = n2 == Integer.MAX_VALUE ? n4 : FHashSet.binarySearchHi(objectArray, n2);
            if (n5 >= n3) {
                return null;
            }
            if (n5 == 0 && n3 == n4) {
                return object;
            }
            return FHashSet.subseq(objectArray, n5, n3);
        }
        Node node = (Node)object;
        int n7 = FHashSet.hashCode(node.element);
        if (n != Integer.MIN_VALUE && n7 <= n) {
            if (n2 == Integer.MAX_VALUE && n7 == n) {
                return node.right;
            }
            return FHashSet.split(node.right, n, n2);
        }
        if (n2 != Integer.MAX_VALUE && n7 >= n2) {
            if (n == Integer.MIN_VALUE && n7 == n2) {
                return node.left;
            }
            return FHashSet.split(node.left, n, n2);
        }
        Object object2 = FHashSet.split(node.left, n, Integer.MAX_VALUE);
        Object object3 = FHashSet.split(node.right, Integer.MIN_VALUE, n2);
        if (object2 == node.left && object3 == node.right) {
            return object;
        }
        return FHashSet.concat(node.element, n7, object2, object3);
    }

    static Object trim(Object object, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (n != Integer.MIN_VALUE && FHashSet.hashCode(objectArray[objectArray.length - 1]) <= n || n2 != Integer.MAX_VALUE && FHashSet.hashCode(objectArray[0]) >= n2) {
                return null;
            }
            return object;
        }
        Node node = (Node)object;
        int n3 = FHashSet.hashCode(node.element);
        if (n == Integer.MIN_VALUE || n3 > n) {
            if (n2 == Integer.MAX_VALUE || n3 < n2) {
                return object;
            }
            return FHashSet.trim(node.left, n, n2);
        }
        return FHashSet.trim(node.right, n, n2);
    }

    private static Object concat(Object object, int n, Object object2, Object object3) {
        if (object2 == null) {
            return FHashSet.with(object3, object, n);
        }
        if (object3 == null) {
            return FHashSet.with(object2, object, n);
        }
        int n2 = FHashSet.treeSize(object2);
        int n3 = FHashSet.treeSize(object3);
        if (object2 instanceof Node && n2 >= n3 * 4) {
            Node node = (Node)object2;
            return FHashSet.buildNode(node.element, node.left, FHashSet.concat(object, n, node.right, object3));
        }
        if (object3 instanceof Node && n3 >= n2 * 4) {
            Node node = (Node)object3;
            return FHashSet.buildNode(node.element, FHashSet.concat(object, n, object2, node.left), node.right);
        }
        return FHashSet.buildNode(object, object2, object3);
    }

    private static Object buildNode(Object object, Object object2, Object object3) {
        if (!(object2 != null && object2 instanceof Node || object3 != null && object3 instanceof Node)) {
            Object[] objectArray = (Object[])object2;
            Object[] objectArray2 = (Object[])object3;
            if (!(object instanceof EquivalentSet) && (object2 == null ? 0 : objectArray.length) + (object3 == null ? 0 : objectArray2.length) < 8) {
                return FHashSet.concat(object, objectArray, objectArray2);
            }
            return FHashSet.makeNode(object, object2, object3);
        }
        int n = FHashSet.treeSize(object2);
        int n2 = FHashSet.treeSize(object3);
        if (object3 instanceof Node && n2 > n * 4) {
            Node node = (Node)object3;
            Object object4 = node.left;
            Object object5 = node.right;
            if (!(object4 instanceof Node) || FHashSet.treeSize(object4) <= FHashSet.treeSize(object5)) {
                return FHashSet.makeNode(node.element, FHashSet.buildNode(object, object2, object4), object5);
            }
            Node node2 = (Node)object4;
            return FHashSet.makeNode(node2.element, FHashSet.buildNode(object, object2, node2.left), FHashSet.buildNode(node.element, node2.right, object5));
        }
        if (object2 instanceof Node && n > n2 * 4) {
            Node node = (Node)object2;
            Object object6 = node.left;
            Object object7 = node.right;
            if (!(object7 instanceof Node) || FHashSet.treeSize(object7) <= FHashSet.treeSize(object6)) {
                return FHashSet.makeNode(node.element, object6, FHashSet.buildNode(object, object7, object3));
            }
            Node node3 = (Node)object7;
            return FHashSet.makeNode(node3.element, FHashSet.buildNode(node.element, object6, node3.left), FHashSet.buildNode(object, node3.right, object3));
        }
        return FHashSet.makeNode(object, object2, object3);
    }

    private static Object join(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        Object object3 = FHashSet.min(object2);
        return FHashSet.concat(object3, FHashSet.hashCode(object3), object, FHashSet.lessMin(object2));
    }

    private static Object min(Object object) {
        if (!(object instanceof Node)) {
            return ((Object[])object)[0];
        }
        Node node = (Node)object;
        if (node.left == null) {
            return node.element;
        }
        return FHashSet.min(node.left);
    }

    static Object lessMin(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return FHashSet.subseq(objectArray, 1, objectArray.length);
        }
        Node node = (Node)object;
        if (node.left == null) {
            return node.right;
        }
        return FHashSet.concat(node.element, FHashSet.hashCode(node.element), FHashSet.lessMin(node.left), node.right);
    }

    static int myHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            for (Object object2 : objectArray) {
                if (object2 == null) continue;
                n += object2.hashCode();
            }
            return n;
        }
        Node node = (Node)object;
        int n = FHashSet.myHashCode(node.left) + FHashSet.myHashCode(node.right);
        Object object3 = node.element;
        if (object3 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object3).contents;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object object4 = arrayList.get(i);
                if (object4 == null) continue;
                n += object4.hashCode();
            }
        } else if (object3 != null) {
            n += object3.hashCode();
        }
        return n;
    }

    private static String dump(Object object) {
        if (object == null) {
            return "null";
        }
        if (object == NO_ELEMENT) {
            return "NADA";
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            String string = "[";
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + arrayList.get(i);
            }
            return string + "]";
        }
        if (object instanceof Object[]) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(FHashSet.dump(objectArray[i]));
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return "(" + node.size + ", " + FHashSet.dump(node.element) + ";\n" + FHashSet.indent(FHashSet.dump(node.left), "  ") + ",\n" + FHashSet.indent(FHashSet.dump(node.right), "  ") + ")";
        }
        return object.toString();
    }

    private static String indent(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\n' || i >= n - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static boolean verify(Object object, int n, int n2) {
        int n3;
        if (object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length > 8) {
                return false;
            }
            boolean bl = true;
            int n4 = n;
            for (Object object2 : objectArray) {
                int n5 = FHashSet.hashCode(object2);
                if (n4 != Integer.MIN_VALUE && n4 >= n5) {
                    bl = false;
                }
                n4 = n5;
            }
            if (n2 != Integer.MAX_VALUE && n4 >= n2) {
                bl = false;
            }
            return bl;
        }
        Node node = (Node)object;
        int n6 = FHashSet.hashCode(node.element);
        int n7 = FHashSet.treeSize(node.left);
        if (node.size != n7 + (n3 = FHashSet.treeSize(node.right)) + FHashSet.elementSize(node.element)) {
            return false;
        }
        if (node.element instanceof EquivalentSet && ((EquivalentSet)node.element).contents.size() < 2) {
            return false;
        }
        if (n3 > 4 && n7 > n3 * 4 || n7 > 4 && n3 > n7 * 4) {
            return false;
        }
        return FHashSet.verify(node.left, n, n6) && FHashSet.verify(node.right, n6, n2);
    }

    private static Object equivUnion(Object object, Object object2) {
        if (object == NO_ELEMENT) {
            return object2;
        }
        if (object2 == NO_ELEMENT) {
            return object;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                int n = arrayList2.size();
                ArrayList arrayList3 = (ArrayList)arrayList.clone();
                for (int i = 0; i < n; ++i) {
                    Object object3 = arrayList2.get(i);
                    if (arrayList3.contains(object3)) continue;
                    arrayList3.add(object3);
                }
                arrayList3.trimToSize();
                return new EquivalentSet(arrayList3);
            }
            if (arrayList.contains(object2)) {
                return object;
            }
            ArrayList arrayList4 = (ArrayList)arrayList.clone();
            arrayList4.add(object2);
            arrayList4.trimToSize();
            return new EquivalentSet(arrayList4);
        }
        if (object2 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object2).contents;
            if (arrayList.contains(object)) {
                return object2;
            }
            ArrayList arrayList5 = (ArrayList)arrayList.clone();
            arrayList5.add(object);
            arrayList5.trimToSize();
            return new EquivalentSet(arrayList5);
        }
        if (FHashSet.eql(object, object2)) {
            return object;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(object);
        arrayList.add(object2);
        return new EquivalentSet(arrayList);
    }

    private static Object equivIntersect(Object object, Object object2) {
        if (object == NO_ELEMENT || object2 == NO_ELEMENT) {
            return NO_ELEMENT;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Object object3 = arrayList.get(i);
                    if (!arrayList2.contains(object3)) continue;
                    arrayList3.add(object3);
                }
                if (arrayList3.size() == 0) {
                    return NO_ELEMENT;
                }
                if (arrayList3.size() == 1) {
                    return arrayList3.get(0);
                }
                arrayList3.trimToSize();
                return new EquivalentSet(arrayList3);
            }
            if (arrayList.contains(object2)) {
                return object2;
            }
            return NO_ELEMENT;
        }
        if (object2 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object2).contents;
            if (arrayList.contains(object)) {
                return object;
            }
            return NO_ELEMENT;
        }
        if (FHashSet.eql(object, object2)) {
            return object;
        }
        return NO_ELEMENT;
    }

    private static Object equivDiff(Object object, Object object2) {
        if (object == NO_ELEMENT) {
            return NO_ELEMENT;
        }
        if (object2 == NO_ELEMENT) {
            return object;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            ArrayList<Object> arrayList2 = null;
            if (object2 instanceof EquivalentSet) {
                arrayList2 = ((EquivalentSet)object2).contents;
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object object3 = arrayList.get(i);
                if (!(arrayList2 == null ? !FHashSet.eql(object3, object2) : !arrayList2.contains(object3))) continue;
                arrayList3.add(object3);
            }
            if (arrayList3.size() == 0) {
                return NO_ELEMENT;
            }
            if (arrayList3.size() == 1) {
                return arrayList3.get(0);
            }
            arrayList3.trimToSize();
            return new EquivalentSet(arrayList3);
        }
        if (object2 instanceof EquivalentSet) {
            if (!((EquivalentSet)object2).contents.contains(object)) {
                return object;
            }
            return NO_ELEMENT;
        }
        if (!FHashSet.eql(object, object2)) {
            return object;
        }
        return NO_ELEMENT;
    }

    private static boolean equivEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof EquivalentSet) {
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                int n = arrayList.size();
                if (n != arrayList2.size()) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (arrayList2.contains(arrayList.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (object2 instanceof EquivalentSet) {
            return false;
        }
        return object.equals(object2);
    }

    private static boolean equivIsSubset(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == NO_ELEMENT) {
            return true;
        }
        if (object2 == NO_ELEMENT) {
            return false;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                return arrayList2.containsAll(arrayList);
            }
            return false;
        }
        if (object2 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object2).contents;
            return arrayList.contains(object);
        }
        return object.equals(object2);
    }

    private static Object[] concat(Object object, Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = objectArray2 == null ? 0 : objectArray2.length;
        int n4 = n2 + 1 + n3;
        Object[] objectArray3 = new Object[n4];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
        }
        objectArray3[n2] = object;
        for (n = 0; n < n3; ++n) {
            objectArray3[n + n2 + 1] = objectArray2[n];
        }
        return objectArray3;
    }

    private static Object[] insert(Object[] objectArray, int n, Object object) {
        int n2;
        int n3 = objectArray.length + 1;
        Object[] objectArray2 = new Object[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        objectArray2[n] = object;
        for (n2 = n + 1; n2 < n3; ++n2) {
            objectArray2[n2] = objectArray[n2 - 1];
        }
        return objectArray2;
    }

    private static Object[] remove(Object[] objectArray, int n) {
        int n2;
        int n3 = objectArray.length - 1;
        if (n3 == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            objectArray2[n2] = objectArray[n2 + 1];
        }
        return objectArray2;
    }

    private static Object[] subseq(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return null;
        }
        if (n == 0 && n2 == objectArray.length) {
            return objectArray;
        }
        int n3 = n2 - n;
        Object[] objectArray2 = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray2[i] = objectArray[i + n];
        }
        return objectArray2;
    }

    private static Object union_save(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length;
        int n6 = objectArray2.length;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n5 && n >= FHashSet.hashCode(objectArray[n3]); ++n3) {
            }
            while (n4 < n6 && n >= FHashSet.hashCode(objectArray2[n4])) {
                ++n4;
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n5 && n2 <= FHashSet.hashCode(objectArray[n5 - 1])) {
                --n5;
            }
            while (n4 < n6 && n2 <= FHashSet.hashCode(objectArray2[n6 - 1])) {
                --n6;
            }
        }
        Object[] objectArray3 = new Object[n5 - n3 + (n6 - n4)];
        int n7 = 0;
        boolean bl = false;
        Object object = null;
        Object object2 = null;
        int n8 = 0;
        int n9 = 0;
        if (n3 < n5) {
            object = objectArray[n3];
            n8 = FHashSet.hashCode(object);
        }
        if (n4 < n6) {
            object2 = objectArray2[n4];
            n9 = FHashSet.hashCode(object2);
        }
        while (true) {
            if (n3 == n5) {
                while (n4 < n6) {
                    objectArray3[n7++] = objectArray2[n4++];
                }
                break;
            }
            if (n4 == n6) {
                while (n3 < n5) {
                    objectArray3[n7++] = objectArray[n3++];
                }
                break;
            }
            if (n8 < n9) {
                objectArray3[n7++] = object;
                if (++n3 >= n5) continue;
                object = objectArray[n3];
                n8 = FHashSet.hashCode(object);
                continue;
            }
            if (n8 > n9) {
                objectArray3[n7++] = object2;
                if (++n4 >= n6) continue;
                object2 = objectArray2[n4];
                n9 = FHashSet.hashCode(object2);
                continue;
            }
            if (FHashSet.eql(object, object2)) {
                objectArray3[n7++] = object;
            } else {
                objectArray3[n7++] = FHashSet.equivUnion(object, object2);
                bl = true;
            }
            ++n4;
            if (++n3 < n5) {
                object = objectArray[n3];
                n8 = FHashSet.hashCode(object);
            }
            if (n4 >= n6) continue;
            object2 = objectArray2[n4];
            n9 = FHashSet.hashCode(object2);
        }
        if (bl) {
            Object object3 = null;
            for (int i = 0; i < n7; ++i) {
                Object object4 = objectArray3[i];
                object3 = FHashSet.with(object3, object4, FHashSet.hashCode(object4));
            }
            return object3;
        }
        if (n7 > 8) {
            int n10 = n7 / 2;
            return FHashSet.makeNode(objectArray3[n10], FHashSet.subseq(objectArray3, 0, n10), FHashSet.subseq(objectArray3, n10 + 1, n7));
        }
        return FHashSet.subseq(objectArray3, 0, n7);
    }

    private static Object union(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length;
        int n6 = objectArray2.length;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n5 && n >= FHashSet.hashCode(objectArray[n3]); ++n3) {
            }
            while (n4 < n6 && n >= FHashSet.hashCode(objectArray2[n4])) {
                ++n4;
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n5 && n2 <= FHashSet.hashCode(objectArray[n5 - 1])) {
                --n5;
            }
            while (n4 < n6 && n2 <= FHashSet.hashCode(objectArray2[n6 - 1])) {
                --n6;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        Object object = null;
        Object object2 = null;
        int n7 = 0;
        int n8 = 0;
        if (n3 < n5) {
            object = objectArray[n3];
            n7 = FHashSet.hashCode(object);
        }
        if (n4 < n6) {
            object2 = objectArray2[n4];
            n8 = FHashSet.hashCode(object2);
        }
        while (true) {
            if (n3 == n5) {
                while (n4 < n6) {
                    arrayList.add(objectArray2[n4++]);
                }
                break;
            }
            if (n4 == n6) {
                while (n3 < n5) {
                    arrayList.add(objectArray[n3++]);
                }
                break;
            }
            if (n7 < n8) {
                arrayList.add(object);
                if (++n3 >= n5) continue;
                object = objectArray[n3];
                n7 = FHashSet.hashCode(object);
                continue;
            }
            if (n7 > n8) {
                arrayList.add(object2);
                if (++n4 >= n6) continue;
                object2 = objectArray2[n4];
                n8 = FHashSet.hashCode(object2);
                continue;
            }
            if (FHashSet.eql(object, object2)) {
                arrayList.add(object);
            } else {
                arrayList.add(FHashSet.equivUnion(object, object2));
                bl = true;
            }
            ++n4;
            if (++n3 < n5) {
                object = objectArray[n3];
                n7 = FHashSet.hashCode(object);
            }
            if (n4 >= n6) continue;
            object2 = objectArray2[n4];
            n8 = FHashSet.hashCode(object2);
        }
        if (bl) {
            Object object3 = null;
            for (Object e : arrayList) {
                object3 = FHashSet.with(object3, e, FHashSet.hashCode(e));
            }
            return object3;
        }
        int n9 = arrayList.size();
        Object[] objectArray3 = arrayList.toArray();
        if (n9 > 8) {
            int n10 = n9 / 2;
            return FHashSet.makeNode(arrayList.get(n10), FHashSet.subseq(objectArray3, 0, n10), FHashSet.subseq(objectArray3, n10 + 1, n9));
        }
        return objectArray3;
    }

    private static Object[] intersection(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length;
        int n6 = objectArray2.length;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n5 && n >= FHashSet.hashCode(objectArray[n3]); ++n3) {
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n5 && n2 <= FHashSet.hashCode(objectArray[n5 - 1])) {
                --n5;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Object object2 = null;
        int n7 = 0;
        int n8 = 0;
        if (n3 < n5) {
            object = objectArray[n3];
            n7 = FHashSet.hashCode(object);
        }
        if (n4 < n6) {
            object2 = objectArray2[n4];
            n8 = FHashSet.hashCode(object2);
        }
        while (n3 < n5 && n4 < n6) {
            if (n7 < n8) {
                if (++n3 >= n5) continue;
                object = objectArray[n3];
                n7 = FHashSet.hashCode(object);
                continue;
            }
            if (n7 > n8) {
                if (++n4 >= n6) continue;
                object2 = objectArray2[n4];
                n8 = FHashSet.hashCode(object2);
                continue;
            }
            if (FHashSet.eql(object, object2)) {
                arrayList.add(object);
            }
            ++n4;
            if (++n3 < n5) {
                object = objectArray[n3];
                n7 = FHashSet.hashCode(object);
            }
            if (n4 >= n6) continue;
            object2 = objectArray2[n4];
            n8 = FHashSet.hashCode(object2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray();
    }

    private static Object[] difference(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = objectArray.length;
        int n6 = objectArray2.length;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n5 && n >= FHashSet.hashCode(objectArray[n3]); ++n3) {
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n5 && n2 <= FHashSet.hashCode(objectArray[n5 - 1])) {
                --n5;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Object object2 = null;
        int n7 = 0;
        int n8 = 0;
        if (n3 < n5) {
            object = objectArray[n3];
            n7 = FHashSet.hashCode(object);
        }
        if (n4 < n6) {
            object2 = objectArray2[n4];
            n8 = FHashSet.hashCode(object2);
        }
        while (n3 < n5 && n4 < n6) {
            if (n7 < n8) {
                arrayList.add(object);
                if (++n3 >= n5) continue;
                object = objectArray[n3];
                n7 = FHashSet.hashCode(object);
                continue;
            }
            if (n7 > n8) {
                if (++n4 >= n6) continue;
                object2 = objectArray2[n4];
                n8 = FHashSet.hashCode(object2);
                continue;
            }
            if (!FHashSet.eql(object, object2)) {
                arrayList.add(object);
            }
            ++n4;
            if (++n3 < n5) {
                object = objectArray[n3];
                n7 = FHashSet.hashCode(object);
            }
            if (n4 >= n6) continue;
            object2 = objectArray2[n4];
            n8 = FHashSet.hashCode(object2);
        }
        while (n3 < n5) {
            arrayList.add(objectArray[n3++]);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray();
    }

    private static boolean isSubset(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = objectArray.length;
        int n7 = n4 = objectArray2 != null ? objectArray2.length : 0;
        if (n != Integer.MIN_VALUE) {
            for (n3 = 0; n3 < n6 && n >= FHashSet.hashCode(objectArray[n3]); ++n3) {
            }
        }
        if (n2 != Integer.MAX_VALUE) {
            while (n3 < n6 && n2 <= FHashSet.hashCode(objectArray[n6 - 1])) {
                --n6;
            }
        }
        Object object = null;
        Object object2 = null;
        int n8 = 0;
        int n9 = 0;
        if (n3 < n6) {
            object = objectArray[n3];
            n8 = FHashSet.hashCode(object);
        }
        if (n5 < n4) {
            object2 = objectArray2[n5];
            n9 = FHashSet.hashCode(object2);
        }
        while (n3 < n6 && n5 < n4) {
            if (n8 < n9) {
                return false;
            }
            if (n8 > n9) {
                if (++n5 >= n4) continue;
                object2 = objectArray2[n5];
                n9 = FHashSet.hashCode(object2);
                continue;
            }
            if (!FHashSet.eql(object, object2)) {
                return false;
            }
            ++n5;
            if (++n3 < n6) {
                object = objectArray[n3];
                n8 = FHashSet.hashCode(object);
            }
            if (n5 >= n4) continue;
            object2 = objectArray2[n5];
            n9 = FHashSet.hashCode(object2);
        }
        return n3 >= n6;
    }

    private static int binarySearch(Object[] objectArray, int n) {
        int n2 = 0;
        int n3 = objectArray.length - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object = objectArray[n4];
            int n5 = FHashSet.hashCode(object);
            if (n == n5) {
                return n4 << 1 | 1;
            }
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2 << 1 | 0;
    }

    private static int binarySearchLo(Object[] objectArray, int n) {
        int n2 = FHashSet.binarySearch(objectArray, n);
        int n3 = n2 >> 1;
        if ((n2 & 1) == 1) {
            return n3 + 1;
        }
        return n3;
    }

    private static int binarySearchHi(Object[] objectArray, int n) {
        int n2 = FHashSet.binarySearch(objectArray, n);
        return n2 >> 1;
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Elt Elt : this) {
            objectOutputStream.writeObject(Elt);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object object = null;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectInputStream.readObject();
            object = FHashSet.with(object, object2, FHashSet.hashCode(object2));
        }
        try {
            TreeField.set(this, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FHashSet deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            TreeField = FHashSet.class.getDeclaredField("tree");
            TreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }

    private static final class FHSIterator<Elt>
    implements Iterator<Elt> {
        private IteratorNode inode;

        FHSIterator(Object object) {
            this.inode = new IteratorNode(object, 0, null);
            this.canonicalize();
        }

        private void canonicalize() {
            while (this.inode != null) {
                if (this.inode.subtree == null) {
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                if (!(this.inode.subtree instanceof Node)) {
                    if (this.inode.index < ((Object[])this.inode.subtree).length) break;
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                Node node = (Node)this.inode.subtree;
                if (this.inode.index == 0) {
                    this.inode = new IteratorNode(node.left, 0, this.inode);
                    continue;
                }
                if (this.inode.index != FHashSet.elementSize(node.element) + 1) break;
                this.inode = new IteratorNode(node.right, 0, this.inode.parent);
            }
        }

        @Override
        public boolean hasNext() {
            return this.inode != null;
        }

        @Override
        public Elt next() {
            Object object;
            if (this.inode == null) {
                throw new NoSuchElementException();
            }
            if (!(this.inode.subtree instanceof Node)) {
                object = ((Object[])this.inode.subtree)[this.inode.index];
            } else {
                Node node = (Node)this.inode.subtree;
                if (node.element instanceof EquivalentSet) {
                    ArrayList<Object> arrayList = ((EquivalentSet)node.element).contents;
                    object = arrayList.get(this.inode.index - 1);
                } else {
                    object = node.element;
                }
            }
            this.inode.index++;
            this.canonicalize();
            return (Elt)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static final class IteratorNode {
            private final Object subtree;
            private int index;
            private final IteratorNode parent;

            IteratorNode(Object object, int n, IteratorNode iteratorNode) {
                this.subtree = object;
                this.index = n;
                this.parent = iteratorNode;
            }
        }
    }

    static final class EquivalentSet {
        ArrayList<Object> contents;

        EquivalentSet(ArrayList<Object> arrayList) {
            this.contents = arrayList;
        }
    }

    private static final class RankTrimResult {
        Object subtree;
        int base;

        RankTrimResult(Object object, int n) {
            this.subtree = object;
            this.base = n;
        }
    }

    static final class Node {
        final int size;
        final Object element;
        final Object left;
        final Object right;

        Node(int n, Object object, Object object2, Object object3) {
            this.size = n;
            this.element = object;
            this.left = object2;
            this.right = object3;
        }
    }
}

