/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.sqs.scaladsl;

import akka.NotUsed;
import akka.annotation.ApiMayChange;
import akka.dispatch.ExecutionContexts$;
import akka.stream.alpakka.sqs.SqsBatchException;
import akka.stream.alpakka.sqs.SqsPublishBatchSettings;
import akka.stream.alpakka.sqs.SqsPublishBatchSettings$;
import akka.stream.alpakka.sqs.SqsPublishGroupedSettings;
import akka.stream.alpakka.sqs.SqsPublishGroupedSettings$;
import akka.stream.alpakka.sqs.SqsPublishResult;
import akka.stream.alpakka.sqs.SqsPublishResultEntry;
import akka.stream.alpakka.sqs.SqsPublishSettings;
import akka.stream.alpakka.sqs.SqsPublishSettings$;
import akka.stream.alpakka.sqs.scaladsl.SqsAckFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source$;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SqsResponseMetadata;

@ApiMayChange
public final class SqsPublishFlow$ {
    public static final SqsPublishFlow$ MODULE$ = new SqsPublishFlow$();

    public Flow<SendMessageRequest, SqsPublishResult, NotUsed> apply(String queueUrl, SqsPublishSettings settings, SqsAsyncClient sqsClient) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)r -> (SendMessageRequest)r.toBuilder().queueUrl(queueUrl).build()).via(this.apply(settings, sqsClient));
    }

    public Flow<SendMessageRequest, SqsPublishResult, NotUsed> apply(String queueUrl, SqsAsyncClient sqsClient) {
        return this.apply(queueUrl, SqsPublishSettings$.MODULE$.Defaults(), sqsClient);
    }

    public Flow<SendMessageRequest, SqsPublishResult, NotUsed> apply(SqsPublishSettings settings, SqsAsyncClient sqsClient) {
        SqsAckFlow$.MODULE$.checkClient(sqsClient);
        return (Flow)Flow$.MODULE$.apply().mapAsync(settings.maxInFlight(), (Function1 & Serializable)req -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)sqsClient.sendMessage(req))).map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(req), x$1), ExecutionContexts$.MODULE$.parasitic())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SendMessageRequest request = (SendMessageRequest)tuple2._1();
                SendMessageResponse response = (SendMessageResponse)tuple2._2();
                return new SqsPublishResult(request, response);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public SqsPublishSettings apply$default$1() {
        return SqsPublishSettings$.MODULE$.Defaults();
    }

    public Flow<SendMessageRequest, SqsPublishResultEntry, NotUsed> grouped(String queueUrl, SqsPublishGroupedSettings settings, SqsAsyncClient sqsClient) {
        return (Flow)((Flow)Flow$.MODULE$.apply().groupedWithin(settings.maxBatchSize(), settings.maxBatchWait())).via(this.batch(queueUrl, SqsPublishBatchSettings$.MODULE$.create().withConcurrentRequests(settings.concurrentRequests()), sqsClient)).mapConcat((Function1 & Serializable)x -> (List)Predef$.MODULE$.identity(x));
    }

    public SqsPublishGroupedSettings grouped$default$2() {
        return SqsPublishGroupedSettings$.MODULE$.Defaults();
    }

    public Flow<Iterable<SendMessageRequest>, List<SqsPublishResultEntry>, NotUsed> batch(String queueUrl, SqsPublishBatchSettings settings, SqsAsyncClient sqsClient) {
        SqsAckFlow$.MODULE$.checkClient(sqsClient);
        return (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)requests -> {
            Iterable entries = (Iterable)((IterableOps)requests.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    SendMessageRequest r = (SendMessageRequest)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(Integer.toString(i)).messageBody(r.messageBody()).messageAttributes(r.messageAttributes()).messageGroupId(r.messageGroupId()).messageDeduplicationId(r.messageDeduplicationId()).build();
                }
                throw new MatchError((Object)tuple2);
            });
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(requests), SendMessageBatchRequest.builder().queueUrl(queueUrl).entries((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)entries.toList()).asJava()).build());
        }).mapAsync(settings.concurrentRequests(), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Iterable requests = (Iterable)tuple2._1();
                SendMessageBatchRequest batchRequest = (SendMessageBatchRequest)tuple2._2();
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)sqsClient.sendMessageBatch(batchRequest))).map((Function1 & Serializable)x0$3 -> {
                    SendMessageBatchResponse sendMessageBatchResponse = x0$3;
                    if (sendMessageBatchResponse.failed().isEmpty()) {
                        SqsResponseMetadata responseMetadata = sendMessageBatchResponse.responseMetadata();
                        Map resultEntries = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sendMessageBatchResponse.successful()).asScala()).map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(e.id())))), e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        return ((IterableOnceOps)((IterableOps)requests.zipWithIndex()).map((Function1 & Serializable)x0$4 -> {
                            Tuple2 tuple2 = x0$4;
                            if (tuple2 != null) {
                                SendMessageRequest r = (SendMessageRequest)tuple2._1();
                                int i = tuple2._2$mcI$sp();
                                SendMessageBatchResultEntry result = (SendMessageBatchResultEntry)resultEntries.apply((Object)BoxesRunTime.boxToInteger((int)i));
                                return new SqsPublishResultEntry(r, result, responseMetadata);
                            }
                            throw new MatchError((Object)tuple2);
                        })).toList();
                    }
                    int numberOfMessages = batchRequest.entries().size();
                    int nrOfFailedMessages = sendMessageBatchResponse.failed().size();
                    throw new SqsBatchException(numberOfMessages, new StringBuilder(58).append("Some messages are failed to send. ").append(nrOfFailedMessages).append(" of ").append(numberOfMessages).append(" messages are failed").toString());
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            throw new MatchError((Object)tuple2);
        }).recoverWithRetries(1, (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)A1;
                    return (B1)Source$.MODULE$.failed(completionException.getCause());
                }
                if (A1 instanceof SqsBatchException) {
                    SqsBatchException sqsBatchException = (SqsBatchException)A1;
                    return (B1)Source$.MODULE$.failed((Throwable)sqsBatchException);
                }
                return (B1)Source$.MODULE$.failed(A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof CompletionException) {
                    return true;
                }
                if (throwable instanceof SqsBatchException) {
                    return true;
                }
                return true;
            }
        });
    }

    public SqsPublishBatchSettings batch$default$2() {
        return SqsPublishBatchSettings$.MODULE$.Defaults();
    }

    private SqsPublishFlow$() {
    }
}

