/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.sqs.scaladsl;

import akka.NotUsed;
import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.UniformFanInShape;
import akka.stream.UniformFanOutShape;
import akka.stream.alpakka.sqs.MessageAction;
import akka.stream.alpakka.sqs.SqsAckGroupedSettings;
import akka.stream.alpakka.sqs.SqsAckGroupedSettings$;
import akka.stream.alpakka.sqs.SqsAckResult;
import akka.stream.alpakka.sqs.SqsAckResultEntry;
import akka.stream.alpakka.sqs.SqsAckSettings;
import akka.stream.alpakka.sqs.SqsAckSettings$;
import akka.stream.alpakka.sqs.SqsBatchException;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Merge$;
import akka.stream.scaladsl.Partition$;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.SqsResponseMetadata;

@ApiMayChange
public final class SqsAckFlow$ {
    public static final SqsAckFlow$ MODULE$ = new SqsAckFlow$();

    public Flow<MessageAction, SqsAckResult, NotUsed> apply(String queueUrl, SqsAckSettings settings, SqsAsyncClient sqsClient) {
        this.checkClient(sqsClient);
        return (Flow)Flow$.MODULE$.apply().mapAsync(settings.maxInFlight(), (Function1 & Serializable)x0$1 -> {
            MessageAction messageAction = x0$1;
            if (messageAction instanceof MessageAction.Delete) {
                MessageAction.Delete delete = (MessageAction.Delete)messageAction;
                DeleteMessageRequest request = (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(queueUrl).receiptHandle(delete.message().receiptHandle()).build();
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)sqsClient.deleteMessage(request))).map((Function1 & Serializable)resp -> new SqsAckResult.SqsDeleteResult(delete, (DeleteMessageResponse)resp), ExecutionContexts$.MODULE$.parasitic());
            }
            if (messageAction instanceof MessageAction.ChangeMessageVisibility) {
                MessageAction.ChangeMessageVisibility changeMessageVisibility = (MessageAction.ChangeMessageVisibility)messageAction;
                ChangeMessageVisibilityRequest request = (ChangeMessageVisibilityRequest)ChangeMessageVisibilityRequest.builder().queueUrl(queueUrl).receiptHandle(changeMessageVisibility.message().receiptHandle()).visibilityTimeout(Predef$.MODULE$.int2Integer(changeMessageVisibility.visibilityTimeout())).build();
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)sqsClient.changeMessageVisibility(request))).map((Function1 & Serializable)resp -> new SqsAckResult.SqsChangeMessageVisibilityResult(changeMessageVisibility, (ChangeMessageVisibilityResponse)resp), ExecutionContexts$.MODULE$.parasitic());
            }
            if (messageAction instanceof MessageAction.Ignore) {
                MessageAction.Ignore ignore = (MessageAction.Ignore)messageAction;
                return Future$.MODULE$.successful((Object)new SqsAckResult.SqsIgnoreResult(ignore));
            }
            throw new MatchError((Object)messageAction);
        });
    }

    public SqsAckSettings apply$default$2() {
        return SqsAckSettings$.MODULE$.Defaults();
    }

    public Flow<MessageAction, SqsAckResultEntry, NotUsed> grouped(String queueUrl, SqsAckGroupedSettings settings, SqsAsyncClient sqsClient) {
        this.checkClient(sqsClient);
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create((Function1 & Serializable)builder -> {
            UniformFanOutShape p = (UniformFanOutShape)builder.add((Graph)Partition$.MODULE$.apply(3, (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)SqsAckFlow$.$anonfun$grouped$2(x0$1))));
            UniformFanInShape merge = (UniformFanInShape)builder.add((Graph)Merge$.MODULE$.apply(3, Merge$.MODULE$.apply$default$2()));
            Flow mapDelete = (Flow)Flow$.MODULE$.apply().collectType(ClassTag$.MODULE$.apply(MessageAction.Delete.class));
            Flow mapChangeMessageVisibility = (Flow)Flow$.MODULE$.apply().collectType(ClassTag$.MODULE$.apply(MessageAction.ChangeMessageVisibility.class));
            Flow mapChangeIgnore = (Flow)Flow$.MODULE$.apply().collectType(ClassTag$.MODULE$.apply(MessageAction.Ignore.class));
            GraphDSL.Implicits$.MODULE$.port2flow(p.out(0), builder).$tilde$greater((Graph)mapDelete, builder).$tilde$greater(MODULE$.groupedDelete(queueUrl, settings, sqsClient), builder).$tilde$greater(merge, builder);
            GraphDSL.Implicits$.MODULE$.port2flow(p.out(1), builder).$tilde$greater((Graph)mapChangeMessageVisibility, builder).$tilde$greater(MODULE$.groupedChangeMessageVisibility(queueUrl, settings, sqsClient), builder).$tilde$greater(merge, builder);
            GraphDSL.Implicits$.MODULE$.port2flow(p.out(2), builder).$tilde$greater((Graph)mapChangeIgnore, builder).$tilde$greater((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)x$1 -> new SqsAckResultEntry.SqsIgnoreResultEntry((MessageAction.Ignore)x$1)), builder).$tilde$greater(merge, builder);
            return new FlowShape(p.in(), merge.out());
        }));
    }

    public SqsAckGroupedSettings grouped$default$2() {
        return SqsAckGroupedSettings$.MODULE$.Defaults();
    }

    private Flow<MessageAction.Delete, SqsAckResultEntry.SqsDeleteResultEntry, NotUsed> groupedDelete(String queueUrl, SqsAckGroupedSettings settings, SqsAsyncClient sqsClient) {
        this.checkClient(sqsClient);
        return (Flow)Flow$.MODULE$.apply().groupedWithin(settings.maxBatchSize(), settings.maxBatchWait()).map((Function1 & Serializable)actions -> {
            scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)((IterableOps)actions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    MessageAction.Delete a = (MessageAction.Delete)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(Integer.toString(i)).receiptHandle(a.message().receiptHandle()).build();
                }
                throw new MatchError((Object)tuple2);
            });
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(actions), DeleteMessageBatchRequest.builder().queueUrl(queueUrl).entries((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)entries).asJava()).build());
        }).mapAsync(settings.concurrentRequests(), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                scala.collection.immutable.Seq actions = (scala.collection.immutable.Seq)tuple2._1();
                DeleteMessageBatchRequest request = (DeleteMessageBatchRequest)tuple2._2();
                if (actions != null) {
                    scala.collection.immutable.Seq seq = actions;
                    return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)sqsClient.deleteMessageBatch(request))).map((Function1 & Serializable)x0$3 -> {
                        DeleteMessageBatchResponse deleteMessageBatchResponse = x0$3;
                        if (deleteMessageBatchResponse.failed().isEmpty()) {
                            SqsResponseMetadata responseMetadata = deleteMessageBatchResponse.responseMetadata();
                            Map resultEntries = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(deleteMessageBatchResponse.successful()).asScala()).map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(e.id())))), e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                            return (scala.collection.immutable.Seq)((IterableOps)seq.zipWithIndex()).map((Function1 & Serializable)x0$4 -> {
                                Tuple2 tuple2 = x0$4;
                                if (tuple2 != null) {
                                    MessageAction.Delete a = (MessageAction.Delete)tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    DeleteMessageBatchResultEntry result = (DeleteMessageBatchResultEntry)resultEntries.apply((Object)BoxesRunTime.boxToInteger((int)i));
                                    return new SqsAckResultEntry.SqsDeleteResultEntry(a, result, responseMetadata);
                                }
                                throw new MatchError((Object)tuple2);
                            });
                        }
                        int numberOfMessages = request.entries().size();
                        int nrOfFailedMessages = deleteMessageBatchResponse.failed().size();
                        throw new SqsBatchException(numberOfMessages, new StringBuilder(60).append("Some messages are failed to delete. ").append(nrOfFailedMessages).append(" of ").append(numberOfMessages).append(" messages are failed").toString());
                    }, ExecutionContexts$.MODULE$.parasitic()).recoverWith((PartialFunction)new Serializable(request){
                        private static final long serialVersionUID = 0L;
                        private final DeleteMessageBatchRequest request$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof CompletionException) {
                                CompletionException completionException = (CompletionException)A1;
                                return (B1)Future$.MODULE$.failed((Throwable)new SqsBatchException(this.request$1.entries().size(), completionException.getMessage(), completionException.getCause()));
                            }
                            return (B1)Future$.MODULE$.failed((Throwable)new SqsBatchException(this.request$1.entries().size(), A1.getMessage(), A1));
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            if (throwable instanceof CompletionException) {
                                return true;
                            }
                            return true;
                        }
                        {
                            this.request$1 = request$1;
                        }
                    }, ExecutionContexts$.MODULE$.parasitic());
                }
            }
            throw new MatchError((Object)tuple2);
        }).mapConcat((Function1 & Serializable)x -> (scala.collection.immutable.Seq)Predef$.MODULE$.identity(x));
    }

    private Flow<MessageAction.ChangeMessageVisibility, SqsAckResultEntry.SqsChangeMessageVisibilityResultEntry, NotUsed> groupedChangeMessageVisibility(String queueUrl, SqsAckGroupedSettings settings, SqsAsyncClient sqsClient) {
        return (Flow)Flow$.MODULE$.apply().groupedWithin(settings.maxBatchSize(), settings.maxBatchWait()).map((Function1 & Serializable)actions -> {
            scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)((IterableOps)actions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    MessageAction.ChangeMessageVisibility a = (MessageAction.ChangeMessageVisibility)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(Integer.toString(i)).receiptHandle(a.message().receiptHandle()).visibilityTimeout(Predef$.MODULE$.int2Integer(a.visibilityTimeout())).build();
                }
                throw new MatchError((Object)tuple2);
            });
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(actions), ChangeMessageVisibilityBatchRequest.builder().queueUrl(queueUrl).entries((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)entries).asJava()).build());
        }).mapAsync(settings.concurrentRequests(), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                scala.collection.immutable.Seq actions = (scala.collection.immutable.Seq)tuple2._1();
                ChangeMessageVisibilityBatchRequest request = (ChangeMessageVisibilityBatchRequest)tuple2._2();
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)sqsClient.changeMessageVisibilityBatch(request))).map((Function1 & Serializable)x0$3 -> {
                    ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatchResponse = x0$3;
                    if (changeMessageVisibilityBatchResponse.failed().isEmpty()) {
                        SqsResponseMetadata responseMetadata = changeMessageVisibilityBatchResponse.responseMetadata();
                        Map resultEntries = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(changeMessageVisibilityBatchResponse.successful()).asScala()).map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(e.id())))), e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        return (scala.collection.immutable.Seq)((IterableOps)actions.zipWithIndex()).map((Function1 & Serializable)x0$4 -> {
                            Tuple2 tuple2 = x0$4;
                            if (tuple2 != null) {
                                MessageAction.ChangeMessageVisibility a = (MessageAction.ChangeMessageVisibility)tuple2._1();
                                int i = tuple2._2$mcI$sp();
                                ChangeMessageVisibilityBatchResultEntry result = (ChangeMessageVisibilityBatchResultEntry)resultEntries.apply((Object)BoxesRunTime.boxToInteger((int)i));
                                return new SqsAckResultEntry.SqsChangeMessageVisibilityResultEntry(a, result, responseMetadata);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    int numberOfMessages = request.entries().size();
                    int nrOfFailedMessages = changeMessageVisibilityBatchResponse.failed().size();
                    throw new SqsBatchException(numberOfMessages, new StringBuilder(71).append("Some messages are failed to change visibility. ").append(nrOfFailedMessages).append(" of ").append(numberOfMessages).append(" messages are failed").toString());
                }, ExecutionContexts$.MODULE$.parasitic()).recoverWith((PartialFunction)new Serializable(request){
                    private static final long serialVersionUID = 0L;
                    private final ChangeMessageVisibilityBatchRequest request$2;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof CompletionException) {
                            CompletionException completionException = (CompletionException)A1;
                            return (B1)Future$.MODULE$.failed((Throwable)new SqsBatchException(this.request$2.entries().size(), completionException.getMessage(), completionException.getCause()));
                        }
                        return (B1)Future$.MODULE$.failed((Throwable)new SqsBatchException(this.request$2.entries().size(), A1.getMessage(), A1));
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        if (throwable instanceof CompletionException) {
                            return true;
                        }
                        return true;
                    }
                    {
                        this.request$2 = request$2;
                    }
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            throw new MatchError((Object)tuple2);
        }).mapConcat((Function1 & Serializable)x -> (scala.collection.immutable.Seq)Predef$.MODULE$.identity(x));
    }

    @InternalApi
    public void checkClient(SqsAsyncClient sqsClient) {
        Predef$.MODULE$.require(sqsClient != null, (Function0 & Serializable)() -> "The `SqsAsyncClient` passed in may not be null.");
    }

    public static final /* synthetic */ int $anonfun$grouped$2(MessageAction x0$1) {
        MessageAction messageAction = x0$1;
        if (messageAction instanceof MessageAction.Delete) {
            return 0;
        }
        if (messageAction instanceof MessageAction.ChangeMessageVisibility) {
            return 1;
        }
        if (messageAction instanceof MessageAction.Ignore) {
            return 2;
        }
        throw new MatchError((Object)messageAction);
    }

    private SqsAckFlow$() {
    }
}

