/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.file.impl.archive;

import akka.annotation.InternalApi;
import akka.stream.alpakka.file.TarArchiveMetadata;
import akka.stream.alpakka.file.TarArchiveMetadata$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class TarArchiveEntry$ {
    public static final TarArchiveEntry$ MODULE$ = new TarArchiveEntry$();
    private static final int fileNameLength = 100;
    private static final int fileModeLength = 8;
    private static final int ownerIdLength = 8;
    private static final int groupIdLength = 8;
    private static final int fileSizeLength = 12;
    private static final int lastModificationLength = 12;
    private static final int headerChecksumLength = 8;
    private static final int linkIndicatorLength = 1;
    private static final int linkFileNameLength = 100;
    private static final int ustarIndicatorLength = 6;
    private static final int ustarVersionLength = 2;
    private static final int ownerNameLength = 32;
    private static final int groupNameLength = 32;
    private static final int deviceMajorNumberLength = 8;
    private static final int deviceMinorNumberLength = 8;
    private static final int fileNamePrefixLength = 155;
    private static final int headerLength = 512;
    private static final ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1 = MODULE$.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$padded(ByteString$.MODULE$.apply("0755"), MODULE$.fileModeLength()).$plus$plus(MODULE$.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(MODULE$.ownerIdLength() + MODULE$.groupIdLength()));
    private static final ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2 = ByteString$.MODULE$.apply("        ");
    private static final ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3 = MODULE$.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(MODULE$.linkFileNameLength()).$plus$plus(ByteString$.MODULE$.apply("ustar")).$plus$plus(MODULE$.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(1 + MODULE$.ustarVersionLength() + MODULE$.ownerNameLength() + MODULE$.groupNameLength() + MODULE$.deviceMajorNumberLength() + MODULE$.deviceMinorNumberLength()));

    public int fileNameLength() {
        return fileNameLength;
    }

    public int fileModeLength() {
        return fileModeLength;
    }

    public int ownerIdLength() {
        return ownerIdLength;
    }

    public int groupIdLength() {
        return groupIdLength;
    }

    public int fileSizeLength() {
        return fileSizeLength;
    }

    public int lastModificationLength() {
        return lastModificationLength;
    }

    public int headerChecksumLength() {
        return headerChecksumLength;
    }

    public int linkIndicatorLength() {
        return linkIndicatorLength;
    }

    public int linkFileNameLength() {
        return linkFileNameLength;
    }

    public int ustarIndicatorLength() {
        return ustarIndicatorLength;
    }

    public int ustarVersionLength() {
        return ustarVersionLength;
    }

    public int ownerNameLength() {
        return ownerNameLength;
    }

    public int groupNameLength() {
        return groupNameLength;
    }

    public int deviceMajorNumberLength() {
        return deviceMajorNumberLength;
    }

    public int deviceMinorNumberLength() {
        return deviceMinorNumberLength;
    }

    public int fileNamePrefixLength() {
        return fileNamePrefixLength;
    }

    public int headerLength() {
        return headerLength;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1() {
        return akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2() {
        return akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3() {
        return akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$padded(ByteString bytes, int targetSize) {
        Predef$.MODULE$.require(bytes.size() <= targetSize, (Function0 & Serializable)() -> new StringBuilder(58).append("the padded data is ").append(bytes.size()).append(" bytes, which does not fit into  ").append(targetSize).append(" bytes").toString());
        if (bytes.size() < targetSize) {
            return bytes.$plus$plus(this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(targetSize - bytes.size()));
        }
        return bytes;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(int size) {
        return ByteString$.MODULE$.fromArrayUnsafe(new byte[size]);
    }

    public TarArchiveMetadata parse(ByteString bs) {
        Predef$.MODULE$.require(bs.length() >= this.headerLength(), (Function0 & Serializable)() -> "the tar archive header is expected to be at least 512 bytes");
        Predef$.MODULE$.require(bs.head() != 0, (Function0 & Serializable)() -> "the file name may not be empty");
        String filename = this.getString(bs, 0, this.fileNameLength());
        String fileSizeString = this.getString(bs, this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength(), this.fileSizeLength());
        long size = Long.parseUnsignedLong(fileSizeString, 8);
        String lastModificationString = this.getString(bs, this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength() + this.fileSizeLength(), this.lastModificationLength());
        Instant lastModification = Instant.ofEpochSecond(Long.parseUnsignedLong(lastModificationString, 8));
        byte tmp = bs.apply(this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength() + this.fileSizeLength() + this.lastModificationLength() + this.headerChecksumLength());
        byte linkIndicatorByte = tmp == 0 ? TarArchiveMetadata$.MODULE$.linkIndicatorNormal() : tmp;
        String fileNamePrefix = this.getString(bs, this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength() + this.fileSizeLength() + this.lastModificationLength() + this.headerChecksumLength() + this.linkIndicatorLength() + this.linkFileNameLength() + this.ustarIndicatorLength() + this.ustarVersionLength() + this.ownerNameLength() + this.groupNameLength() + this.deviceMajorNumberLength() + this.deviceMinorNumberLength(), this.fileNamePrefixLength());
        return TarArchiveMetadata$.MODULE$.apply(fileNamePrefix, filename, size, lastModification, linkIndicatorByte);
    }

    private String getString(ByteString bs, int from, int maxLength) {
        ByteString dropped = bs.drop(from);
        int f = Math.min(dropped.indexWhere((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)TarArchiveEntry$.$anonfun$getString$1(BoxesRunTime.unboxToByte((Object)b)))), maxLength);
        return dropped.take(f).utf8String();
    }

    public int trailerLength(TarArchiveMetadata metadata) {
        long modulo = metadata.size() % 512L;
        if (modulo > 0L) {
            return (int)(512L - modulo);
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$getString$1(byte b) {
        return b == (byte)0 || b == (byte)32;
    }

    private TarArchiveEntry$() {
    }
}

