/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.file.impl;

import akka.annotation.InternalApi;
import akka.japi.function.Procedure;
import akka.stream.Attributes;
import akka.stream.Outlet;
import akka.stream.Shape;
import akka.stream.SourceShape;
import akka.stream.stage.AbstractOutHandler;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import akka.util.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.concurrent.duration.FiniteDuration;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class FileTailSource
extends GraphStage<SourceShape<ByteString>> {
    private final Path path;
    private final int maxChunkSize;
    private final long startingPosition;
    private final FiniteDuration pollingInterval;
    private final Outlet<ByteString> out = Outlet.create((String)"FileTailSource.out");
    private final SourceShape<ByteString> shape = SourceShape.of(this.out);
    private static final CompletionHandler<Integer, AsyncCallback<Try<Integer>>> completionHandler = new CompletionHandler<Integer, AsyncCallback<Try<Integer>>>(){

        @Override
        public void completed(Integer n, AsyncCallback<Try<Integer>> asyncCallback) {
            asyncCallback.invoke((Object)new Success((Object)n));
        }

        @Override
        public void failed(Throwable throwable, AsyncCallback<Try<Integer>> asyncCallback) {
            asyncCallback.invoke((Object)new Failure(throwable));
        }
    };

    public FileTailSource(Path path, int n, long l, FiniteDuration finiteDuration) {
        this.path = path;
        this.maxChunkSize = n;
        this.startingPosition = l;
        this.pollingInterval = finiteDuration;
    }

    public SourceShape<ByteString> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes attributes) throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path '" + this.path + "' does not exist");
        }
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path '" + this.path + "' cannot be tailed, it is a directory");
        }
        if (!Files.isReadable(this.path)) {
            throw new IllegalArgumentException("No read permission for '" + this.path + "'");
        }
        return new TimerGraphStageLogic((Shape)this.shape){
            private final ByteBuffer buffer;
            private final AsynchronousFileChannel channel;
            private long position;
            private AsyncCallback<Try<Integer>> chunkCallback;
            {
                this.buffer = ByteBuffer.allocate(FileTailSource.this.maxChunkSize);
                this.channel = AsynchronousFileChannel.open(FileTailSource.this.path, StandardOpenOption.READ);
                this.position = FileTailSource.this.startingPosition;
                this.setHandler(FileTailSource.this.out, (OutHandler)new AbstractOutHandler(){

                    public void onPull() throws Exception {
                        this.doPull();
                    }
                });
            }

            public void preStart() {
                this.chunkCallback = this.createAsyncCallback((Procedure & Serializable)try_ -> {
                    if (try_.isSuccess()) {
                        int n = (Integer)try_.get();
                        if (n > 0) {
                            this.buffer.flip();
                            this.push(FileTailSource.this.out, ByteString.fromByteBuffer((ByteBuffer)this.buffer));
                            this.position += (long)n;
                            this.buffer.clear();
                        } else {
                            this.scheduleOnce("poll", FileTailSource.this.pollingInterval);
                        }
                    } else {
                        this.failStage((Throwable)try_.failed().get());
                    }
                });
            }

            public void onTimer(Object object) {
                this.doPull();
            }

            private void doPull() {
                this.channel.read(this.buffer, this.position, this.chunkCallback, completionHandler);
            }

            public void postStop() {
                try {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }
}

