/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.file;

import akka.stream.alpakka.file.TarArchiveMetadata;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class TarArchiveMetadata$ {
    public static final TarArchiveMetadata$ MODULE$ = new TarArchiveMetadata$();
    private static final byte linkIndicatorNormal = (byte)48;
    private static final byte linkIndicatorLink = (byte)49;
    private static final byte linkIndicatorSymLink = (byte)50;
    private static final byte linkIndicatorCharacterDevice = (byte)51;
    private static final byte linkIndicatorBlockDevice = (byte)52;
    private static final byte linkIndicatorDirectory = (byte)53;
    private static final byte linkIndicatorPipe = (byte)54;
    private static final byte linkIndicatorContiguousFile = (byte)55;

    public byte linkIndicatorNormal() {
        return linkIndicatorNormal;
    }

    public byte linkIndicatorLink() {
        return linkIndicatorLink;
    }

    public byte linkIndicatorSymLink() {
        return linkIndicatorSymLink;
    }

    public byte linkIndicatorCharacterDevice() {
        return linkIndicatorCharacterDevice;
    }

    public byte linkIndicatorBlockDevice() {
        return linkIndicatorBlockDevice;
    }

    public byte linkIndicatorDirectory() {
        return linkIndicatorDirectory;
    }

    public byte linkIndicatorPipe() {
        return linkIndicatorPipe;
    }

    public byte linkIndicatorContiguousFile() {
        return linkIndicatorContiguousFile;
    }

    public TarArchiveMetadata apply(String filePath, long size) {
        return this.apply(filePath, size, Instant.now());
    }

    public TarArchiveMetadata apply(String filePath, long size, Instant lastModification) {
        int filePathSegments = filePath.lastIndexOf("/");
        None$ filePathPrefix = filePathSegments > 0 ? new Some((Object)filePath.substring(0, filePathSegments)) : None$.MODULE$;
        String filePathName = filePath.substring(filePathSegments + 1, filePath.length());
        return this.apply((Option<String>)filePathPrefix, filePathName, size, lastModification, this.linkIndicatorNormal());
    }

    public TarArchiveMetadata apply(String filePathPrefix, String filePathName, long size, Instant lastModification) {
        return this.apply((Option<String>)(filePathPrefix.isEmpty() ? None$.MODULE$ : new Some((Object)filePathPrefix)), filePathName, size, lastModification, this.linkIndicatorNormal());
    }

    public TarArchiveMetadata apply(String filePathPrefix, String filePathName, long size, Instant lastModification, byte linkIndicatorByte) {
        return this.apply((Option<String>)(filePathPrefix.isEmpty() ? None$.MODULE$ : new Some((Object)filePathPrefix)), filePathName, size, lastModification, linkIndicatorByte);
    }

    private TarArchiveMetadata apply(Option<String> filePathPrefix, String filePathName, long size, Instant lastModification, byte linkIndicatorByte) {
        filePathPrefix.foreach((Function1 & Serializable)value -> {
            Predef$.MODULE$.require(value.length() <= 154, (Function0 & Serializable)() -> "File path prefix must be between 1 and 154 characters long");
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.require(filePathName.length() >= 0 && filePathName.length() <= 99, (Function0 & Serializable)() -> new StringBuilder(61).append("File path name must be between 0 and 99 characters long, was ").append(filePathName.length()).toString());
        return new TarArchiveMetadata(filePathPrefix, filePathName, size, lastModification.with(ChronoField.NANO_OF_SECOND, 0L), linkIndicatorByte);
    }

    public TarArchiveMetadata create(String filePath, long size) {
        return this.apply(filePath, size, Instant.now());
    }

    public TarArchiveMetadata create(String filePath, long size, Instant lastModification) {
        return this.apply(filePath, size, lastModification);
    }

    public TarArchiveMetadata create(String filePathPrefix, String filePathName, long size, Instant lastModification) {
        return this.apply(filePathPrefix, filePathName, size, lastModification);
    }

    public TarArchiveMetadata create(String filePathPrefix, String filePathName, long size, Instant lastModification, byte linkIndicatorByte) {
        return this.apply(filePathPrefix, filePathName, size, lastModification, linkIndicatorByte);
    }

    public TarArchiveMetadata directory(String filePathName) {
        return this.directory(filePathName, Instant.now());
    }

    public TarArchiveMetadata directory(String filePathName, Instant lastModification) {
        String n = filePathName.endsWith("/") ? filePathName : new StringBuilder(1).append(filePathName).append("/").toString();
        return this.apply((Option<String>)None$.MODULE$, n, 0L, lastModification, this.linkIndicatorDirectory());
    }

    private TarArchiveMetadata$() {
    }
}

