/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.social.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.SocialActivityCounter;
import com.liferay.social.kernel.model.SocialActivityCounterModel;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SocialActivityCounter service. Represents a row in the &quot;SocialActivityCounter&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SocialActivityCounterModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SocialActivityCounterImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialActivityCounterImpl
 * @generated
 */
public class SocialActivityCounterModelImpl
	extends BaseModelImpl<SocialActivityCounter>
	implements SocialActivityCounterModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a social activity counter model instance should use the <code>SocialActivityCounter</code> interface instead.
	 */
	public static final String TABLE_NAME = "SocialActivityCounter";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"activityCounterId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"name", Types.VARCHAR},
		{"ownerType", Types.INTEGER}, {"currentValue", Types.INTEGER},
		{"totalValue", Types.INTEGER}, {"graceValue", Types.INTEGER},
		{"startPeriod", Types.INTEGER}, {"endPeriod", Types.INTEGER},
		{"active_", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("activityCounterId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("ownerType", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("currentValue", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("totalValue", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("graceValue", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("startPeriod", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("endPeriod", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SocialActivityCounter (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,activityCounterId LONG not null,groupId LONG,companyId LONG,classNameId LONG,classPK LONG,name VARCHAR(75) null,ownerType INTEGER,currentValue INTEGER,totalValue INTEGER,graceValue INTEGER,startPeriod INTEGER,endPeriod INTEGER,active_ BOOLEAN,primary key (activityCounterId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table SocialActivityCounter";

	public static final String ORDER_BY_JPQL =
		" ORDER BY socialActivityCounter.activityCounterId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SocialActivityCounter.activityCounterId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ENDPERIOD_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OWNERTYPE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STARTPERIOD_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVITYCOUNTERID_COLUMN_BITMASK = 128L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.social.kernel.model.SocialActivityCounter"));

	public SocialActivityCounterModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _activityCounterId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setActivityCounterId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _activityCounterId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SocialActivityCounter.class;
	}

	@Override
	public String getModelClassName() {
		return SocialActivityCounter.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SocialActivityCounter, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SocialActivityCounter, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivityCounter, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SocialActivityCounter)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SocialActivityCounter, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SocialActivityCounter, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SocialActivityCounter)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SocialActivityCounter, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SocialActivityCounter, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, SocialActivityCounter>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			SocialActivityCounter.class.getClassLoader(),
			SocialActivityCounter.class, ModelWrapper.class);

		try {
			Constructor<SocialActivityCounter> constructor =
				(Constructor<SocialActivityCounter>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<SocialActivityCounter, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<SocialActivityCounter, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<SocialActivityCounter, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<SocialActivityCounter, Object>>();
		Map<String, BiConsumer<SocialActivityCounter, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<SocialActivityCounter, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", SocialActivityCounter::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", SocialActivityCounter::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setCtCollectionId);
		attributeGetterFunctions.put(
			"activityCounterId", SocialActivityCounter::getActivityCounterId);
		attributeSetterBiConsumers.put(
			"activityCounterId",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setActivityCounterId);
		attributeGetterFunctions.put(
			"groupId", SocialActivityCounter::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setGroupId);
		attributeGetterFunctions.put(
			"companyId", SocialActivityCounter::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setCompanyId);
		attributeGetterFunctions.put(
			"classNameId", SocialActivityCounter::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setClassNameId);
		attributeGetterFunctions.put(
			"classPK", SocialActivityCounter::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<SocialActivityCounter, Long>)
				SocialActivityCounter::setClassPK);
		attributeGetterFunctions.put("name", SocialActivityCounter::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<SocialActivityCounter, String>)
				SocialActivityCounter::setName);
		attributeGetterFunctions.put(
			"ownerType", SocialActivityCounter::getOwnerType);
		attributeSetterBiConsumers.put(
			"ownerType",
			(BiConsumer<SocialActivityCounter, Integer>)
				SocialActivityCounter::setOwnerType);
		attributeGetterFunctions.put(
			"currentValue", SocialActivityCounter::getCurrentValue);
		attributeSetterBiConsumers.put(
			"currentValue",
			(BiConsumer<SocialActivityCounter, Integer>)
				SocialActivityCounter::setCurrentValue);
		attributeGetterFunctions.put(
			"totalValue", SocialActivityCounter::getTotalValue);
		attributeSetterBiConsumers.put(
			"totalValue",
			(BiConsumer<SocialActivityCounter, Integer>)
				SocialActivityCounter::setTotalValue);
		attributeGetterFunctions.put(
			"graceValue", SocialActivityCounter::getGraceValue);
		attributeSetterBiConsumers.put(
			"graceValue",
			(BiConsumer<SocialActivityCounter, Integer>)
				SocialActivityCounter::setGraceValue);
		attributeGetterFunctions.put(
			"startPeriod", SocialActivityCounter::getStartPeriod);
		attributeSetterBiConsumers.put(
			"startPeriod",
			(BiConsumer<SocialActivityCounter, Integer>)
				SocialActivityCounter::setStartPeriod);
		attributeGetterFunctions.put(
			"endPeriod", SocialActivityCounter::getEndPeriod);
		attributeSetterBiConsumers.put(
			"endPeriod",
			(BiConsumer<SocialActivityCounter, Integer>)
				SocialActivityCounter::setEndPeriod);
		attributeGetterFunctions.put(
			"active", SocialActivityCounter::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<SocialActivityCounter, Boolean>)
				SocialActivityCounter::setActive);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getActivityCounterId() {
		return _activityCounterId;
	}

	@Override
	public void setActivityCounterId(long activityCounterId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_activityCounterId = activityCounterId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public int getOwnerType() {
		return _ownerType;
	}

	@Override
	public void setOwnerType(int ownerType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ownerType = ownerType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalOwnerType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("ownerType"));
	}

	@Override
	public int getCurrentValue() {
		return _currentValue;
	}

	@Override
	public void setCurrentValue(int currentValue) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_currentValue = currentValue;
	}

	@Override
	public int getTotalValue() {
		return _totalValue;
	}

	@Override
	public void setTotalValue(int totalValue) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalValue = totalValue;
	}

	@Override
	public int getGraceValue() {
		return _graceValue;
	}

	@Override
	public void setGraceValue(int graceValue) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_graceValue = graceValue;
	}

	@Override
	public int getStartPeriod() {
		return _startPeriod;
	}

	@Override
	public void setStartPeriod(int startPeriod) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_startPeriod = startPeriod;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStartPeriod() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("startPeriod"));
	}

	@Override
	public int getEndPeriod() {
		return _endPeriod;
	}

	@Override
	public void setEndPeriod(int endPeriod) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_endPeriod = endPeriod;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalEndPeriod() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("endPeriod"));
	}

	@Override
	public boolean getActive() {
		return _active;
	}

	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SocialActivityCounter.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SocialActivityCounter toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SocialActivityCounter>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SocialActivityCounterImpl socialActivityCounterImpl =
			new SocialActivityCounterImpl();

		socialActivityCounterImpl.setMvccVersion(getMvccVersion());
		socialActivityCounterImpl.setCtCollectionId(getCtCollectionId());
		socialActivityCounterImpl.setActivityCounterId(getActivityCounterId());
		socialActivityCounterImpl.setGroupId(getGroupId());
		socialActivityCounterImpl.setCompanyId(getCompanyId());
		socialActivityCounterImpl.setClassNameId(getClassNameId());
		socialActivityCounterImpl.setClassPK(getClassPK());
		socialActivityCounterImpl.setName(getName());
		socialActivityCounterImpl.setOwnerType(getOwnerType());
		socialActivityCounterImpl.setCurrentValue(getCurrentValue());
		socialActivityCounterImpl.setTotalValue(getTotalValue());
		socialActivityCounterImpl.setGraceValue(getGraceValue());
		socialActivityCounterImpl.setStartPeriod(getStartPeriod());
		socialActivityCounterImpl.setEndPeriod(getEndPeriod());
		socialActivityCounterImpl.setActive(isActive());

		socialActivityCounterImpl.resetOriginalValues();

		return socialActivityCounterImpl;
	}

	@Override
	public SocialActivityCounter cloneWithOriginalValues() {
		SocialActivityCounterImpl socialActivityCounterImpl =
			new SocialActivityCounterImpl();

		socialActivityCounterImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		socialActivityCounterImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		socialActivityCounterImpl.setActivityCounterId(
			this.<Long>getColumnOriginalValue("activityCounterId"));
		socialActivityCounterImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		socialActivityCounterImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		socialActivityCounterImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		socialActivityCounterImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		socialActivityCounterImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		socialActivityCounterImpl.setOwnerType(
			this.<Integer>getColumnOriginalValue("ownerType"));
		socialActivityCounterImpl.setCurrentValue(
			this.<Integer>getColumnOriginalValue("currentValue"));
		socialActivityCounterImpl.setTotalValue(
			this.<Integer>getColumnOriginalValue("totalValue"));
		socialActivityCounterImpl.setGraceValue(
			this.<Integer>getColumnOriginalValue("graceValue"));
		socialActivityCounterImpl.setStartPeriod(
			this.<Integer>getColumnOriginalValue("startPeriod"));
		socialActivityCounterImpl.setEndPeriod(
			this.<Integer>getColumnOriginalValue("endPeriod"));
		socialActivityCounterImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));

		return socialActivityCounterImpl;
	}

	@Override
	public int compareTo(SocialActivityCounter socialActivityCounter) {
		long primaryKey = socialActivityCounter.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SocialActivityCounter)) {
			return false;
		}

		SocialActivityCounter socialActivityCounter =
			(SocialActivityCounter)object;

		long primaryKey = socialActivityCounter.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SocialActivityCounter> toCacheModel() {
		SocialActivityCounterCacheModel socialActivityCounterCacheModel =
			new SocialActivityCounterCacheModel();

		socialActivityCounterCacheModel.mvccVersion = getMvccVersion();

		socialActivityCounterCacheModel.ctCollectionId = getCtCollectionId();

		socialActivityCounterCacheModel.activityCounterId =
			getActivityCounterId();

		socialActivityCounterCacheModel.groupId = getGroupId();

		socialActivityCounterCacheModel.companyId = getCompanyId();

		socialActivityCounterCacheModel.classNameId = getClassNameId();

		socialActivityCounterCacheModel.classPK = getClassPK();

		socialActivityCounterCacheModel.name = getName();

		String name = socialActivityCounterCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			socialActivityCounterCacheModel.name = null;
		}

		socialActivityCounterCacheModel.ownerType = getOwnerType();

		socialActivityCounterCacheModel.currentValue = getCurrentValue();

		socialActivityCounterCacheModel.totalValue = getTotalValue();

		socialActivityCounterCacheModel.graceValue = getGraceValue();

		socialActivityCounterCacheModel.startPeriod = getStartPeriod();

		socialActivityCounterCacheModel.endPeriod = getEndPeriod();

		socialActivityCounterCacheModel.active = isActive();

		return socialActivityCounterCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SocialActivityCounter, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SocialActivityCounter, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivityCounter, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(SocialActivityCounter)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<SocialActivityCounter, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<SocialActivityCounter, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivityCounter, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((SocialActivityCounter)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SocialActivityCounter>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _activityCounterId;
	private long _groupId;
	private long _companyId;
	private long _classNameId;
	private long _classPK;
	private String _name;
	private int _ownerType;
	private int _currentValue;
	private int _totalValue;
	private int _graceValue;
	private int _startPeriod;
	private int _endPeriod;
	private boolean _active;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<SocialActivityCounter, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SocialActivityCounter)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("activityCounterId", _activityCounterId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("ownerType", _ownerType);
		_columnOriginalValues.put("currentValue", _currentValue);
		_columnOriginalValues.put("totalValue", _totalValue);
		_columnOriginalValues.put("graceValue", _graceValue);
		_columnOriginalValues.put("startPeriod", _startPeriod);
		_columnOriginalValues.put("endPeriod", _endPeriod);
		_columnOriginalValues.put("active_", _active);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("activityCounterId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("classNameId", 32L);

		columnBitmasks.put("classPK", 64L);

		columnBitmasks.put("name", 128L);

		columnBitmasks.put("ownerType", 256L);

		columnBitmasks.put("currentValue", 512L);

		columnBitmasks.put("totalValue", 1024L);

		columnBitmasks.put("graceValue", 2048L);

		columnBitmasks.put("startPeriod", 4096L);

		columnBitmasks.put("endPeriod", 8192L);

		columnBitmasks.put("active_", 16384L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SocialActivityCounter _escapedModel;

}