/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFileVersionModel;
import com.liferay.document.library.kernel.model.DLFileVersionSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLFileVersion service. Represents a row in the &quot;DLFileVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLFileVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLFileVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFileVersionImpl
 * @generated
 */
@JSON(strict = true)
public class DLFileVersionModelImpl
	extends BaseModelImpl<DLFileVersion> implements DLFileVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library file version model instance should use the <code>DLFileVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLFileVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"fileVersionId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"repositoryId", Types.BIGINT}, {"folderId", Types.BIGINT},
		{"fileEntryId", Types.BIGINT}, {"treePath", Types.VARCHAR},
		{"fileName", Types.VARCHAR}, {"extension", Types.VARCHAR},
		{"mimeType", Types.VARCHAR}, {"title", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"changeLog", Types.VARCHAR},
		{"extraSettings", Types.CLOB}, {"fileEntryTypeId", Types.BIGINT},
		{"version", Types.VARCHAR}, {"size_", Types.BIGINT},
		{"checksum", Types.VARCHAR}, {"expirationDate", Types.TIMESTAMP},
		{"reviewDate", Types.TIMESTAMP}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("repositoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("folderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extension", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("mimeType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("changeLog", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extraSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("fileEntryTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("size_", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("checksum", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("reviewDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLFileVersion (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,fileVersionId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,repositoryId LONG,folderId LONG,fileEntryId LONG,treePath STRING null,fileName VARCHAR(255) null,extension VARCHAR(75) null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,changeLog VARCHAR(75) null,extraSettings TEXT null,fileEntryTypeId LONG,version VARCHAR(75) null,size_ LONG,checksum VARCHAR(75) null,expirationDate DATE null,reviewDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (fileVersionId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table DLFileVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLFileVersion.fileEntryId DESC, DLFileVersion.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FILEENTRYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FOLDERID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MIMETYPE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TITLE_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 512L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static DLFileVersion toModel(DLFileVersionSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		DLFileVersion model = new DLFileVersionImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setUuid(soapModel.getUuid());
		model.setFileVersionId(soapModel.getFileVersionId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setRepositoryId(soapModel.getRepositoryId());
		model.setFolderId(soapModel.getFolderId());
		model.setFileEntryId(soapModel.getFileEntryId());
		model.setTreePath(soapModel.getTreePath());
		model.setFileName(soapModel.getFileName());
		model.setExtension(soapModel.getExtension());
		model.setMimeType(soapModel.getMimeType());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setChangeLog(soapModel.getChangeLog());
		model.setExtraSettings(soapModel.getExtraSettings());
		model.setFileEntryTypeId(soapModel.getFileEntryTypeId());
		model.setVersion(soapModel.getVersion());
		model.setSize(soapModel.getSize());
		model.setChecksum(soapModel.getChecksum());
		model.setExpirationDate(soapModel.getExpirationDate());
		model.setReviewDate(soapModel.getReviewDate());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<DLFileVersion> toModels(DLFileVersionSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<DLFileVersion> models = new ArrayList<DLFileVersion>(
			soapModels.length);

		for (DLFileVersionSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.document.library.kernel.model.DLFileVersion"));

	public DLFileVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fileVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFileVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fileVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLFileVersion.class;
	}

	@Override
	public String getModelClassName() {
		return DLFileVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLFileVersion, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLFileVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileVersion, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DLFileVersion)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLFileVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLFileVersion, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLFileVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLFileVersion, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLFileVersion, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, DLFileVersion>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			DLFileVersion.class.getClassLoader(), DLFileVersion.class,
			ModelWrapper.class);

		try {
			Constructor<DLFileVersion> constructor =
				(Constructor<DLFileVersion>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<DLFileVersion, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<DLFileVersion, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<DLFileVersion, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DLFileVersion, Object>>();
		Map<String, BiConsumer<DLFileVersion, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DLFileVersion, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", DLFileVersion::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", DLFileVersion::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setCtCollectionId);
		attributeGetterFunctions.put("uuid", DLFileVersion::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<DLFileVersion, String>)DLFileVersion::setUuid);
		attributeGetterFunctions.put(
			"fileVersionId", DLFileVersion::getFileVersionId);
		attributeSetterBiConsumers.put(
			"fileVersionId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setFileVersionId);
		attributeGetterFunctions.put("groupId", DLFileVersion::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setGroupId);
		attributeGetterFunctions.put("companyId", DLFileVersion::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setCompanyId);
		attributeGetterFunctions.put("userId", DLFileVersion::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setUserId);
		attributeGetterFunctions.put("userName", DLFileVersion::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setUserName);
		attributeGetterFunctions.put(
			"createDate", DLFileVersion::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<DLFileVersion, Date>)DLFileVersion::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", DLFileVersion::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<DLFileVersion, Date>)DLFileVersion::setModifiedDate);
		attributeGetterFunctions.put(
			"repositoryId", DLFileVersion::getRepositoryId);
		attributeSetterBiConsumers.put(
			"repositoryId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setRepositoryId);
		attributeGetterFunctions.put("folderId", DLFileVersion::getFolderId);
		attributeSetterBiConsumers.put(
			"folderId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setFolderId);
		attributeGetterFunctions.put(
			"fileEntryId", DLFileVersion::getFileEntryId);
		attributeSetterBiConsumers.put(
			"fileEntryId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setFileEntryId);
		attributeGetterFunctions.put("treePath", DLFileVersion::getTreePath);
		attributeSetterBiConsumers.put(
			"treePath",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setTreePath);
		attributeGetterFunctions.put("fileName", DLFileVersion::getFileName);
		attributeSetterBiConsumers.put(
			"fileName",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setFileName);
		attributeGetterFunctions.put("extension", DLFileVersion::getExtension);
		attributeSetterBiConsumers.put(
			"extension",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setExtension);
		attributeGetterFunctions.put("mimeType", DLFileVersion::getMimeType);
		attributeSetterBiConsumers.put(
			"mimeType",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setMimeType);
		attributeGetterFunctions.put("title", DLFileVersion::getTitle);
		attributeSetterBiConsumers.put(
			"title",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setTitle);
		attributeGetterFunctions.put(
			"description", DLFileVersion::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setDescription);
		attributeGetterFunctions.put("changeLog", DLFileVersion::getChangeLog);
		attributeSetterBiConsumers.put(
			"changeLog",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setChangeLog);
		attributeGetterFunctions.put(
			"extraSettings", DLFileVersion::getExtraSettings);
		attributeSetterBiConsumers.put(
			"extraSettings",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setExtraSettings);
		attributeGetterFunctions.put(
			"fileEntryTypeId", DLFileVersion::getFileEntryTypeId);
		attributeSetterBiConsumers.put(
			"fileEntryTypeId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setFileEntryTypeId);
		attributeGetterFunctions.put("version", DLFileVersion::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setVersion);
		attributeGetterFunctions.put("size", DLFileVersion::getSize);
		attributeSetterBiConsumers.put(
			"size", (BiConsumer<DLFileVersion, Long>)DLFileVersion::setSize);
		attributeGetterFunctions.put("checksum", DLFileVersion::getChecksum);
		attributeSetterBiConsumers.put(
			"checksum",
			(BiConsumer<DLFileVersion, String>)DLFileVersion::setChecksum);
		attributeGetterFunctions.put(
			"expirationDate", DLFileVersion::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<DLFileVersion, Date>)DLFileVersion::setExpirationDate);
		attributeGetterFunctions.put(
			"reviewDate", DLFileVersion::getReviewDate);
		attributeSetterBiConsumers.put(
			"reviewDate",
			(BiConsumer<DLFileVersion, Date>)DLFileVersion::setReviewDate);
		attributeGetterFunctions.put(
			"lastPublishDate", DLFileVersion::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<DLFileVersion, Date>)DLFileVersion::setLastPublishDate);
		attributeGetterFunctions.put("status", DLFileVersion::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<DLFileVersion, Integer>)DLFileVersion::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", DLFileVersion::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<DLFileVersion, Long>)DLFileVersion::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", DLFileVersion::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<DLFileVersion, String>)
				DLFileVersion::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", DLFileVersion::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<DLFileVersion, Date>)DLFileVersion::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getFileVersionId() {
		return _fileVersionId;
	}

	@Override
	public void setFileVersionId(long fileVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileVersionId = fileVersionId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getRepositoryId() {
		return _repositoryId;
	}

	@Override
	public void setRepositoryId(long repositoryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_repositoryId = repositoryId;
	}

	@JSON
	@Override
	public long getFolderId() {
		return _folderId;
	}

	@Override
	public void setFolderId(long folderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_folderId = folderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("folderId"));
	}

	@JSON
	@Override
	public long getFileEntryId() {
		return _fileEntryId;
	}

	@Override
	public void setFileEntryId(long fileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileEntryId = fileEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFileEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fileEntryId"));
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	@JSON
	@Override
	public String getFileName() {
		if (_fileName == null) {
			return "";
		}
		else {
			return _fileName;
		}
	}

	@Override
	public void setFileName(String fileName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileName = fileName;
	}

	@JSON
	@Override
	public String getExtension() {
		if (_extension == null) {
			return "";
		}
		else {
			return _extension;
		}
	}

	@Override
	public void setExtension(String extension) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extension = extension;
	}

	@JSON
	@Override
	public String getMimeType() {
		if (_mimeType == null) {
			return "";
		}
		else {
			return _mimeType;
		}
	}

	@Override
	public void setMimeType(String mimeType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mimeType = mimeType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalMimeType() {
		return getColumnOriginalValue("mimeType");
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTitle() {
		return getColumnOriginalValue("title");
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getChangeLog() {
		if (_changeLog == null) {
			return "";
		}
		else {
			return _changeLog;
		}
	}

	@Override
	public void setChangeLog(String changeLog) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_changeLog = changeLog;
	}

	@JSON
	@Override
	public String getExtraSettings() {
		if (_extraSettings == null) {
			return "";
		}
		else {
			return _extraSettings;
		}
	}

	@Override
	public void setExtraSettings(String extraSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extraSettings = extraSettings;
	}

	@JSON
	@Override
	public long getFileEntryTypeId() {
		return _fileEntryTypeId;
	}

	@Override
	public void setFileEntryTypeId(long fileEntryTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileEntryTypeId = fileEntryTypeId;
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalVersion() {
		return getColumnOriginalValue("version");
	}

	@JSON
	@Override
	public long getSize() {
		return _size;
	}

	@Override
	public void setSize(long size) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_size = size;
	}

	@JSON
	@Override
	public String getChecksum() {
		if (_checksum == null) {
			return "";
		}
		else {
			return _checksum;
		}
	}

	@Override
	public void setChecksum(String checksum) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_checksum = checksum;
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getReviewDate() {
		return _reviewDate;
	}

	@Override
	public void setReviewDate(Date reviewDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reviewDate = reviewDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(DLFileVersion.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLFileVersion.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLFileVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLFileVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLFileVersionImpl dlFileVersionImpl = new DLFileVersionImpl();

		dlFileVersionImpl.setMvccVersion(getMvccVersion());
		dlFileVersionImpl.setCtCollectionId(getCtCollectionId());
		dlFileVersionImpl.setUuid(getUuid());
		dlFileVersionImpl.setFileVersionId(getFileVersionId());
		dlFileVersionImpl.setGroupId(getGroupId());
		dlFileVersionImpl.setCompanyId(getCompanyId());
		dlFileVersionImpl.setUserId(getUserId());
		dlFileVersionImpl.setUserName(getUserName());
		dlFileVersionImpl.setCreateDate(getCreateDate());
		dlFileVersionImpl.setModifiedDate(getModifiedDate());
		dlFileVersionImpl.setRepositoryId(getRepositoryId());
		dlFileVersionImpl.setFolderId(getFolderId());
		dlFileVersionImpl.setFileEntryId(getFileEntryId());
		dlFileVersionImpl.setTreePath(getTreePath());
		dlFileVersionImpl.setFileName(getFileName());
		dlFileVersionImpl.setExtension(getExtension());
		dlFileVersionImpl.setMimeType(getMimeType());
		dlFileVersionImpl.setTitle(getTitle());
		dlFileVersionImpl.setDescription(getDescription());
		dlFileVersionImpl.setChangeLog(getChangeLog());
		dlFileVersionImpl.setExtraSettings(getExtraSettings());
		dlFileVersionImpl.setFileEntryTypeId(getFileEntryTypeId());
		dlFileVersionImpl.setVersion(getVersion());
		dlFileVersionImpl.setSize(getSize());
		dlFileVersionImpl.setChecksum(getChecksum());
		dlFileVersionImpl.setExpirationDate(getExpirationDate());
		dlFileVersionImpl.setReviewDate(getReviewDate());
		dlFileVersionImpl.setLastPublishDate(getLastPublishDate());
		dlFileVersionImpl.setStatus(getStatus());
		dlFileVersionImpl.setStatusByUserId(getStatusByUserId());
		dlFileVersionImpl.setStatusByUserName(getStatusByUserName());
		dlFileVersionImpl.setStatusDate(getStatusDate());

		dlFileVersionImpl.resetOriginalValues();

		return dlFileVersionImpl;
	}

	@Override
	public DLFileVersion cloneWithOriginalValues() {
		DLFileVersionImpl dlFileVersionImpl = new DLFileVersionImpl();

		dlFileVersionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		dlFileVersionImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		dlFileVersionImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		dlFileVersionImpl.setFileVersionId(
			this.<Long>getColumnOriginalValue("fileVersionId"));
		dlFileVersionImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		dlFileVersionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		dlFileVersionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		dlFileVersionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		dlFileVersionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		dlFileVersionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		dlFileVersionImpl.setRepositoryId(
			this.<Long>getColumnOriginalValue("repositoryId"));
		dlFileVersionImpl.setFolderId(
			this.<Long>getColumnOriginalValue("folderId"));
		dlFileVersionImpl.setFileEntryId(
			this.<Long>getColumnOriginalValue("fileEntryId"));
		dlFileVersionImpl.setTreePath(
			this.<String>getColumnOriginalValue("treePath"));
		dlFileVersionImpl.setFileName(
			this.<String>getColumnOriginalValue("fileName"));
		dlFileVersionImpl.setExtension(
			this.<String>getColumnOriginalValue("extension"));
		dlFileVersionImpl.setMimeType(
			this.<String>getColumnOriginalValue("mimeType"));
		dlFileVersionImpl.setTitle(
			this.<String>getColumnOriginalValue("title"));
		dlFileVersionImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		dlFileVersionImpl.setChangeLog(
			this.<String>getColumnOriginalValue("changeLog"));
		dlFileVersionImpl.setExtraSettings(
			this.<String>getColumnOriginalValue("extraSettings"));
		dlFileVersionImpl.setFileEntryTypeId(
			this.<Long>getColumnOriginalValue("fileEntryTypeId"));
		dlFileVersionImpl.setVersion(
			this.<String>getColumnOriginalValue("version"));
		dlFileVersionImpl.setSize(this.<Long>getColumnOriginalValue("size_"));
		dlFileVersionImpl.setChecksum(
			this.<String>getColumnOriginalValue("checksum"));
		dlFileVersionImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		dlFileVersionImpl.setReviewDate(
			this.<Date>getColumnOriginalValue("reviewDate"));
		dlFileVersionImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		dlFileVersionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		dlFileVersionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		dlFileVersionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		dlFileVersionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return dlFileVersionImpl;
	}

	@Override
	public int compareTo(DLFileVersion dlFileVersion) {
		int value = 0;

		if (getFileEntryId() < dlFileVersion.getFileEntryId()) {
			value = -1;
		}
		else if (getFileEntryId() > dlFileVersion.getFileEntryId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = DateUtil.compareTo(
			getCreateDate(), dlFileVersion.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLFileVersion)) {
			return false;
		}

		DLFileVersion dlFileVersion = (DLFileVersion)object;

		long primaryKey = dlFileVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLFileVersion> toCacheModel() {
		DLFileVersionCacheModel dlFileVersionCacheModel =
			new DLFileVersionCacheModel();

		dlFileVersionCacheModel.mvccVersion = getMvccVersion();

		dlFileVersionCacheModel.ctCollectionId = getCtCollectionId();

		dlFileVersionCacheModel.uuid = getUuid();

		String uuid = dlFileVersionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			dlFileVersionCacheModel.uuid = null;
		}

		dlFileVersionCacheModel.fileVersionId = getFileVersionId();

		dlFileVersionCacheModel.groupId = getGroupId();

		dlFileVersionCacheModel.companyId = getCompanyId();

		dlFileVersionCacheModel.userId = getUserId();

		dlFileVersionCacheModel.userName = getUserName();

		String userName = dlFileVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			dlFileVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			dlFileVersionCacheModel.createDate = createDate.getTime();
		}
		else {
			dlFileVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			dlFileVersionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			dlFileVersionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		dlFileVersionCacheModel.repositoryId = getRepositoryId();

		dlFileVersionCacheModel.folderId = getFolderId();

		dlFileVersionCacheModel.fileEntryId = getFileEntryId();

		dlFileVersionCacheModel.treePath = getTreePath();

		String treePath = dlFileVersionCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			dlFileVersionCacheModel.treePath = null;
		}

		dlFileVersionCacheModel.fileName = getFileName();

		String fileName = dlFileVersionCacheModel.fileName;

		if ((fileName != null) && (fileName.length() == 0)) {
			dlFileVersionCacheModel.fileName = null;
		}

		dlFileVersionCacheModel.extension = getExtension();

		String extension = dlFileVersionCacheModel.extension;

		if ((extension != null) && (extension.length() == 0)) {
			dlFileVersionCacheModel.extension = null;
		}

		dlFileVersionCacheModel.mimeType = getMimeType();

		String mimeType = dlFileVersionCacheModel.mimeType;

		if ((mimeType != null) && (mimeType.length() == 0)) {
			dlFileVersionCacheModel.mimeType = null;
		}

		dlFileVersionCacheModel.title = getTitle();

		String title = dlFileVersionCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			dlFileVersionCacheModel.title = null;
		}

		dlFileVersionCacheModel.description = getDescription();

		String description = dlFileVersionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			dlFileVersionCacheModel.description = null;
		}

		dlFileVersionCacheModel.changeLog = getChangeLog();

		String changeLog = dlFileVersionCacheModel.changeLog;

		if ((changeLog != null) && (changeLog.length() == 0)) {
			dlFileVersionCacheModel.changeLog = null;
		}

		dlFileVersionCacheModel.extraSettings = getExtraSettings();

		String extraSettings = dlFileVersionCacheModel.extraSettings;

		if ((extraSettings != null) && (extraSettings.length() == 0)) {
			dlFileVersionCacheModel.extraSettings = null;
		}

		dlFileVersionCacheModel.fileEntryTypeId = getFileEntryTypeId();

		dlFileVersionCacheModel.version = getVersion();

		String version = dlFileVersionCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			dlFileVersionCacheModel.version = null;
		}

		dlFileVersionCacheModel.size = getSize();

		dlFileVersionCacheModel.checksum = getChecksum();

		String checksum = dlFileVersionCacheModel.checksum;

		if ((checksum != null) && (checksum.length() == 0)) {
			dlFileVersionCacheModel.checksum = null;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			dlFileVersionCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			dlFileVersionCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date reviewDate = getReviewDate();

		if (reviewDate != null) {
			dlFileVersionCacheModel.reviewDate = reviewDate.getTime();
		}
		else {
			dlFileVersionCacheModel.reviewDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			dlFileVersionCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			dlFileVersionCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		dlFileVersionCacheModel.status = getStatus();

		dlFileVersionCacheModel.statusByUserId = getStatusByUserId();

		dlFileVersionCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = dlFileVersionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			dlFileVersionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			dlFileVersionCacheModel.statusDate = statusDate.getTime();
		}
		else {
			dlFileVersionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return dlFileVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLFileVersion, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLFileVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DLFileVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DLFileVersion, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DLFileVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((DLFileVersion)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLFileVersion>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _fileVersionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _repositoryId;
	private long _folderId;
	private long _fileEntryId;
	private String _treePath;
	private String _fileName;
	private String _extension;
	private String _mimeType;
	private String _title;
	private String _description;
	private String _changeLog;
	private String _extraSettings;
	private long _fileEntryTypeId;
	private String _version;
	private long _size;
	private String _checksum;
	private Date _expirationDate;
	private Date _reviewDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<DLFileVersion, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DLFileVersion)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("fileVersionId", _fileVersionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("repositoryId", _repositoryId);
		_columnOriginalValues.put("folderId", _folderId);
		_columnOriginalValues.put("fileEntryId", _fileEntryId);
		_columnOriginalValues.put("treePath", _treePath);
		_columnOriginalValues.put("fileName", _fileName);
		_columnOriginalValues.put("extension", _extension);
		_columnOriginalValues.put("mimeType", _mimeType);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("changeLog", _changeLog);
		_columnOriginalValues.put("extraSettings", _extraSettings);
		_columnOriginalValues.put("fileEntryTypeId", _fileEntryTypeId);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("size_", _size);
		_columnOriginalValues.put("checksum", _checksum);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("reviewDate", _reviewDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("size_", "size");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("fileVersionId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("repositoryId", 1024L);

		columnBitmasks.put("folderId", 2048L);

		columnBitmasks.put("fileEntryId", 4096L);

		columnBitmasks.put("treePath", 8192L);

		columnBitmasks.put("fileName", 16384L);

		columnBitmasks.put("extension", 32768L);

		columnBitmasks.put("mimeType", 65536L);

		columnBitmasks.put("title", 131072L);

		columnBitmasks.put("description", 262144L);

		columnBitmasks.put("changeLog", 524288L);

		columnBitmasks.put("extraSettings", 1048576L);

		columnBitmasks.put("fileEntryTypeId", 2097152L);

		columnBitmasks.put("version", 4194304L);

		columnBitmasks.put("size_", 8388608L);

		columnBitmasks.put("checksum", 16777216L);

		columnBitmasks.put("expirationDate", 33554432L);

		columnBitmasks.put("reviewDate", 67108864L);

		columnBitmasks.put("lastPublishDate", 134217728L);

		columnBitmasks.put("status", 268435456L);

		columnBitmasks.put("statusByUserId", 536870912L);

		columnBitmasks.put("statusByUserName", 1073741824L);

		columnBitmasks.put("statusDate", 2147483648L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DLFileVersion _escapedModel;

}